/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge;

import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ohf.bridge.ServiceStarter;
import org.eclipse.ohf.bridge.conf.Configurations;
import org.osgi.framework.BundleContext;

public final class BridgeActivator
extends Plugin {
    private BundleContext mContext = null;
    private static Logger mLogger;
    private static final String[] DEPENDENT_BUNDLES;

    static {
        DEPENDENT_BUNDLES = new String[]{"org.eclipse.ohf.ihe.common.atna", "org.eclipse.ohf.ihe.atna.agent", "org.eclipse.ohf.ihe.atna.audit"};
    }

    public BridgeActivator() {
        System.out.println("BridgeActivator instantiated Version 0.9.5");
    }

    public void start(BundleContext pContext) throws Exception {
        try {
            super.start(pContext);
            Configurations.load(null);
            this.mContext = pContext;
            mLogger = Logger.getLogger(BridgeActivator.class);
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"bridge started Version 0.9.5");
            }
            ServiceStarter.startDependentBundles(Configurations.getGlobalConfigurations().getProviderBundles());
            ServiceStarter.startDependentBundles(DEPENDENT_BUNDLES);
            this.validateClassLoad();
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (mLogger != null && mLogger.isEnabledFor(Priority.ERROR)) {
                mLogger.error((Object)"internal test failed, exiting application", t);
            }
            System.exit(1);
        }
    }

    private void validateClassLoad() {
    }

    public void stop(BundleContext context) throws Exception {
        Configurations.unload();
        super.stop(context);
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)"bridge is stopped");
        }
    }
}

