/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.ohf.bridge.conf.rhio.RhioConfig;
import org.eclipse.ohf.bridge.conf.rhio.XdsRepositoryConfig;
import org.eclipse.ohf.bridge.type.DateTimeRangeType;
import org.eclipse.ohf.bridge.type.GenericAdtValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Utils {
    static final Logger mLogger = Logger.getLogger(Utils.class);

    public static Map<String, URI> getMapOfRepositoryUniqueIds(RhioConfig rhioConf) {
        Map<String, XdsRepositoryConfig> mXdsRepositoryConfig = rhioConf.getXdsRepositoryConfig();
        HashMap<String, URI> mXdsRepsitoryUniqueIdMap = new HashMap<String, URI>();
        Collection<XdsRepositoryConfig> repositoryConfigurations = mXdsRepositoryConfig.values();
        for (XdsRepositoryConfig repositoryConfig : repositoryConfigurations) {
            if (!repositoryConfig.getXdsType().equals("b")) continue;
            try {
                if (repositoryConfig.getRetrieveUrl() == null || repositoryConfig.getRetrieveUrl().defaultUri() == null || repositoryConfig.getRetrieveUrl().defaultUri().equals("")) continue;
                URI repositoryUri = new URI(repositoryConfig.getRetrieveUrl().defaultUri());
                mXdsRepsitoryUniqueIdMap.put(repositoryConfig.getRepositoryUniqueId(), repositoryUri);
            }
            catch (URISyntaxException use) {
                mLogger.error((Object)"Error:  Invalid URI specified for the repository entry", (Throwable)use);
            }
        }
        return mXdsRepsitoryUniqueIdMap;
    }

    public static String trimNull(String pString) {
        if (pString == null) {
            return null;
        }
        if ((pString = pString.trim()).length() == 0 || "".equals(pString)) {
            return null;
        }
        return pString;
    }

    public static boolean isEmpty(String pString) {
        return (pString = pString.trim()).length() == 0 || "".equals(pString);
    }

    public static boolean isEmptyOrNull(String pString) {
        if (pString == null) {
            return true;
        }
        return Utils.isEmpty(pString);
    }

    public static boolean notEmpty(String pString) {
        return !Utils.isEmptyOrNull(pString);
    }

    public static void addLineToLogList(List pList, String pLine) {
        if (Utils.isEmpty(pLine = pLine.trim())) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < pLine.length()) {
            char c = pLine.charAt(i);
            if (Character.isDefined(c) && !Character.isIdentifierIgnorable(c) && !Character.isISOControl(c) && c > '\u001f') {
                sb.append(pLine.charAt(i));
            }
            ++i;
        }
        String newLine = sb.toString();
        pList.add(newLine);
    }

    public static String stringArrayAsString(String[] pArray) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = pArray;
        int n = pArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            sb.append(string);
            sb.append("    ");
            ++n2;
        }
        return sb.toString();
    }

    public static String dateTimeRangesArrayAsString(DateTimeRangeType[] pDateTimeRanges) {
        StringBuilder sb = new StringBuilder();
        DateTimeRangeType[] dateTimeRangeTypeArray = pDateTimeRanges;
        int n = pDateTimeRanges.length;
        int n2 = 0;
        while (n2 < n) {
            DateTimeRangeType range = dateTimeRangeTypeArray[n2];
            sb.append(range);
            sb.append("    ");
            ++n2;
        }
        return sb.toString();
    }

    public static void panic(String pString, Throwable t) {
        t.printStackTrace();
        mLogger.fatal((Object)pString, t);
        Utils.panic(pString);
    }

    public static void panic(String pString) {
        mLogger.fatal((Object)pString);
        System.err.println(pString);
        System.err.println("bye :-(");
        System.err.flush();
        System.out.flush();
        System.exit(1);
    }

    public static String genericAdtValuesArrayAsString(GenericAdtValue[] pGenericAdtValues) {
        StringBuilder sb = new StringBuilder();
        GenericAdtValue[] genericAdtValueArray = pGenericAdtValues;
        int n = pGenericAdtValues.length;
        int n2 = 0;
        while (n2 < n) {
            GenericAdtValue range = genericAdtValueArray[n2];
            sb.append(range);
            sb.append("    ");
            ++n2;
        }
        return sb.toString();
    }
}

