/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.conf;

import org.apache.log4j.Logger;
import org.eclipse.ohf.bridge.Utils;
import org.eclipse.ohf.bridge.conf.RhioDedicatedResources;
import org.eclipse.ohf.bridge.conf.TransactionContext;
import org.eclipse.ohf.bridge.conf.UnavailableResourcesException;
import org.eclipse.ohf.bridge.conf.rhio.RhioConfig;
import org.eclipse.ohf.bridge.type.PatientIdType;

public abstract class AbstractRhioDedicatedResources
implements RhioDedicatedResources {
    static final Logger mLogger = Logger.getLogger(AbstractRhioDedicatedResources.class);
    private RhioConfig mRhioConfiguration;

    public AbstractRhioDedicatedResources(RhioConfig pConfig) {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("new RhioDedicatedResources(" + pConfig + ") "));
        }
        this.mRhioConfiguration = pConfig;
    }

    public void normalizePatientInfo(PatientIdType pPatientId) throws UnavailableResourcesException {
        if (!pPatientId.getAssigningAuthorityType().isUseDefaultAssigningAuthority()) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"not doing normalizePatientInfo");
            }
            return;
        }
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting void normalizePatientInfo(" + pPatientId + ") " + " in " + TransactionContext.instant().getSessionContext()));
        }
        if (pPatientId == null) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"No patient ID for this one, not normalizePatientInfo");
            }
            return;
        }
        if (Utils.isEmptyOrNull(pPatientId.getAssigningAuthorityType().getNamespaceId())) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"setting AssigningAuthorityName from default");
            }
            pPatientId.getAssigningAuthorityType().setNamespaceId(this.mRhioConfiguration.getPixConfig().getPixServerProperties().getAssigningAuthorityNamespaceId());
        }
        if (Utils.isEmptyOrNull(pPatientId.getAssigningAuthorityType().getUniversalId())) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"setting AssigningAuthorityUniversalId from default");
            }
            pPatientId.getAssigningAuthorityType().setUniversalId(this.mRhioConfiguration.getPixConfig().getPixServerProperties().getAssigningAuthorityUniversalId());
        }
        if (Utils.isEmptyOrNull(pPatientId.getAssigningAuthorityType().getUniversalIdType())) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"setting AssigningAuthorityUniversalIdType from default");
            }
            pPatientId.getAssigningAuthorityType().setUniversalIdType(this.mRhioConfiguration.getPixConfig().getPixServerProperties().getAssigningAuthorityUniversalIdType());
        }
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("normalizePatientInfo normaliszed to " + pPatientId));
        }
    }

    public RhioConfig getRhioConfiguration() {
        return this.mRhioConfiguration;
    }
}

