/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.xml.DOMConfigurator;
import org.eclipse.ohf.bridge.Utils;
import org.eclipse.ohf.bridge.conf.GlobalConfigurations;
import org.eclipse.ohf.bridge.conf.RhioConfigManager;
import org.eclipse.ohf.bridge.conf.TransactionContext;
import org.eclipse.ohf.bridge.conf.builder.BridgeConfigurationException;
import org.eclipse.ohf.bridge.conf.builder.RhioConfigManagerImpl;
import org.eclipse.ohf.bridge.conf.rhio.RhioConfig;
import org.eclipse.ohf.ihe.common.atna.ConfigurationManager;
import org.eclipse.ohf.ihe.common.atna.SecurityDomain;
import org.eclipse.ohf.ihe.common.atna.SecurityDomainException;

public final class Configurations
implements GlobalConfigurations {
    public static final String PLUGIN_ID = "org.eclipse.ohf.bridge";
    private static final String BRIDGE_PROPERTIES_FILE = "bridge.properties";
    private static final String LOG_CONFIG_FILE = "log.config.file";
    private static final String RHIO_CONFIG_FILE = "rhio.config.file";
    private static final String PIX_SOURCE_CONFORMANCE_FILE = "pix.source.conformance";
    private static final String PIX_CONSUMER_CONFORMANCE_FILE = "pix.consumer.conformance";
    private static final String PDQ_CONSUMER_CONFORMANCE_FILE = "pdq.consumer.conformance";
    private static final String CDA_BASE = "cda.base.file";
    private static final String DOCUMENT_ENTRY_BASE = "document.entry.base";
    private static final String SUBMISSION_SET_BASE = "submission.set.base";
    private static final String PROVIDER_BUNDLES = "provider.bundles";
    private static final String[] PLACES_TO_LOOK = new String[]{"", "./", "/", "C:/projects/openHII/bridge.install/apache-tomcat-5.5.17/", "C:/Program Files/Apache Software Foundation/Tomcat 5.5/"};
    private static final String BRIDGE_GLOBAL_SECURITY = "BRIDGE_GLOBAL_SECURITY";
    private static final String VERIFY_URL_RESPONCE_SERVER = "verify.url.responce.server";
    private File mPIXSourceConformanceFile = null;
    private File mPIXConsumerConformanceFile = null;
    private File mPDQConsumerConformanceFile = null;
    private Properties mProperties;
    private RhioConfigManager mRhioConfigManager;
    private File mCdaBase;
    private File mDocumentEntryBase;
    private File mSubmissionSetBase;
    private static Logger mLogger;
    private static GlobalConfigurations INSTANT;
    private static String mVersion;

    public static synchronized void load(File pPropertyFile) throws IOException, URISyntaxException, SecurityDomainException, BridgeConfigurationException {
        if (INSTANT != null) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"Configuration has already started", (Throwable)new IllegalStateException());
            }
            return;
        }
        Configurations configurations = new Configurations(pPropertyFile);
        INSTANT = configurations;
        TransactionContext.setConfigurations(configurations);
    }

    private Configurations(File pPropertyFile) throws IOException, URISyntaxException, SecurityDomainException, BridgeConfigurationException {
        if (INSTANT != null) {
            throw new IllegalStateException("Only one instance of the configuration is allowed");
        }
        this.loadProperties(pPropertyFile);
        this.configureLog();
        this.configureVersion();
        this.configureSecurity();
        this.configureRhio();
        this.configureConformanceProfiles();
        this.configureCdaBase();
        this.configureDocumentEntryBase();
        this.configureSubmissionSetBase();
    }

    private void configureVersion() throws BridgeConfigurationException {
        mVersion = this.mProperties.getProperty("version");
        if (Utils.isEmptyOrNull(mVersion)) {
            throw new BridgeConfigurationException("version is not set in the bridge configuration");
        }
    }

    private void configureSecurity() throws SecurityDomainException {
        Properties properties = this.getSecurityProperties();
        if (Utils.isEmptyOrNull(properties.getProperty("javax.net.ssl.keyStore"))) {
            if (mLogger.isEnabledFor(Priority.WARN)) {
                mLogger.warn((Object)"Property [javax.net.ssl.keyStore] is not set, therefore the SecurityDomain is not initialised");
            }
            return;
        }
        SecurityDomain securityDomain = new SecurityDomain(BRIDGE_GLOBAL_SECURITY, properties);
        ConfigurationManager.registerDefaultSecurityDomain((SecurityDomain)securityDomain);
    }

    private Properties getSecurityProperties() {
        return this.mProperties;
    }

    public static GlobalConfigurations getGlobalConfigurations() {
        return INSTANT;
    }

    private File getFileUsingProperty(String pProperty) throws IOException {
        String fileName = this.getProperty(pProperty);
        File file = new File(fileName);
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Using " + pProperty + " file at " + file.getAbsolutePath()));
        }
        if (!file.exists()) {
            if (mLogger.getEffectiveLevel().isGreaterOrEqual((Priority)Level.ERROR)) {
                mLogger.debug((Object)("file " + file.getAbsolutePath() + " not found"));
            }
            throw new IllegalArgumentException(String.valueOf(pProperty) + " file does not exist at " + file.getAbsolutePath());
        }
        return file.getCanonicalFile();
    }

    private String getProperty(String pProperty) {
        String fileName = this.mProperties.getProperty(pProperty);
        if (Utils.isEmptyOrNull(fileName)) {
            throw new IllegalArgumentException("The bridge property " + pProperty + " is null");
        }
        return fileName;
    }

    public String[] getProviderBundles() {
        String prop = this.mProperties.getProperty(PROVIDER_BUNDLES);
        if (Utils.isEmptyOrNull(prop)) {
            throw new IllegalArgumentException("The bridge property provider.bundles is null, should have at least one PROVIDER_BUNDLE");
        }
        StringTokenizer st = new StringTokenizer(prop);
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    private void configureConformanceProfiles() throws IOException {
        this.mPIXConsumerConformanceFile = this.getFileUsingProperty(PIX_CONSUMER_CONFORMANCE_FILE);
        this.mPDQConsumerConformanceFile = this.getFileUsingProperty(PDQ_CONSUMER_CONFORMANCE_FILE);
    }

    private void configureCdaBase() throws IOException {
        this.mCdaBase = this.getFileUsingProperty(CDA_BASE);
    }

    private void configureSubmissionSetBase() throws IOException {
        this.mSubmissionSetBase = this.getFileUsingProperty(SUBMISSION_SET_BASE);
    }

    private void configureDocumentEntryBase() throws IOException {
        this.mDocumentEntryBase = this.getFileUsingProperty(DOCUMENT_ENTRY_BASE);
    }

    private void configureRhio() throws IOException, URISyntaxException, BridgeConfigurationException {
        boolean verify = false;
        String verifyString = this.mProperties.getProperty(VERIFY_URL_RESPONCE_SERVER);
        if (!Utils.isEmptyOrNull(verifyString) && verifyString.trim().equalsIgnoreCase("true")) {
            verify = true;
        }
        this.mRhioConfigManager = new RhioConfigManagerImpl(this.getProperty(RHIO_CONFIG_FILE), verify);
    }

    private void loadProperties(File pPropertyFile) throws IOException {
        if (pPropertyFile == null) {
            pPropertyFile = this.getPropertiesFile();
        }
        this.mProperties = new Properties();
        FileInputStream fis = new FileInputStream(pPropertyFile);
        try {
            this.mProperties.load(fis);
        }
        finally {
            fis.close();
        }
    }

    private void configureLog() throws IOException {
        String configFileName = this.mProperties.getProperty(LOG_CONFIG_FILE);
        if (Utils.isEmptyOrNull(configFileName)) {
            throw new IllegalArgumentException("The bridge property log.config.file is null");
        }
        File conf = new File(configFileName.trim()).getCanonicalFile();
        if (!conf.exists()) {
            throw new IllegalArgumentException("log configuration file does not exist at " + conf.getAbsolutePath());
        }
        DOMConfigurator.configure((String)conf.getAbsolutePath());
        mLogger = Logger.getLogger(Configurations.class);
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)"Bridge logger is configured");
        }
    }

    private File getPropertiesFile() {
        String propFilePath = System.getProperty(BRIDGE_PROPERTIES_FILE);
        File file = null;
        if (Utils.isEmptyOrNull(propFilePath)) {
            System.err.println("property bridge.properties is null. Set the bridge.properties property in your system pointing to the bridge.properties file");
            return this.searchPropertyFile();
        }
        file = new File(propFilePath);
        if (file == null) {
            throw new IllegalStateException("did not find configuration file");
        }
        if (!file.exists()) {
            System.err.println("bridge.properties file not located at: " + file.getAbsolutePath());
            throw new RuntimeException("bridge.properties file not located at: " + file.getAbsolutePath());
        }
        System.err.println("bridge.properties file located at: " + file.getAbsolutePath());
        return file;
    }

    private File searchPropertyFile() {
        int i = 0;
        while (i < PLACES_TO_LOOK.length) {
            File prop = this.searchPropFromRoot(PLACES_TO_LOOK[i]);
            if (prop != null) {
                return prop;
            }
            ++i;
        }
        return null;
    }

    private File searchPropFromRoot(String pString) {
        File current = new File(pString);
        File parent = null;
        do {
            File prop;
            File conf;
            if ((conf = this.hasConfDir(current)) != null && (prop = this.hasProperties(conf)) != null) {
                return prop;
            }
            if ((current = current.getParentFile()) != null) continue;
            return null;
        } while (!current.equals(parent = current.getParentFile()));
        return null;
    }

    private File hasConfDir(File pDir) {
        if (pDir == null) {
            return null;
        }
        System.err.println("Searching for conf directory at " + pDir.getAbsolutePath());
        File[] files = pDir.listFiles();
        if (files == null) {
            return null;
        }
        System.err.println("got " + files.length + " files in this dir");
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory() && files[i].getName().toLowerCase().endsWith("conf")) {
                System.err.println("found a conf directory at " + files[i].getAbsolutePath());
                return files[i];
            }
            ++i;
        }
        return null;
    }

    private File hasProperties(File pDir) {
        if (pDir == null) {
            return null;
        }
        File[] files = pDir.listFiles();
        if (files == null) {
            return null;
        }
        int i = 0;
        while (i < files.length) {
            if (!files[i].isDirectory()) {
                System.err.println(String.valueOf(files[i].getName()) + " is a file");
                if (files[i].getName().equalsIgnoreCase(BRIDGE_PROPERTIES_FILE)) {
                    System.err.println("got properties file at " + files[i]);
                    return files[i];
                }
            }
            ++i;
        }
        return null;
    }

    public File getPIXConsumerConformanceProfileFile() {
        return this.mPIXConsumerConformanceFile;
    }

    public File getPDQConsumerConformanceProfileFile() {
        return this.mPDQConsumerConformanceFile;
    }

    public RhioConfig getRhioConfig(String pRhio) {
        return this.mRhioConfigManager.getRhioConfig(pRhio);
    }

    public static void unload() {
        TransactionContext.unsetConfigurations();
        if (INSTANT != null) {
            INSTANT.close();
            INSTANT = null;
        }
    }

    public void close() {
        this.mRhioConfigManager.close();
    }

    public RhioConfig[] getRhios() {
        return this.mRhioConfigManager.getRhios();
    }

    public File getCdaBase() {
        return this.mCdaBase;
    }

    public File getDocumentEntryBase() {
        return this.mDocumentEntryBase;
    }

    public File getSubmissionSetBase() {
        return this.mSubmissionSetBase;
    }

    public static String getVersion() {
        return mVersion;
    }
}

