/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.consumer.query;

import org.eclipse.ohf.ihe.common.hl7v2.CX;
import org.eclipse.ohf.ihe.common.hl7v2.format.HL7V2MessageFormat;
import org.eclipse.ohf.ihe.xds.consumer.query.DateTimeRange;
import org.eclipse.ohf.ihe.xds.consumer.query.MalformedQueryException;
import org.eclipse.ohf.ihe.xds.consumer.query.Query;
import org.eclipse.ohf.ihe.xds.consumer.query.QueryBuilderUtils;
import org.eclipse.ohf.ihe.xds.metadata.AvailabilityStatusType;
import org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType;

public class FindDocumentsQuery
extends Query {
    public FindDocumentsQuery(CX patientID, AvailabilityStatusType[] status) throws MalformedQueryException {
        if (patientID == null) {
            throw new MalformedQueryException("Null patient ID. Cannot proceed with query.");
        }
        if (patientID.getIdNumber() == null) {
            throw new MalformedQueryException("Empty patient ID number. Cannot proceed with query.");
        }
        if (patientID.getAssigningAuthorityUniversalId() == null) {
            throw new MalformedQueryException("Empty patient ID assigning authority universal id. Cannot proceed with query.");
        }
        if (patientID.getAssigningAuthorityUniversalIdType() == null) {
            throw new MalformedQueryException("Empty atient ID assigning authority universal id type. Cannot proceed with query.");
        }
        if (!patientID.getAssigningAuthorityUniversalIdType().equals("ISO")) {
            throw new MalformedQueryException("Empty patient ID assigning authority universal id type is not 'ISO'. Cannot proceed with query.");
        }
        if (status == null) {
            throw new MalformedQueryException("Empty status. Cannot proceed with query.");
        }
        if (status.length == 0) {
            throw new MalformedQueryException("Empty status. Cannot proceed with query.");
        }
        if (status[0] == null) {
            throw new MalformedQueryException("Empty status. Cannot proceed with query.");
        }
        this.select.add("doc.id");
        this.from.add("ExtrinsicObject doc");
        this.from.add("ExternalIdentifier patId");
        this.where.add("doc.objectType = 'urn:uuid:7edca82f-054d-47f2-a032-9b2a5b5186c1'");
        String[] ids = new String[]{HL7V2MessageFormat.toMessageString((CX)patientID, (char)'^', (char)'&')};
        this.where.add(QueryBuilderUtils.buildIdClause("urn:uuid:58a6f841-87b3-4a3e-92fd-a8ffeff98427", ids));
        this.where.add(QueryBuilderUtils.buildStatusClause("urn:uuid:7edca82f-054d-47f2-a032-9b2a5b5186c1", status));
    }

    public FindDocumentsQuery(CX patientID, CodedMetadataType[] classCodes, DateTimeRange[] dateTimeRanges, CodedMetadataType[] practiceSettingCodes, CodedMetadataType[] healthCareFacilityCodes, CodedMetadataType[] eventCodeList, CodedMetadataType[] confidentialityCodes, CodedMetadataType[] formatCodes, AvailabilityStatusType[] status) throws MalformedQueryException {
        this(patientID, status);
        if (classCodes != null && classCodes.length > 0) {
            this.from.add("Classification clCode");
            this.where.add(QueryBuilderUtils.buildCodeClause("urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a", classCodes));
        }
        if (dateTimeRanges != null && dateTimeRanges.length > 0) {
            this.from.add("Slot dateTime");
            int i = 0;
            while (i < dateTimeRanges.length) {
                DateTimeRange dtr = dateTimeRanges[i];
                this.where.add(QueryBuilderUtils.buildDateTimeClause(dtr.getSlotName(), dtr.getFrom(), dtr.getTo()));
                ++i;
            }
        }
        if (practiceSettingCodes != null && practiceSettingCodes.length > 0) {
            this.from.add("Classification psc");
            this.where.add(QueryBuilderUtils.buildCodeClause("urn:uuid:cccf5598-8b07-4b77-a05e-ae952c785ead", practiceSettingCodes));
        }
        if (healthCareFacilityCodes != null && healthCareFacilityCodes.length > 0) {
            this.from.add("Classification hftc");
            this.where.add(QueryBuilderUtils.buildCodeClause("urn:uuid:f33fb8ac-18af-42cc-ae0e-ed0b0bdb91e1", healthCareFacilityCodes));
        }
        if (eventCodeList != null && eventCodeList.length > 0) {
            this.from.add("Classification ecl");
            this.where.add(QueryBuilderUtils.buildCodeClause("urn:uuid:2c6b8cb7-8b2a-4051-b291-b1ae6a575ef4", eventCodeList));
        }
        if (confidentialityCodes != null && confidentialityCodes.length > 0) {
            this.from.add("Classification clCode");
            this.where.add(QueryBuilderUtils.buildCodeClause("urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f", confidentialityCodes));
        }
        if (formatCodes != null && formatCodes.length > 0) {
            this.from.add("Classification formCode");
            this.where.add(QueryBuilderUtils.buildCodeClause("urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d", formatCodes));
        }
    }
}

