/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.consumer.query;

import org.eclipse.ohf.ihe.xds.consumer.query.MalformedQueryException;
import org.eclipse.ohf.ihe.xds.metadata.AvailabilityStatusType;
import org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType;

public class QueryBuilderUtils {
    public static String convert(String input) {
        String rc = input;
        int i = 0;
        while (i < rc.length()) {
            if (rc.charAt(i) == '&' && !rc.startsWith("&amp;", i)) {
                StringBuffer buf = new StringBuffer();
                buf.append(rc.substring(0, i));
                buf.append("&amp;");
                buf.append(rc.substring(i + 1, rc.length()));
                rc = buf.toString();
            }
            ++i;
        }
        return rc;
    }

    public static String buildCodeClause(String codeUUID, CodedMetadataType[] codes) throws MalformedQueryException {
        if (codeUUID == null) {
            throw new MalformedQueryException("Null parameters.");
        }
        if (codes == null) {
            throw new MalformedQueryException("Null parameters.");
        }
        if (codes.length == 0) {
            throw new MalformedQueryException("Null parameters.");
        }
        if (codes[0] == null) {
            throw new MalformedQueryException("Null parameters.");
        }
        if (codes[0].getCode() == null) {
            throw new MalformedQueryException("Null parameters: Null CodedMetadataType.code.");
        }
        StringBuffer clause = new StringBuffer("");
        if (codes.length > 0) {
            clause.append('(');
            String table = null;
            String uuid = null;
            if (codeUUID.equals("urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a")) {
                table = "clCode";
                uuid = "urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a";
            } else if (codeUUID.equals("urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f")) {
                table = "confCode";
                uuid = "urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f";
            } else if (codeUUID.equals("urn:uuid:2c6b8cb7-8b2a-4051-b291-b1ae6a575ef4")) {
                table = "ecl";
                uuid = "urn:uuid:2c6b8cb7-8b2a-4051-b291-b1ae6a575ef4";
            } else if (codeUUID.equals("urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d")) {
                table = "formCode";
                uuid = "urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d";
            } else if (codeUUID.equals("urn:uuid:f33fb8ac-18af-42cc-ae0e-ed0b0bdb91e1")) {
                table = "hftc";
                uuid = "urn:uuid:f33fb8ac-18af-42cc-ae0e-ed0b0bdb91e1";
            } else if (codeUUID.equals("urn:uuid:cccf5598-8b07-4b77-a05e-ae952c785ead")) {
                table = "psc";
                uuid = "urn:uuid:cccf5598-8b07-4b77-a05e-ae952c785ead";
            } else if (!codeUUID.equals("urn:uuid:f0306f51-975f-434e-a61c-c59651d33983")) {
                if (codeUUID.equals("urn:uuid:aa543740-bdda-424e-8c96-df4873be8500")) {
                    table = "ctc";
                    uuid = "urn:uuid:aa543740-bdda-424e-8c96-df4873be8500";
                } else {
                    codeUUID.equals("urn:uuid:1ba97051-7806-41a8-a48b-8fce7af683c5");
                }
            }
            if (uuid == null || table == null) {
                throw new MalformedQueryException("Unidentified code.");
            }
            clause.append(String.valueOf(table) + ".classifiedObject = " + "doc" + ".id");
            clause.append(" AND ");
            clause.append(String.valueOf(table) + ".classificationScheme = '" + uuid + '\'');
            clause.append(" AND ");
            clause.append(String.valueOf(table) + ".nodeRepresentation");
            if (codes.length > 1) {
                clause.append(" IN ");
                clause.append('(');
            } else {
                clause.append(" = ");
            }
            String[] codeValues = new String[codes.length];
            String[] codeSchemes = new String[codes.length];
            int i = 0;
            while (i < codes.length) {
                codeValues[i] = String.valueOf('\'') + QueryBuilderUtils.checkForSingleQuote(codes[i].getCode()) + '\'';
                codeSchemes[i] = String.valueOf('\'') + QueryBuilderUtils.checkForSingleQuote(codes[i].getSchemeName()) + '\'';
                ++i;
            }
            int valid = QueryBuilderUtils.validCodeList(codes);
            switch (valid) {
                case -1: {
                    clause.delete(0, clause.length());
                    throw new MalformedQueryException("Number of coding schemes is neither zero nor equal to the number of code values.  Cannot proceed with query building.");
                }
                case 1: {
                    clause.append(QueryBuilderUtils.buildListArgs(codeValues));
                    if (codeValues.length > 1) {
                        clause.append(')');
                    }
                    clause.append(')');
                    String schemeTable = String.valueOf(table) + "Scheme";
                    clause.append(" AND (");
                    clause.append(String.valueOf(schemeTable) + ".parent = " + table + ".id");
                    clause.append(" AND ");
                    clause.append(String.valueOf(schemeTable) + ".name = '" + "codingScheme" + '\'');
                    clause.append(" AND ");
                    clause.append(String.valueOf(schemeTable) + ".value");
                    if (codeSchemes.length > 1) {
                        clause.append(" IN ");
                        clause.append('(');
                    } else {
                        clause.append(" = ");
                    }
                    clause.append(QueryBuilderUtils.buildListArgs(codeSchemes));
                    if (codeSchemes.length > 1) {
                        clause.append(')');
                    }
                    clause.append(')');
                    break;
                }
                case 0: {
                    clause.append(QueryBuilderUtils.buildListArgs(codeValues));
                    if (codeValues.length > 1) {
                        clause.append(')');
                    }
                    clause.append(')');
                }
            }
        }
        return clause.toString();
    }

    public static String buildIdClause(String idSchemeUUID, String[] idValues) throws MalformedQueryException {
        if (idSchemeUUID == null) {
            throw new MalformedQueryException("Null parameters.");
        }
        if (idValues == null) {
            throw new MalformedQueryException("Null parameters.");
        }
        if (idValues.length == 0) {
            throw new MalformedQueryException("Null parameters.");
        }
        if (idValues == null) {
            throw new MalformedQueryException("Null parameters.");
        }
        StringBuffer clause = new StringBuffer("");
        if (idValues.length > 0) {
            clause.append('(');
            String table = null;
            String uuid = null;
            if (idSchemeUUID.equals("urn:uuid:58a6f841-87b3-4a3e-92fd-a8ffeff98427")) {
                table = "patId";
                uuid = "urn:uuid:58a6f841-87b3-4a3e-92fd-a8ffeff98427";
                clause.append(String.valueOf(table) + ".registryObject = " + "doc" + ".id");
            } else if (idSchemeUUID.equals("urn:uuid:6b5aea1a-874d-4603-a4bc-96a0a7b38446")) {
                table = "patId";
                uuid = "urn:uuid:6b5aea1a-874d-4603-a4bc-96a0a7b38446";
                clause.append(String.valueOf(table) + ".registryObject = " + "ss" + ".id");
            } else if (idSchemeUUID.equals("urn:uuid:f64ffdf0-4b97-4e06-b79f-a52b38ec2f8a")) {
                table = "patId";
                uuid = "urn:uuid:f64ffdf0-4b97-4e06-b79f-a52b38ec2f8a";
                clause.append(String.valueOf(table) + ".registryObject = " + "fol" + ".id");
            } else if (idSchemeUUID.equals("urn:uuid:2e82c1f6-a085-4c72-9da3-8640a32e42ab")) {
                table = "uId";
                uuid = "urn:uuid:2e82c1f6-a085-4c72-9da3-8640a32e42ab";
                clause.append(String.valueOf(table) + ".registryObject = " + "doc" + ".id");
            } else if (idSchemeUUID.equals("urn:uuid:96fdda7c-d067-4183-912e-bf5ee74998a8")) {
                table = "uId";
                uuid = "urn:uuid:96fdda7c-d067-4183-912e-bf5ee74998a8";
                clause.append(String.valueOf(table) + ".registryObject = " + "ss" + ".id");
            } else if (idSchemeUUID.equals("urn:uuid:75df8f67-9973-4fbe-a900-df66cefecc5a")) {
                table = "uId";
                uuid = "urn:uuid:75df8f67-9973-4fbe-a900-df66cefecc5a";
                clause.append(String.valueOf(table) + ".registryObject = " + "fol" + ".id");
            } else if (idSchemeUUID.equals("urn:uuid:554ac39e-e3fe-47fe-b233-965d2a147832")) {
                table = "sId";
                uuid = "urn:uuid:554ac39e-e3fe-47fe-b233-965d2a147832";
                clause.append(String.valueOf(table) + ".registryObject = " + "ss" + ".id");
            }
            if (uuid == null || table == null) {
                throw new MalformedQueryException("Unidentified id.");
            }
            clause.append(" AND ");
            clause.append(String.valueOf(table) + ".identificationScheme = '" + uuid + '\'');
            clause.append(" AND ");
            clause.append(String.valueOf(table) + ".value");
            if (idValues.length > 1) {
                clause.append(" IN ");
                clause.append('(');
            } else {
                clause.append(" = ");
            }
            int i = 0;
            while (i < idValues.length) {
                idValues[i] = String.valueOf('\'') + QueryBuilderUtils.checkForSingleQuote(idValues[i]) + '\'';
                ++i;
            }
            clause.append(QueryBuilderUtils.buildListArgs(idValues));
            if (idValues.length > 1) {
                clause.append(')');
            }
            clause.append(')');
        }
        return clause.toString();
    }

    public static String buildDateTimeClause(String slotName, String from, String to) throws MalformedQueryException {
        if (slotName == null) {
            throw new MalformedQueryException("Null parameters.");
        }
        if (from == null) {
            throw new MalformedQueryException("Null parameters.");
        }
        if (to == null) {
            throw new MalformedQueryException("Null parameters.");
        }
        StringBuffer clause = new StringBuffer("");
        String name = null;
        clause.append('(');
        if (slotName.equals("creationTime")) {
            name = "creationTime";
            clause.append("dateTime.parent = doc.id");
        } else if (slotName.equals("serviceStartTime")) {
            name = "serviceStartTime";
            clause.append("dateTime.parent = doc.id");
        } else if (slotName.equals("serviceStopTime")) {
            name = "serviceStopTime";
            clause.append("dateTime.parent = doc.id");
        } else if (slotName.equals("submissionTime")) {
            name = "submissionTime";
            clause.append("dateTime.parent = ss.id");
        } else if (slotName.equals("lastUpdateTime")) {
            name = "lastUpdateTime";
            clause.append("dateTime.parent = fol.id");
        }
        if (name == null) {
            throw new MalformedQueryException("Unidentified date/time slot name.");
        }
        clause.append(" AND ");
        clause.append("dateTime.name = '" + name + '\'');
        clause.append(" AND ");
        clause.append("dateTime.value >= '" + from + '\'');
        clause.append(" AND ");
        clause.append("dateTime.value < '" + to + '\'');
        clause.append(')');
        return clause.toString();
    }

    public static String buildStatusClause(String metadataUUID, AvailabilityStatusType[] status) throws MalformedQueryException {
        if (metadataUUID == null) {
            throw new MalformedQueryException("Null parameters.");
        }
        if (status == null) {
            throw new MalformedQueryException("Null parameters.");
        }
        if (status.length == 0) {
            throw new MalformedQueryException("Null parameters.");
        }
        if (status == null) {
            throw new MalformedQueryException("Null parameters.");
        }
        StringBuffer clause = new StringBuffer("");
        if (status.length > 0) {
            String table = null;
            clause.append('(');
            if (metadataUUID.equals("urn:uuid:7edca82f-054d-47f2-a032-9b2a5b5186c1")) {
                table = "doc";
            } else if (metadataUUID.equals("urn:uuid:a54d6aa5-d40d-43f9-88c5-b4633d873bdd")) {
                table = "ss";
            } else if (metadataUUID.equals("urn:uuid:d9d542f3-6cc4-48b6-8870-ea235fbc94c2")) {
                table = "fol";
            }
            if (table == null) {
                throw new MalformedQueryException("Unknown object type for status");
            }
            clause.append(String.valueOf(table) + ".status");
            if (status.length > 1) {
                clause.append(" IN ");
                clause.append('(');
            } else {
                clause.append(" = ");
            }
            String[] statusString = new String[status.length];
            int i = 0;
            while (i < status.length) {
                statusString[i] = String.valueOf('\'') + status[i].getName() + '\'';
                ++i;
            }
            clause.append(QueryBuilderUtils.buildListArgs(statusString));
            if (status.length > 1) {
                clause.append(')');
            }
            clause.append(')');
        }
        return clause.toString();
    }

    public static String buildListArgs(String[] args) {
        StringBuffer list = new StringBuffer("");
        int i = 0;
        while (i < args.length) {
            list.append(args[i]);
            if (i < args.length - 1) {
                list.append(", ");
            }
            ++i;
        }
        return list.toString();
    }

    public static String checkForSingleQuote(String s) {
        if (s == null) {
            return s;
        }
        StringBuffer buffer = new StringBuffer(s);
        int i = 0;
        while (i < buffer.length()) {
            if (buffer.charAt(i) == '\'') {
                buffer.insert(i, '\'');
                ++i;
            }
            ++i;
        }
        return buffer.toString();
    }

    public static int validCodeList(CodedMetadataType[] codes) {
        int codeCount = 0;
        int schemeNameCount = 0;
        int i = 0;
        while (i < codes.length) {
            if (codes[i].getCode() != null) {
                ++codeCount;
                if (codes[i].getSchemeName() != null) {
                    ++schemeNameCount;
                }
            } else {
                return -1;
            }
            ++i;
        }
        if (schemeNameCount == 0) {
            return 0;
        }
        if (schemeNameCount == codeCount) {
            return 1;
        }
        return -1;
    }
}

