/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.audit.element;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ohf.ihe.atna.audit.element.CodedValueType;
import org.eclipse.ohf.ihe.atna.audit.syslog.util.SyslogUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AuditSourceIdentificationType {
    public static String DB_Audit_Source_Identification_Type = "audit_source_identification";
    public static String DB_Audit_Source_TypeCode = "audit_source_type_code";
    private Element auditSourceIdentificationNode;
    protected List auditSourceTypeCode;
    protected String auditEnterpriseSiteID;
    protected String auditSourceID;
    private Document doc;

    public AuditSourceIdentificationType() throws ParserConfigurationException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.doc = builder.newDocument();
        this.auditSourceIdentificationNode = this.doc.createElement("AuditSourceIdentification");
    }

    public AuditSourceIdentificationType(String auditSourceID) throws ParserConfigurationException, FactoryConfigurationError {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.doc = builder.newDocument();
        this.auditSourceIdentificationNode = this.doc.createElement("AuditSourceIdentification");
        this.setAuditSourceID(auditSourceID);
    }

    private List getAuditSourceTypeCode() {
        if (this.auditSourceTypeCode == null) {
            this.auditSourceTypeCode = new ArrayList();
        }
        return this.auditSourceTypeCode;
    }

    public void setAuditSourceTypeCode(CodedValueType valueType) {
        if (valueType != null) {
            this.getAuditSourceTypeCode().add(valueType);
            Element el = this.doc.createElement("AuditSourceTypeCode");
            el.setAttribute("code", valueType.getCode());
            if (valueType.getCodeSystem() != null && !valueType.getCodeSystem().equals("")) {
                el.setAttribute("codeSystem", valueType.getCodeSystem());
            }
            if (valueType.getCodeSystemName() != null && !valueType.getCodeSystemName().equals("")) {
                el.setAttribute("codeSystemName", valueType.getCodeSystemName());
            }
            if (valueType.getDisplayName() != null && !valueType.getDisplayName().equals("")) {
                el.setAttribute("displayName", valueType.getDisplayName());
            }
            this.auditSourceIdentificationNode.appendChild(el);
        }
    }

    public String getAuditEnterpriseSiteID() {
        return this.auditEnterpriseSiteID;
    }

    public void setAuditEnterpriseSiteID(String value) {
        if (value != null && !value.equals("")) {
            this.auditEnterpriseSiteID = value;
            this.auditSourceIdentificationNode.setAttribute("AuditEnterpriseSiteID", value);
        }
    }

    public String getAuditSourceID() {
        return this.auditSourceID;
    }

    public void setAuditSourceID(String value) {
        if (value != null && !value.equals("")) {
            this.auditSourceID = value;
            this.auditSourceIdentificationNode.setAttribute("AuditSourceID", value);
        }
    }

    public String toXml() {
        return SyslogUtil.XMLElementToString(this.auditSourceIdentificationNode);
    }

    public String toHtml() {
        return "";
    }

    public Element getAuditSourceIdentificationNode() {
        return this.auditSourceIdentificationNode;
    }

    public static boolean isValidElement(Element e) {
        return e.getNodeName().equals("AuditSourceIdentification") && !e.getAttribute("AuditSourceID").equals("");
    }

    public void parse(Element e) {
        if (AuditSourceIdentificationType.isValidElement(e)) {
            this.setAuditSourceID(e.getAttribute("AuditSourceID"));
            if (!e.getAttribute("AuditEnterpriseSiteID").equals("")) {
                this.setAuditEnterpriseSiteID(e.getAttribute("AuditEnterpriseSiteID"));
            }
            NodeList childNodes = e.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Element child;
                if (childNodes.item(i).getNodeType() == 1 && (child = (Element)childNodes.item(i)).getNodeName().equals("AuditSourceTypeCode")) {
                    CodedValueType value = new CodedValueType();
                    value.parse(child);
                    this.setAuditSourceTypeCode(value);
                }
                ++i;
            }
        }
    }
}

