/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.audit.element;

import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ohf.ihe.atna.audit.ATNAException;
import org.eclipse.ohf.ihe.atna.audit.element.CodedValueType;
import org.eclipse.ohf.ihe.atna.audit.element.TypeValuePairType;
import org.eclipse.ohf.ihe.atna.audit.syslog.util.Base64Binary;
import org.eclipse.ohf.ihe.atna.audit.syslog.util.SyslogUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ParticipantObjectIdentificationType {
    public static String DB_ParticipantObjectId = "participant_object_identification";
    public static String DB_ObjectDetailTable = "object_detail_table";
    private Element participantObjectIdentificationNode;
    private Document doc;
    protected CodedValueType participantObjectIDTypeCode;
    protected String participantObjectName;
    protected byte[] participantObjectQuery;
    protected List participantObjectDetail;
    protected short participantObjectDataLifeCycle;
    protected String participantObjectID;
    protected String participantObjectSensitivity;
    protected short participantObjectTypeCode;
    protected short participantObjectTypeCodeRole;

    public ParticipantObjectIdentificationType() throws ParserConfigurationException, FactoryConfigurationError {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.doc = builder.newDocument();
        this.participantObjectIdentificationNode = this.doc.createElement("ParticipantObjectIdentification");
        this.participantObjectDataLifeCycle = (short)-1;
        this.participantObjectTypeCode = (short)-1;
        this.participantObjectTypeCodeRole = (short)-1;
    }

    public CodedValueType getParticipantObjectIDTypeCode() {
        return this.participantObjectIDTypeCode;
    }

    public void setParticipantObjectIDTypeCode(CodedValueType value) {
        if (value != null) {
            this.participantObjectIDTypeCode = value;
            Element el = this.doc.createElement("ParticipantObjectIDTypeCode");
            el.setAttribute("code", value.getCode());
            if (value.getCodeSystem() != null && !value.getCodeSystem().equals("")) {
                el.setAttribute("codeSystem", value.getCodeSystem());
            }
            if (value.getCodeSystemName() != null && !value.getCodeSystemName().equals("")) {
                el.setAttribute("codeSystemName", value.getCodeSystemName());
            }
            if (value.getDisplayName() != null && !value.getDisplayName().equals("")) {
                el.setAttribute("displayName", value.getDisplayName());
            }
            NodeList list = this.participantObjectIdentificationNode.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i).getNodeName().equals("ParticipantObjectIDTypeCode")) {
                    this.participantObjectIdentificationNode.removeChild(list.item(i));
                    break;
                }
                ++i;
            }
            this.participantObjectIdentificationNode.appendChild(el);
        }
    }

    public String getParticipantObjectName() {
        return this.participantObjectName;
    }

    public void setParticipantObjectName(String value) {
        if (value != null && !value.equals("")) {
            this.participantObjectName = value;
            NodeList list = this.participantObjectIdentificationNode.getChildNodes();
            boolean participantObjectQueryFound = false;
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i).getNodeName().equals("ParticipantObjectQuery")) {
                    participantObjectQueryFound = true;
                    break;
                }
                ++i;
            }
            if (!participantObjectQueryFound) {
                Element e = this.doc.createElement("ParticipantObjectName");
                e.setNodeValue(value);
                this.participantObjectIdentificationNode.appendChild(e);
            }
        }
    }

    public byte[] getParticipantObjectQuery() {
        return this.participantObjectQuery;
    }

    public void setParticipantObjectQuery(byte[] value) {
        if (value != null && value.length > 0) {
            this.participantObjectQuery = value;
            NodeList list = this.participantObjectIdentificationNode.getChildNodes();
            boolean participantObjectNameFound = false;
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i).getNodeName().equals("ParticipantObjectName")) {
                    participantObjectNameFound = true;
                    break;
                }
                ++i;
            }
            if (!participantObjectNameFound) {
                Element element = this.doc.createElement("ParticipantObjectQuery");
                String encodedstring = Base64Binary.encode(value);
                Text textElement = this.doc.createTextNode(encodedstring);
                element.appendChild(textElement);
                this.participantObjectIdentificationNode.appendChild(element);
            }
        }
    }

    public void setParticipantObjectQuery(String value) {
        this.setParticipantObjectQuery(value.getBytes());
    }

    public void setParticipantObjectDetail(TypeValuePairType type) {
        if (type != null) {
            Element e = this.doc.createElement("ParticipantObjectDetail");
            e.setAttribute("type", type.getType());
            String encodedstring = Base64Binary.encode(type.getValue());
            e.setAttribute("value", encodedstring);
            this.participantObjectIdentificationNode.appendChild(e);
            if (this.participantObjectDetail == null) {
                this.participantObjectDetail = new LinkedList();
            }
            this.participantObjectDetail.add(type);
        }
    }

    public short getParticipantObjectDataLifeCycle() {
        return this.participantObjectDataLifeCycle;
    }

    public String getParticipantObjectDataLifeCycleName() {
        switch (this.participantObjectDataLifeCycle) {
            case 1: {
                return "Origination / Creation";
            }
            case 2: {
                return "Import / Copy from original";
            }
            case 3: {
                return "Amendment";
            }
            case 4: {
                return "Verification";
            }
            case 5: {
                return "Translation";
            }
            case 6: {
                return "Access / Use";
            }
            case 7: {
                return "De-identification";
            }
            case 8: {
                return "Aggregation, summarization, derivation";
            }
            case 9: {
                return "Report";
            }
            case 10: {
                return "Export / Copy to target";
            }
            case 11: {
                return "Disclosure";
            }
            case 12: {
                return "Receipt of disclosure";
            }
            case 13: {
                return "Archiving";
            }
            case 14: {
                return "Logical deletion";
            }
            case 15: {
                return "Permanent erasure / Physical destruction";
            }
        }
        return null;
    }

    public void setParticipantObjectDataLifeCycle(short value) throws ATNAException {
        if (value > 0 && value < 16) {
            this.participantObjectDataLifeCycle = value;
            this.participantObjectIdentificationNode.setAttribute("ParticipantObjectDataLifeCycle", new Short(value).toString());
        } else if (value != -1) {
            throw new ATNAException("Invalide value for ParticipantObjectDataLifeCycle", this);
        }
    }

    public void setParticipantObjectDataLifeCycle(String value) throws NumberFormatException, ATNAException {
        this.setParticipantObjectDataLifeCycle(new Short(value));
    }

    public String getParticipantObjectID() {
        return this.participantObjectID;
    }

    public void setParticipantObjectID(String value) {
        if (value == null) {
            value = "";
        }
        this.participantObjectID = value;
        this.participantObjectIdentificationNode.setAttribute("ParticipantObjectID", value);
    }

    public String getParticipantObjectSensitivity() {
        return this.participantObjectSensitivity;
    }

    public void setParticipantObjectSensitivity(String value) {
        if (value != null && !value.equals("")) {
            this.participantObjectSensitivity = value;
            this.participantObjectIdentificationNode.setAttribute("ParticipantObjectSensitivity", value);
        }
    }

    public short getParticipantObjectTypeCode() {
        return this.participantObjectTypeCode;
    }

    public String getParticipantObjectTypeCodeName() {
        switch (this.participantObjectTypeCode) {
            case 1: {
                return "Person";
            }
            case 2: {
                return "System object";
            }
            case 3: {
                return "Organization";
            }
            case 4: {
                return "Other";
            }
        }
        return null;
    }

    public void setParticipantObjectTypeCode(short value) throws ATNAException {
        if (value > 0 && value < 5) {
            this.participantObjectTypeCode = value;
            this.participantObjectIdentificationNode.setAttribute("ParticipantObjectTypeCode", new Short(value).toString());
        } else if (value != -1) {
            throw new ATNAException("value '" + value + "' is incorrect for the paticipantObjectTypeCode field", this);
        }
    }

    public void setParticipantObjectTypeCode(String value) throws ATNAException {
        this.setParticipantObjectTypeCode(new Short(value));
    }

    public short getParticipantObjectTypeCodeRole() {
        return this.participantObjectTypeCodeRole;
    }

    public String getParticipantObjectTypeCodeRoleName() {
        switch (this.participantObjectTypeCodeRole) {
            case 1: {
                return "Patient";
            }
            case 2: {
                return "Location";
            }
            case 3: {
                return "Report";
            }
            case 4: {
                return "Resource";
            }
            case 5: {
                return "Master file";
            }
            case 6: {
                return "User";
            }
            case 7: {
                return "List";
            }
            case 8: {
                return "Doctor";
            }
            case 9: {
                return "Subscriber";
            }
            case 10: {
                return "Guarantor";
            }
            case 11: {
                return "Security User Entity";
            }
            case 12: {
                return "Security User Group";
            }
            case 13: {
                return "Security Resource";
            }
            case 14: {
                return "Security Granualarity Definition";
            }
            case 15: {
                return "Provider";
            }
            case 16: {
                return "Report Destination";
            }
            case 17: {
                return "Report Library";
            }
            case 18: {
                return "Schedule";
            }
            case 19: {
                return "Customer";
            }
            case 20: {
                return "Job";
            }
            case 21: {
                return "Job Stream";
            }
            case 22: {
                return "Table";
            }
            case 23: {
                return "Routing Criteria";
            }
            case 24: {
                return "Query";
            }
        }
        return null;
    }

    public void setParticipantObjectTypeCodeRole(short value) throws ATNAException {
        if (value > 0 && value < 25) {
            this.participantObjectTypeCodeRole = value;
            this.participantObjectIdentificationNode.setAttribute("ParticipantObjectTypeCodeRole", new Short(value).toString());
        } else if (value != -1) {
            throw new ATNAException("Invalid ParticipantObjectTypeCodeRole", this);
        }
    }

    public void setParticipantObjectTypeCodeRoleName(String value) throws ATNAException {
        if ((value = value.toLowerCase()) == "patient") {
            this.setParticipantObjectTypeCodeRole((short)1);
        } else if (value == "location") {
            this.setParticipantObjectTypeCodeRole((short)2);
        } else if (value == "report") {
            this.setParticipantObjectTypeCodeRole((short)3);
        } else if (value == "resource") {
            this.setParticipantObjectTypeCodeRole((short)4);
        } else if (value == "master file") {
            this.setParticipantObjectTypeCodeRole((short)5);
        } else if (value == "user") {
            this.setParticipantObjectTypeCodeRole((short)6);
        } else if (value == "list") {
            this.setParticipantObjectTypeCodeRole((short)7);
        } else if (value == "doctor") {
            this.setParticipantObjectTypeCodeRole((short)8);
        } else if (value == "subscriber") {
            this.setParticipantObjectTypeCodeRole((short)9);
        } else if (value == "guarantor") {
            this.setParticipantObjectTypeCodeRole((short)10);
        } else if (value == "security user entity") {
            this.setParticipantObjectTypeCodeRole((short)11);
        } else if (value == "security user group") {
            this.setParticipantObjectTypeCodeRole((short)12);
        } else if (value == "security resource") {
            this.setParticipantObjectTypeCodeRole((short)13);
        } else if (value == "security granualarity definition") {
            this.setParticipantObjectTypeCodeRole((short)14);
        } else if (value == "provider") {
            this.setParticipantObjectTypeCodeRole((short)15);
        } else if (value == "report destination") {
            this.setParticipantObjectTypeCodeRole((short)16);
        } else if (value == "report library") {
            this.setParticipantObjectTypeCodeRole((short)17);
        } else if (value == "schedule") {
            this.setParticipantObjectTypeCodeRole((short)18);
        } else if (value == "customer") {
            this.setParticipantObjectTypeCodeRole((short)19);
        } else if (value == "job") {
            this.setParticipantObjectTypeCodeRole((short)20);
        } else if (value == "job stream") {
            this.setParticipantObjectTypeCodeRole((short)21);
        } else if (value == "table") {
            this.setParticipantObjectTypeCodeRole((short)22);
        } else if (value == "routing criteria") {
            this.setParticipantObjectTypeCodeRole((short)23);
        } else if (value == "query") {
            this.setParticipantObjectTypeCodeRole((short)24);
        } else {
            throw new ATNAException("Invalid string for ParticipantObjectTypeCodeRoleName", this);
        }
    }

    public void setParticipantObjectTypeCodeRole(String value) throws ATNAException {
        this.setParticipantObjectTypeCodeRole(new Short(value));
    }

    public String toXml() {
        return SyslogUtil.XMLElementToString(this.participantObjectIdentificationNode);
    }

    public String toHtml() {
        return "";
    }

    public Element getParticipantObjectIdentificationNode() {
        return this.participantObjectIdentificationNode;
    }

    public static boolean IsValidElement(Element el) {
        if (el.getNodeName().equals("ParticipantObjectIdentification")) {
            return !el.getAttribute("ParticipantObjectID").equals("");
        }
        return false;
    }

    public void parse(Element el) throws ATNAException {
        if (ParticipantObjectIdentificationType.IsValidElement(el)) {
            this.setParticipantObjectID(el.getAttribute("ParticipantObjectID"));
            if (!el.getAttribute("ParticipantObjectTypeCode").equals("")) {
                this.setParticipantObjectTypeCode(el.getAttribute("ParticipantObjectTypeCode"));
            }
            if (!el.getAttribute("ParticipantObjectTypeCodeRole").equals("")) {
                this.setParticipantObjectTypeCodeRole(el.getAttribute("ParticipantObjectTypeCodeRole"));
            }
            if (!el.getAttribute("ParticipantObjectDataLifeCycle").equals("")) {
                this.setParticipantObjectDataLifeCycle(el.getAttribute("ParticipantObjectDataLifeCycle"));
            }
            if (!el.getAttribute("ParticipantObjectSensitivity").equals("")) {
                this.setParticipantObjectSensitivity(el.getAttribute("ParticipantObjectSensitivity"));
            }
            NodeList list = el.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i).getNodeType() == 1) {
                    Element childElement = (Element)list.item(i);
                    if (childElement.getNodeName().equals("ParticipantObjectName")) {
                        this.setParticipantObjectName(el.getAttribute("ParticipantObjectName"));
                    }
                    if (childElement.getNodeName().equals("ParticipantObjectQuery")) {
                        NodeList childParticipantObjectQuery = childElement.getChildNodes();
                        int j = 0;
                        while (j < childParticipantObjectQuery.getLength()) {
                            if (childParticipantObjectQuery.item(j).getNodeType() == 3) {
                                Text textElement = (Text)childParticipantObjectQuery.item(j);
                                this.setParticipantObjectQuery(textElement.getNodeValue());
                            }
                            ++j;
                        }
                    }
                    if (childElement.getNodeName().equals("ParticipantObjectDetail")) {
                        TypeValuePairType valuePair = new TypeValuePairType();
                        valuePair.parse(childElement);
                        this.setParticipantObjectDetail(valuePair);
                    }
                    if (childElement.getNodeName().equals("ParticipantObjectIDTypeCode")) {
                        CodedValueType codedValueType = new CodedValueType();
                        codedValueType.parse(childElement);
                        this.setParticipantObjectIDTypeCode(codedValueType);
                    }
                }
                ++i;
            }
        }
    }
}

