/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.audit.messages;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ohf.ihe.atna.audit.ATNAException;
import org.eclipse.ohf.ihe.atna.audit.codes.AuditActiveParticipantRoleID;
import org.eclipse.ohf.ihe.atna.audit.codes.AuditEventID;
import org.eclipse.ohf.ihe.atna.audit.element.ActiveParticipantType;
import org.eclipse.ohf.ihe.atna.audit.element.CodedValueType;
import org.eclipse.ohf.ihe.atna.audit.element.EventIdentificationType;
import org.eclipse.ohf.ihe.atna.audit.element.ParticipantObjectIdentificationType;
import org.eclipse.ohf.ihe.atna.audit.messages.AuditMessage;
import org.eclipse.ohf.ihe.atna.audit.util.AddressUtils;

public class ImportMessage
extends AuditMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROP_SAMPLE_PROPERTY = "sampleProperty";
    private String sampleProperty;
    private PropertyChangeSupport propertySupport;

    public String getSampleProperty() {
        return this.sampleProperty;
    }

    public void setSampleProperty(String value) {
        String oldValue = this.sampleProperty;
        this.sampleProperty = value;
        this.propertySupport.firePropertyChange(PROP_SAMPLE_PROPERTY, oldValue, this.sampleProperty);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public ImportMessage() throws ParserConfigurationException, FactoryConfigurationError, ATNAException {
        this.setMessagetype("import");
        if (this.getEventIdentification() != null) {
            this.getEventIdentification().setEventActionCode("C");
            CodedValueType eventIDValue = new CodedValueType();
            eventIDValue.setCode("110107");
            eventIDValue.setCodeSystemName("DCM");
            eventIDValue.setDisplayName("Import");
            this.getEventIdentification().setEventID(eventIDValue);
        }
    }

    public ImportMessage(String eventDateTime, int eventOutcomeIndicator, String userIDActiveParticipantConsumer, String userIDActiveParticipantRegistry, String participantObjectPatientId, String[] importedDataId, String sourceId, CodedValueType transaction) throws ParserConfigurationException, FactoryConfigurationError, ATNAException {
        super(sourceId);
        ParticipantObjectIdentificationType participantObject;
        this.setMessagetype("import");
        EventIdentificationType eventId = new EventIdentificationType();
        eventId.setEventActionCode("R");
        eventId.setEventDateTime(eventDateTime);
        eventId.setEventOutcomeIndicator(eventOutcomeIndicator);
        if (transaction != null) {
            eventId.setEventTypeCode(transaction);
        }
        eventId.setEventID(new AuditEventID.Import());
        this.setEventIdentification(eventId);
        ActiveParticipantType activeParticipantDocRegistry = null;
        activeParticipantDocRegistry = new ActiveParticipantType(userIDActiveParticipantRegistry);
        activeParticipantDocRegistry.setUserIsRequestor(false);
        activeParticipantDocRegistry.setRoleIDCode(new AuditActiveParticipantRoleID.Destination());
        AddressUtils.setNetworkAccessPointCodes(activeParticipantDocRegistry, AddressUtils.getRemoteAddressByURL(userIDActiveParticipantRegistry));
        this.setActiveParticipant(activeParticipantDocRegistry);
        ActiveParticipantType activeParticipantDocConsumer = null;
        activeParticipantDocConsumer = new ActiveParticipantType(userIDActiveParticipantConsumer);
        activeParticipantDocConsumer.setUserIsRequestor(true);
        activeParticipantDocConsumer.setRoleIDCode(new AuditActiveParticipantRoleID.Source());
        AddressUtils.setNetworkAccessPointCodes(activeParticipantDocConsumer, AddressUtils.getLocalAddress());
        this.setActiveParticipant(activeParticipantDocConsumer);
        if (participantObjectPatientId != null) {
            participantObject = new ParticipantObjectIdentificationType();
            participantObject.setParticipantObjectTypeCode((short)1);
            participantObject.setParticipantObjectTypeCodeRoleName("patient");
            CodedValueType objectIDTypeCode = new CodedValueType();
            objectIDTypeCode.setCode("2");
            participantObject.setParticipantObjectIDTypeCode(objectIDTypeCode);
            participantObject.setParticipantObjectID(participantObjectPatientId);
            this.setParticipationObjectIdentification(participantObject);
        }
        if (importedDataId != null && importedDataId.length > 0) {
            int index = 0;
            while (index < importedDataId.length) {
                participantObject = new ParticipantObjectIdentificationType();
                participantObject.setParticipantObjectTypeCode((short)2);
                participantObject.setParticipantObjectTypeCodeRoleName("report");
                CodedValueType code4 = new CodedValueType();
                code4.setCode("9");
                participantObject.setParticipantObjectIDTypeCode(code4);
                participantObject.setParticipantObjectID(importedDataId[index]);
                this.setParticipationObjectIdentification(participantObject);
                ++index;
            }
        }
    }
}

