/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.common.ws;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.eclipse.ohf.ihe.atna.agent.AtnaAgent;
import org.eclipse.ohf.ihe.atna.agent.AtnaAgentFactory;
import org.eclipse.ohf.ihe.common.atna.ConfigurationManager;
import org.eclipse.ohf.ihe.common.atna.NoSecurityDomainException;
import org.eclipse.ohf.ihe.common.atna.SecurityDomain;
import org.eclipse.ohf.ihe.common.ws.OHFSOAPAttachmentSender;
import org.eclipse.ohf.ihe.common.ws.OHFSOAPException;
import org.eclipse.ohf.ihe.common.ws.OHFSOAPSender;
import org.eclipse.ohf.ihe.common.ws.modules.WSAddressing;
import org.eclipse.ohf.ihe.common.ws.utils.OHFSOAPUtils;
import org.eclipse.ohf.ihe.common.ws.utils.OHFSocketFactoryWrapper;
import org.eclipse.ohf.ihe.common.ws.utils.UUIDGenerator;

public abstract class AbstractOHFSOAPSender
implements OHFSOAPSender,
OHFSOAPAttachmentSender {
    private URI mEndpoint;
    private ServiceClient mSender;
    private Options mOptions;
    private String mAction;
    private MessageContext requestMessageContext;
    private MessageContext responseMessageContext;
    private SecurityDomain securityDomain;
    private SOAPFactory soapFactory;
    static /* synthetic */ Class class$0;

    protected AbstractOHFSOAPSender() throws OHFSOAPException {
        try {
            this.mOptions = new Options();
            this.mOptions.setTimeOutInMilliSeconds(100000L);
            this.mSender = new ServiceClient();
            this.mSender.setOptions(this.mOptions);
            this.soapFactory = OMAbstractFactory.getSOAP12Factory();
        }
        catch (AxisFault af) {
            throw new OHFSOAPException("Error while creating the SOAP Sender", af);
        }
    }

    private void configureAddressing() throws AxisFault {
        String messageId = UUIDGenerator.generateURN();
        this.mOptions.setMessageId(messageId);
        if (this.getAction() != null && !OHFSOAPUtils.isNullOrEmpty(this.getAction())) {
            WSAddressing wsaAddressingModule = new WSAddressing(this.getAction(), this.getEndpoint().toString(), messageId);
            wsaAddressingModule.processOutgoing(this.requestMessageContext.getEnvelope());
            this.mOptions.setAction(this.getAction());
            try {
                this.mSender.engageModule("addressing-1.3");
            }
            catch (Throwable throwable) {}
        } else {
            try {
                this.mSender.disengageModule("addressing-1.3");
            }
            catch (Throwable throwable) {}
            this.mOptions.setAction("");
        }
    }

    private void configureTransportProtocol() throws NoSuchAlgorithmException, NoSecurityDomainException, KeyManagementException, UnknownHostException, IOException {
        if (!ConfigurationManager.isTLSEnabled() && !ConfigurationManager.isNonTLSConnectionsPermitted()) {
            StringBuffer stringBuffer = new StringBuffer("TLS has been disabled for ATNA connections via ");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.common.atna.ConfigurationManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new NoSuchAlgorithmException(stringBuffer.append(clazz.getName()).append(".setSetTLSEnabled(false)").toString());
        }
        if (this.isDoingTLS()) {
            this.securityDomain = ConfigurationManager.getSecurityDomain((URI)this.mEndpoint);
            this.securityDomain.setDomainEnvironment();
        }
        AtnaAgent agent = AtnaAgentFactory.getAtnaAgent();
        if (this.isDoingTLS()) {
            Protocol sProtocol = new Protocol("https", (ProtocolSocketFactory)new OHFSocketFactoryWrapper(agent.getSocket(this.mEndpoint, true)), 443);
            Protocol.registerProtocol((String)"https", (Protocol)sProtocol);
        } else {
            Protocol sProtocol = new Protocol("http", (ProtocolSocketFactory)new OHFSocketFactoryWrapper(agent.getSocket(this.mEndpoint, false)), 80);
            Protocol.registerProtocol((String)"http", (Protocol)sProtocol);
        }
    }

    public SOAPEnvelope createEnvelope() {
        SOAPEnvelope envelope = this.soapFactory.createSOAPEnvelope();
        this.soapFactory.createSOAPBody(envelope);
        this.soapFactory.createSOAPHeader(envelope);
        envelope.build();
        return envelope;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeSend() throws OHFSOAPException {
        try {
            try {
                if (this.getEndpoint() == null) throw new OHFSOAPException("No Service Endpoint Defined");
                if (OHFSOAPUtils.isNullOrEmpty(this.getEndpoint().toString())) {
                    throw new OHFSOAPException("No Service Endpoint Defined");
                }
                if (this.requestMessageContext == null) {
                    throw new OHFSOAPException("A MessageContext must be set before send.");
                }
                this.configureTransportProtocol();
                this.mOptions.setTo(new EndpointReference(this.mEndpoint.toString()));
                if (this.useHttpChunking()) {
                    this.requestMessageContext.setProperty("__CHUNKED__", (Object)"true");
                } else {
                    this.requestMessageContext.setProperty("__CHUNKED__", (Object)"false");
                }
                OperationClient sendClient = this.mSender.createClient(ServiceClient.ANON_OUT_IN_OP);
                sendClient.addMessageContext(this.requestMessageContext);
                sendClient.execute(true);
                this.responseMessageContext = sendClient.getMessageContext("In");
            }
            catch (AxisFault af) {
                throw new OHFSOAPException("Error Sending SOAP Message.", af);
            }
            catch (Exception e) {
                throw new OHFSOAPException("Error Sending SOAP Message", e);
            }
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this.resetTransportProtocol();
            throw throwable;
        }
        {
            Object var2_6 = null;
            this.resetTransportProtocol();
            return;
        }
    }

    protected String getAction() {
        return this.mAction;
    }

    public URI getEndpoint() {
        return this.mEndpoint;
    }

    protected Options getOptions() {
        return this.mOptions;
    }

    protected SOAPFactory getSOAPFactory() {
        return this.soapFactory;
    }

    private boolean isDoingTLS() {
        if (this.mEndpoint == null || this.mEndpoint.getScheme() == null) {
            return false;
        }
        return this.mEndpoint.getScheme().equalsIgnoreCase("https") && ConfigurationManager.isTLSEnabled() || !ConfigurationManager.isNonTLSConnectionsPermitted();
    }

    private void resetTransportProtocol() {
        Protocol.unregisterProtocol((String)"http");
        Protocol.unregisterProtocol((String)"https");
        if (this.isDoingTLS() && this.securityDomain != null) {
            this.securityDomain.restoreSystemEnvironment();
        }
    }

    public SOAPEnvelope send(SOAPEnvelope envelope) throws OHFSOAPException {
        return this.send(envelope, new HashMap());
    }

    public SOAPEnvelope send(SOAPEnvelope envelope, Map attachments) throws OHFSOAPException {
        try {
            this.requestMessageContext = new MessageContext();
            this.requestMessageContext.setEnvelope(envelope);
            if (attachments != null && attachments.size() > 0) {
                Set attachmentSet = attachments.keySet();
                Iterator attachmentIterator = attachmentSet.iterator();
                while (attachmentIterator.hasNext()) {
                    Object mapKey = attachmentIterator.next();
                    if (!(mapKey instanceof String)) continue;
                    this.requestMessageContext.addAttachment((String)mapKey, (DataHandler)attachments.get(mapKey));
                }
            } else {
                this.getOptions().setProperty("enableMTOM", (Object)"false");
                this.getOptions().setProperty("enableSwA", (Object)"false");
            }
            this.configureAddressing();
            this.executeSend();
            SOAPEnvelope responseEnvelope = this.responseMessageContext.getEnvelope();
            return responseEnvelope;
        }
        catch (AxisFault af) {
            throw new OHFSOAPException("Error Preparing SOAP Message for Send", af);
        }
    }

    public SOAPEnvelope send(SOAPEnvelope message, Map attachments, String action) throws OHFSOAPException {
        this.setAction(action);
        return this.send(message, attachments);
    }

    public SOAPEnvelope send(SOAPEnvelope envelope, String action) throws OHFSOAPException {
        this.setAction(action);
        return this.send(envelope, new HashMap());
    }

    protected void setAction(String action) {
        this.mAction = action;
    }

    public void setEndpoint(String endpoint) throws OHFSOAPException {
        try {
            this.setEndpoint(new URI(endpoint));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new OHFSOAPException("Invalid endpiont URI specified");
        }
    }

    public void setEndpoint(URI endpoint) {
        this.mEndpoint = endpoint;
    }

    protected void setOptions(Options options) {
        this.mOptions = options;
    }

    protected void setSOAPFactory(SOAPFactory factory) {
        this.soapFactory = factory;
    }

    private boolean useHttpChunking() {
        String property = System.getProperty("use.http.chunking");
        return property != null && property.toLowerCase().equals("true");
    }
}

