/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.common.ws.modules;

import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;

public class WSAddressing {
    public static final String WSA_ACTION_KEY = "Action";
    public static final String WSA_MESSAGE_ID_KEY = "MessageID";
    public static final String WSA_REPLY_TO_KEY = "ReplyTo";
    public static final String WSA_TO_KEY = "To";
    public static final String WSA_ADDRESS_ANONYMOUS = "http://www.w3.org/2005/08/addressing/anonymous";
    public static final String WSA_NAMESPACE_URI = "http://www.w3.org/2005/08/addressing";
    public static final String WSA_NAMESPACE_PREFIX = "wsa";
    private Map mSettings = new HashMap();

    public WSAddressing() {
        this.mSettings.put(WSA_REPLY_TO_KEY, WSA_ADDRESS_ANONYMOUS);
    }

    public WSAddressing(Map settings) {
        this.mSettings.put(WSA_REPLY_TO_KEY, WSA_ADDRESS_ANONYMOUS);
        if (settings != null) {
            this.mSettings = settings;
        }
    }

    public WSAddressing(String action, String destination) {
        this(action, destination, null, null);
    }

    public WSAddressing(String action, String destination, String messageId) {
        this(action, destination, messageId, null);
    }

    public WSAddressing(String action, String destination, String messageId, String replyTo) {
        this.mSettings.put(WSA_REPLY_TO_KEY, WSA_ADDRESS_ANONYMOUS);
        if (action != null) {
            this.mSettings.put(WSA_ACTION_KEY, action);
        }
        if (destination != null) {
            this.mSettings.put(WSA_TO_KEY, destination);
        }
        if (messageId != null) {
            this.mSettings.put(WSA_MESSAGE_ID_KEY, messageId);
        } else {
            this.mSettings.put(WSA_MESSAGE_ID_KEY, UUIDGenerator.getUUID());
        }
        if (replyTo != null) {
            this.mSettings.put(WSA_REPLY_TO_KEY, replyTo);
        }
    }

    public void processOutgoing(SOAPEnvelope message) {
        if (message == null) {
            return;
        }
        SOAPHeader messageHeader = message.getHeader();
        OMNamespace wsaNamespace = messageHeader.declareNamespace(WSA_NAMESPACE_URI, WSA_NAMESPACE_PREFIX);
        SOAPHeaderBlock wsaActionBlock = messageHeader.addHeaderBlock(WSA_ACTION_KEY, wsaNamespace);
        wsaActionBlock.setMustUnderstand("1");
        wsaActionBlock.setText((String)this.mSettings.get(WSA_ACTION_KEY));
        SOAPHeaderBlock wsaToBlock = messageHeader.addHeaderBlock(WSA_TO_KEY, wsaNamespace);
        wsaToBlock.setMustUnderstand("1");
        wsaToBlock.setText((String)this.mSettings.get(WSA_TO_KEY));
        SOAPHeaderBlock wsaMessageIdBlock = messageHeader.addHeaderBlock(WSA_MESSAGE_ID_KEY, wsaNamespace);
        wsaMessageIdBlock.setText((String)this.mSettings.get(WSA_MESSAGE_ID_KEY));
        SOAPHeaderBlock wsaReplyToBlock = messageHeader.addHeaderBlock(WSA_REPLY_TO_KEY, wsaNamespace);
        OMElement wsaReplyToAddress = wsaReplyToBlock.getOMFactory().createOMElement("Address", wsaNamespace);
        wsaReplyToAddress.setText((String)this.mSettings.get(WSA_REPLY_TO_KEY));
        wsaReplyToBlock.addChild((OMNode)wsaReplyToAddress);
    }

    public void processIncoming(SOAPEnvelope message) {
    }
}

