/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.ihe.pixpdq;

import java.net.URISyntaxException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.ohf.bridge.BridgeException;
import org.eclipse.ohf.bridge.conf.TransactionContext;
import org.eclipse.ohf.bridge.conf.rhio.ApplicationAndFacilityProperties;
import org.eclipse.ohf.bridge.ihe.pixpdq.IhePixPdqResourcesFactory;
import org.eclipse.ohf.bridge.ihe.pixpdq.PixPdqResources;
import org.eclipse.ohf.bridge.ihe.pixpdq.PixUtils;
import org.eclipse.ohf.bridge.pix.PIXSourceBridge;
import org.eclipse.ohf.bridge.type.PatientInfoType;
import org.eclipse.ohf.bridge.type.ResponseType;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessage;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageException;
import org.eclipse.ohf.ihe.common.hl7v2.mllpclient.ClientException;
import org.eclipse.ohf.ihe.pix.source.PixMsgADT;
import org.eclipse.ohf.ihe.pix.source.PixMsgAdmitInpatient;
import org.eclipse.ohf.ihe.pix.source.PixMsgMergePatient;
import org.eclipse.ohf.ihe.pix.source.PixMsgPreadmitInpatient;
import org.eclipse.ohf.ihe.pix.source.PixMsgRegisterOutpatient;
import org.eclipse.ohf.ihe.pix.source.PixMsgUpdatePatient;
import org.eclipse.ohf.ihe.pix.source.PixSourceException;
import org.eclipse.ohf.ihe.pix.source.PixSourceResponse;
import org.eclipse.ohf.utilities.OHFException;

public class IhePIXSourceBridge
implements PIXSourceBridge {
    private static final Logger mLogger = Logger.getLogger(IhePIXSourceBridge.class);

    public ResponseType admitInpatient(PatientInfoType patientInfo) throws OHFException, URISyntaxException, BridgeException {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting String admitInpatient(" + patientInfo + ") " + " in " + TransactionContext.instant().getSessionContext()));
        }
        patientInfo.getPatientIdentifier().getAssigningAuthorityType().applyPixSourceDefaults();
        PixPdqResources resources = IhePixPdqResourcesFactory.getResources();
        String namespaceId = patientInfo.getPatientIdentifier().getAssigningAuthorityType().getNamespaceId();
        String universalId = patientInfo.getPatientIdentifier().getAssigningAuthorityType().getUniversalId();
        String universalIdType = patientInfo.getPatientIdentifier().getAssigningAuthorityType().getUniversalIdType();
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)"sending to the PIX server");
        }
        PixMsgAdmitInpatient admitPatient = resources.getPixSourcePixDestination().admitInpatient(patientInfo.getPatientIdentifier().getIdNumber(), namespaceId, universalId, universalIdType);
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("got admitPatient: " + admitPatient));
        }
        TransactionContext.instant().getSessionContext();
        PixUtils.populateMessageWithApplicationAndFacility((PixPdqMessage)admitPatient, resources.getPixSourceProperties(), (ApplicationAndFacilityProperties)resources.getRhioConfiguration().getPixConfig().getPixServerProperties());
        PixUtils.feedPixMsgADT((PixMsgADT)admitPatient, patientInfo);
        PixSourceResponse response = resources.getPixSourcePixDestination().sendAdmission(admitPatient, false);
        ResponseType responseType = PixUtils.handleResponse(response);
        if (!responseType.isSuccess()) {
            if (mLogger.getEffectiveLevel().isGreaterOrEqual((Priority)Level.ERROR)) {
                mLogger.debug((Object)"could not admit the inpatient in the PIX server, will not attempt to register in the XDS");
            }
            return responseType;
        }
        if (resources.getPixSourceXdsDestination() == null) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"don't have an XdsDestination");
            }
            return responseType;
        }
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)"registering with the XDS");
        }
        if (!(responseType = PixUtils.handleResponse(response = resources.getPixSourceXdsDestination().sendAdmission(admitPatient, false))).isSuccess() && mLogger.getEffectiveLevel().isGreaterOrEqual((Priority)Level.ERROR)) {
            mLogger.debug((Object)"could not register the patient in the XDS server");
        }
        return responseType;
    }

    public ResponseType registerOutpatient(PatientInfoType patientInfo) throws Exception {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting String registerOutpatient(" + patientInfo + ") " + " in " + TransactionContext.instant().getSessionContext()));
        }
        patientInfo.getPatientIdentifier().getAssigningAuthorityType().applyPixSourceDefaults();
        PixPdqResources resources = IhePixPdqResourcesFactory.getResources();
        String namespaceId = patientInfo.getPatientIdentifier().getAssigningAuthorityType().getNamespaceId();
        String universalId = patientInfo.getPatientIdentifier().getAssigningAuthorityType().getUniversalId();
        String universalIdType = patientInfo.getPatientIdentifier().getAssigningAuthorityType().getUniversalIdType();
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)"sending to the PIX server");
        }
        PixMsgRegisterOutpatient registerPatient = resources.getPixSourcePixDestination().registerOutpatient(patientInfo.getPatientIdentifier().getIdNumber(), namespaceId, universalId, universalIdType);
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("got registerPatient: " + registerPatient));
        }
        TransactionContext.instant().getSessionContext();
        PixUtils.populateMessageWithApplicationAndFacility((PixPdqMessage)registerPatient, resources.getPixSourceProperties(), (ApplicationAndFacilityProperties)resources.getRhioConfiguration().getPixConfig().getPixServerProperties());
        PixUtils.populateMessageWithApplicationAndFacility((PixPdqMessage)registerPatient, resources.getPixSourceProperties(), (ApplicationAndFacilityProperties)resources.getRhioConfiguration().getPixConfig().getPixServerProperties());
        PixUtils.feedPixMsgADT((PixMsgADT)registerPatient, patientInfo);
        PixSourceResponse response = resources.getPixSourcePixDestination().sendRegistration(registerPatient, false);
        ResponseType responseType = PixUtils.handleResponse(response);
        if (!responseType.isSuccess()) {
            if (mLogger.getEffectiveLevel().isGreaterOrEqual((Priority)Level.ERROR)) {
                mLogger.debug((Object)"could not register the patient in the PIX server, will not attempt to register in the XDS");
            }
            return responseType;
        }
        if (resources.getPixSourceXdsDestination() == null) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"don't have an XdsDestination");
            }
            return responseType;
        }
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)"registering with the XDS");
        }
        if (!(responseType = PixUtils.handleResponse(response = resources.getPixSourceXdsDestination().sendRegistration(registerPatient, false))).isSuccess() && mLogger.getEffectiveLevel().isGreaterOrEqual((Priority)Level.ERROR)) {
            mLogger.debug((Object)"could not register the patient in the XDS server");
        }
        return responseType;
    }

    public ResponseType preAdmitInpatient(PatientInfoType patientInfo) throws OHFException, URISyntaxException, BridgeException {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting String preAdmitInpatient(" + patientInfo + ") " + " in " + TransactionContext.instant().getSessionContext()));
        }
        patientInfo.getPatientIdentifier().getAssigningAuthorityType().applyPixSourceDefaults();
        PixPdqResources resources = IhePixPdqResourcesFactory.getResources();
        String namespaceId = patientInfo.getPatientIdentifier().getAssigningAuthorityType().getNamespaceId();
        String universalId = patientInfo.getPatientIdentifier().getAssigningAuthorityType().getUniversalId();
        String universalIdType = patientInfo.getPatientIdentifier().getAssigningAuthorityType().getUniversalIdType();
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)"sending to the PIX server");
        }
        PixMsgPreadmitInpatient preadmitPatient = resources.getPixSourcePixDestination().preadmitInpatient(patientInfo.getPatientIdentifier().getIdNumber(), namespaceId, universalId, universalIdType);
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("got registerPatient: " + preadmitPatient));
        }
        TransactionContext.instant().getSessionContext();
        PixUtils.populateMessageWithApplicationAndFacility((PixPdqMessage)preadmitPatient, resources.getPixSourceProperties(), (ApplicationAndFacilityProperties)resources.getRhioConfiguration().getPixConfig().getPixServerProperties());
        PixUtils.feedPixMsgADT((PixMsgADT)preadmitPatient, patientInfo);
        PixSourceResponse response = resources.getPixSourcePixDestination().sendPreAdmission(preadmitPatient, false);
        ResponseType responseType = PixUtils.handleResponse(response);
        if (!responseType.isSuccess()) {
            if (mLogger.getEffectiveLevel().isGreaterOrEqual((Priority)Level.ERROR)) {
                mLogger.debug((Object)"could not preadmit the patient in the PIX server, will not attempt to register in the XDS");
            }
            return responseType;
        }
        if (resources.getPixSourceXdsDestination() == null) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"don't have an XdsDestination");
            }
            return responseType;
        }
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)"registering with the XDS");
        }
        if (!(responseType = PixUtils.handleResponse(response = resources.getPixSourceXdsDestination().sendPreAdmission(preadmitPatient, false))).isSuccess() && mLogger.getEffectiveLevel().isGreaterOrEqual((Priority)Level.ERROR)) {
            mLogger.debug((Object)"could not register the patient in the XDS server");
        }
        return responseType;
    }

    public ResponseType updateOutPatient(PatientInfoType patientInfo) throws PixSourceException, ClientException, HL7V2Exception, URISyntaxException, PixPdqMessageException, BridgeException {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting String updateOutPatient(" + patientInfo + ") " + " in " + TransactionContext.instant().getSessionContext()));
        }
        return this.updatePatient(patientInfo, "O");
    }

    public ResponseType updateInPatient(PatientInfoType patientInfo) throws PixSourceException, ClientException, HL7V2Exception, URISyntaxException, PixPdqMessageException, BridgeException {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting String updateInPatient(" + patientInfo + ") " + " in " + TransactionContext.instant().getSessionContext()));
        }
        return this.updatePatient(patientInfo, "I");
    }

    private ResponseType updatePatient(PatientInfoType patientInfo, String pType) throws PixSourceException, ClientException, HL7V2Exception, URISyntaxException, PixPdqMessageException, BridgeException {
        patientInfo.getPatientIdentifier().getAssigningAuthorityType().applyPixSourceDefaults();
        PixPdqResources resources = IhePixPdqResourcesFactory.getResources();
        String namespaceId = patientInfo.getPatientIdentifier().getAssigningAuthorityType().getNamespaceId();
        String universalId = patientInfo.getPatientIdentifier().getAssigningAuthorityType().getUniversalId();
        String universalIdType = patientInfo.getPatientIdentifier().getAssigningAuthorityType().getUniversalIdType();
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)"sending to the PIX server");
        }
        PixMsgUpdatePatient message = resources.getPixSourcePixDestination().updatePatient(patientInfo.getPatientIdentifier().getIdNumber(), namespaceId, universalId, universalIdType, pType);
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("got updatePatient: " + message));
        }
        TransactionContext.instant().getSessionContext();
        PixUtils.populateMessageWithApplicationAndFacility((PixPdqMessage)message, resources.getPixSourceProperties(), (ApplicationAndFacilityProperties)resources.getRhioConfiguration().getPixConfig().getPixServerProperties());
        PixUtils.feedPixMsgADT((PixMsgADT)message, patientInfo);
        PixSourceResponse response = resources.getPixSourcePixDestination().sendUpdate(message, false);
        ResponseType responseType = PixUtils.handleResponse(response);
        if (!responseType.isSuccess()) {
            if (mLogger.getEffectiveLevel().isGreaterOrEqual((Priority)Level.ERROR)) {
                mLogger.debug((Object)"could not preadmit the patient in the PIX server, will not attempt to register in the XDS");
            }
            return responseType;
        }
        if (resources.getPixSourceXdsDestination() == null) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"don't have an XdsDestination");
            }
            return responseType;
        }
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)"registering with the XDS");
        }
        if (!(responseType = PixUtils.handleResponse(response = resources.getPixSourceXdsDestination().sendUpdate(message, false))).isSuccess() && mLogger.getEffectiveLevel().isGreaterOrEqual((Priority)Level.ERROR)) {
            mLogger.debug((Object)"could not register the patient in the XDS server");
        }
        return responseType;
    }

    public ResponseType mergePatient(PatientInfoType patientInfoTarget, String pType, PatientInfoType patientInfoMerge) throws PixSourceException, ClientException, HL7V2Exception, URISyntaxException, PixPdqMessageException, BridgeException {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting String mergePatient(" + patientInfoTarget + ") " + " in " + TransactionContext.instant().getSessionContext()));
        }
        patientInfoTarget.getPatientIdentifier().getAssigningAuthorityType().applyPixSourceDefaults();
        PixPdqResources resources = IhePixPdqResourcesFactory.getResources();
        String namespaceId = patientInfoTarget.getPatientIdentifier().getAssigningAuthorityType().getNamespaceId();
        String universalId = patientInfoTarget.getPatientIdentifier().getAssigningAuthorityType().getUniversalId();
        String universalIdType = patientInfoTarget.getPatientIdentifier().getAssigningAuthorityType().getUniversalIdType();
        patientInfoMerge.getPatientIdentifier().getAssigningAuthorityType().getNamespaceId();
        patientInfoMerge.getPatientIdentifier().getAssigningAuthorityType().getUniversalId();
        patientInfoMerge.getPatientIdentifier().getAssigningAuthorityType().getUniversalIdType();
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)"sending to the PIX server");
        }
        PixMsgMergePatient mergePatient = resources.getPixSourcePixDestination().mergePatient(patientInfoTarget.getPatientIdentifier().getIdNumber(), namespaceId, universalId, universalIdType, pType, patientInfoMerge.getPatientIdentifier().getIdNumber());
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("got mergePatient: " + mergePatient));
        }
        TransactionContext.instant().getSessionContext();
        PixUtils.populateMessageWithApplicationAndFacility((PixPdqMessage)mergePatient, resources.getPixSourceProperties(), (ApplicationAndFacilityProperties)resources.getRhioConfiguration().getPixConfig().getPixServerProperties());
        PixUtils.feedPixMsgADT((PixMsgADT)mergePatient, patientInfoTarget);
        PixSourceResponse response = resources.getPixSourcePixDestination().sendMerge(mergePatient, false);
        ResponseType responseType = PixUtils.handleResponse(response);
        if (!responseType.isSuccess()) {
            if (mLogger.getEffectiveLevel().isGreaterOrEqual((Priority)Level.ERROR)) {
                mLogger.debug((Object)"could not merge the patient in the PIX server, will not attempt to register in the XDS");
            }
            return responseType;
        }
        if (resources.getPixSourceXdsDestination() == null) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"don't have an XdsDestination");
            }
            return responseType;
        }
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)"registering with the XDS");
        }
        if (!(responseType = PixUtils.handleResponse(response = resources.getPixSourceXdsDestination().sendMerge(mergePatient, false))).isSuccess() && mLogger.getEffectiveLevel().isGreaterOrEqual((Priority)Level.ERROR)) {
            mLogger.debug((Object)"could not register the patient in the XDS server");
        }
        return responseType;
    }
}

