/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.pix.consumer;

import org.apache.log4j.Logger;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPConformanceProfile;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefnList;
import org.eclipse.ohf.hl7v2.core.message.MessageManager;
import org.eclipse.ohf.hl7v2.core.message.model.Field;
import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.hl7v2.core.utilities.CPMessageBuilder;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessage;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageException;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageUtilities;
import org.eclipse.ohf.ihe.pix.consumer.PixConsumerException;

public class PixConsumerQuery
extends PixPdqMessage {
    private static Logger logger;
    private MessageManager globalFactory;
    private CPConformanceProfile cpProfile = null;
    private static final int version = 8;
    public static final String MSH_9_1_PIXC = "Q23";
    public static final String MSH_9_2_PIXC = "QBP";
    public static final String MSH_9_3_PIXC = "QBP_Q21";
    public static final String QPD_1_1_PIXC = "Q23";
    public static final String QPD_1_2_PIXC = "Get Corresponding IDs";
    public static final String QPD_1_3_PIXC = "HL7nnnn";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.pix.consumer.PixConsumerQuery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public PixConsumerQuery(MessageManager globalFactory, CPConformanceProfile cpProfile, String patientId) throws PixConsumerException {
        this.nodeType = 2;
        this.globalFactory = globalFactory;
        this.cpProfile = cpProfile;
        this.createQueryMsg(patientId, null, null, null, true);
    }

    public PixConsumerQuery(MessageManager globalFactory, CPConformanceProfile cpProfile, String patientId, String namespaceId, String universalId, String universalIdType) throws PixConsumerException {
        this.nodeType = 2;
        this.globalFactory = globalFactory;
        this.cpProfile = cpProfile;
        this.createQueryMsg(patientId, namespaceId, universalId, universalIdType, false);
    }

    public void changeDefaultMessageQueryName(String identifier, String text, String codingSystem, String alternateIdentifier, String alternateText, String alternateCodingSystem) throws PixConsumerException {
        if (identifier != null && identifier.length() > 0) {
            try {
                this.setField("QPD-1-1", identifier);
            }
            catch (PixPdqMessageException e) {
                throw new PixConsumerException(e);
            }
        } else {
            throw new PixConsumerException("PixConsumerQuery: changeDefaultMessageQueryName - " + identifier + " invalid parameter ");
        }
        try {
            this.setField("QPD-1-2", text);
            this.setField("QPD-1-3", codingSystem);
            this.setField("QPD-1-4", alternateIdentifier);
            this.setField("QPD-1-5", alternateText);
            this.setField("QPD-1-6", alternateCodingSystem);
        }
        catch (PixPdqMessageException e) {
            throw new PixConsumerException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixConsumerQuery: changeDefaultMessageQueryName ");
        }
    }

    public void changeDefaultQueryTag(String tag) throws PixConsumerException {
        if (tag != null && tag.length() > 0) {
            try {
                this.setField("QPD-2", tag);
            }
            catch (PixPdqMessageException e) {
                throw new PixConsumerException(e);
            }
        } else {
            throw new PixConsumerException("PixConsumerQuery: changeDefaultQueryTag - " + tag + " invalid parameter ");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixConsumerQuery: changeDefaultQueryTag ");
        }
    }

    public void changeDefaultAssigningAuthority(String namespaceId, String universalId, String universalIdType) throws PixConsumerException {
        if (PixPdqMessageUtilities.isHDParamValid((String)namespaceId, (String)universalId, (String)universalIdType)) {
            try {
                this.setField("QPD-3-4-1", namespaceId);
                this.setField("QPD-3-4-2", universalId);
                this.setField("QPD-3-4-3", universalIdType);
            }
            catch (PixPdqMessageException e) {
                throw new PixConsumerException(e);
            }
        } else {
            throw new PixConsumerException("PixConsumerQuery: changeDefaultSendingApplication - " + namespaceId + ", " + universalId + ", " + universalIdType + " invalid parameter combination ");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixConsumerQuery: changeDefaultAssigningAuthority ");
        }
    }

    public void addOptionalDomainRestriction(String namespaceId, String universalId, String universalIdType) throws PixConsumerException {
        try {
            this.getSegments().getByCodeAndIndex("QPD", 1).forceField(3);
            Field field = this.getSegments().getByCodeAndIndex("QPD", 1).getFields().item(3).addRepeat(true);
            field.forceComponent(3);
            field.getComponent(3).forceComponent(2);
            field.forceElement("4-1").setAsString(namespaceId);
            field.forceElement("4-2").setAsString(universalId);
            field.forceElement("4-3").setAsString(universalIdType);
        }
        catch (HL7V2Exception hL7V2Exception) {
            logger.error((Object)("PixConsumerQuery: addOptionalDomainRestriction - " + namespaceId + "," + universalId + "," + universalIdType + " failed."));
            throw new PixConsumerException("Add request for domain restriction " + namespaceId + "," + universalId + "," + universalIdType + " failed.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixConsumerQuery: addOptionalDomainRestriction ");
        }
    }

    private void createQueryMsg(String patientId, String namespaceId, String universalId, String universalIdType, boolean useCPAssigningAuthority) throws PixConsumerException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixConsumerQuery: createQueryMsg - Entry ");
        }
        if (patientId == null || patientId.length() <= 0) {
            logger.error((Object)"PixConsumerQuery: createQueryMsg - required patientId empty");
            throw new PixConsumerException("PixConsumerQuery: createQueryMsg - required patientId empty");
        }
        try {
            this.clear();
            if (this.globalFactory != null) {
                this.setDefinitions(this.globalFactory.getVersionDefinitions());
            }
            this.setVersion(8);
            this.setEvent("Q23");
            this.setMessageType(MSH_9_2_PIXC);
            this.setStructId(MSH_9_3_PIXC);
            this.addMSHFromFields();
            this.getSegments().add("QPD");
            this.getSegments().add("RCP");
            this.getSegments().getByCodeAndIndex("QPD", 1).forceField(2).forceComponent(3);
            this.getSegments().getByCodeAndIndex("QPD", 1).forceField(2).getComponents().item(3).forceComponent(2);
            if (this.cpProfile != null) {
                CPMessageBuilder builder = new CPMessageBuilder();
                builder.build(8, this.cpProfile.getInteractions().itemInteraction(0).getStaticDefinition(), true, (Message)this);
                String cpNamespaceId = this.getField("QPD-3-4-1");
                String cpUniversalId = this.getField("QPD-3-4-2");
                String cpUniversalIdType = this.getField("QPD-3-4-3");
                logger.debug((Object)("PixFeedMsg: cp assigningAuthority " + cpNamespaceId + ", " + cpUniversalId + ", " + cpUniversalIdType));
                if (useCPAssigningAuthority) {
                    if (!PixPdqMessageUtilities.isHDParamValid((String)cpNamespaceId, (String)cpUniversalId, (String)cpUniversalIdType)) {
                        throw new PixConsumerException("PixConsumerQuery: createQueryMsg - patientId cp assigning authority invalid");
                    }
                    this.setField("QPD-3-1", patientId);
                }
                if (namespaceId != null && namespaceId.length() > 0 || universalId != null && universalId.length() > 0 || universalIdType != null && universalIdType.length() > 0) {
                    if (!PixPdqMessageUtilities.isHDParamValid((String)namespaceId, (String)universalId, (String)universalIdType)) {
                        throw new PixConsumerException("PixConsumerQuery: createQueryMsg - patientId assigning authority invalid");
                    }
                    this.setField("QPD-3-1", patientId);
                    this.setField("QPD-3-4-1", namespaceId);
                    this.setField("QPD-3-4-2", universalId);
                    this.setField("QPD-3-4-3", universalIdType);
                    logger.debug((Object)"PixConsumerQuery: createQueryMsg - patientId cp assigning authority overridden with local parameters");
                }
            } else {
                if (!PixPdqMessageUtilities.isHDParamValid((String)namespaceId, (String)universalId, (String)universalIdType)) {
                    throw new PixConsumerException("PixConsumerQuery: createQueryMsg - required patient namespace parameters invalid");
                }
                this.setField("QPD-3-1", patientId);
                this.setField("QPD-3-4-1", namespaceId);
                this.setField("QPD-3-4-2", universalId);
                this.setField("QPD-3-4-3", universalIdType);
            }
            this.setField("MSH-12", VersionDefnList.display((int)8));
            this.setField("RCP-1", "I");
            this.setField("MSH-7", PixPdqMessageUtilities.getCurrentDateTimeString());
            this.setNonNullElement("MSH-10", PixPdqMessageUtilities.getRandomFieldValue((int)20));
            this.setNonNullElement("MSH-11-1", "P");
            this.setNonNullElement("MSH-18-1", "ASCII");
            this.setNonNullElement("QPD-1-1", "Q23");
            this.setNonNullElement("QPD-1-2", QPD_1_2_PIXC);
            this.setNonNullElement("QPD-1-3", QPD_1_3_PIXC);
            this.setNonNullElement("QPD-2", PixPdqMessageUtilities.getRandomFieldValue((int)32));
        }
        catch (HL7V2Exception e) {
            logger.error((Object)("PixConsumerQuery: createQueryMsg - HL7V2Exception " + e.getLocalizedMessage()));
            throw new PixConsumerException(e);
        }
        catch (PixPdqMessageException e) {
            throw new PixConsumerException(e);
        }
        if (logger.isDebugEnabled()) {
            try {
                logger.debug((Object)("PixConsumerQuery: createQueryMsg \r" + PixPdqMessageUtilities.msgToString((Message)this)));
            }
            catch (PixPdqMessageException pixPdqMessageException) {
                logger.debug((Object)"PixConsumerQuery: createQueryMsg \r");
            }
        }
    }
}

