/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.audit.util;

import java.net.InetAddress;
import java.net.URI;
import org.apache.log4j.Logger;
import org.eclipse.ohf.ihe.atna.audit.ATNAException;
import org.eclipse.ohf.ihe.atna.audit.element.ActiveParticipantType;

public class AddressUtils {
    private static final Logger mLogger;
    private static final String IP_ADDRESS_LOOPBACK = "127.0.0.1";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.atna.audit.util.AddressUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mLogger = Logger.getLogger((Class)clazz);
    }

    public static String getLocalAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            mLogger.error((Object)("Error getting local IP address: " + e.getMessage()));
            mLogger.info((Object)"Unable to get local IP address.  Setting as 127.0.0.1.");
            return IP_ADDRESS_LOOPBACK;
        }
    }

    public static String getRemoteAddressByURL(String url) {
        try {
            return InetAddress.getByName(new URI(url).getHost()).getHostAddress();
        }
        catch (Exception e) {
            mLogger.error((Object)("Error getting IP address for host " + url + ".  Error: " + e.getMessage()));
            mLogger.info((Object)"Unable to get remote IP address.  Setting as 127.0.0.1.");
            return IP_ADDRESS_LOOPBACK;
        }
    }

    public static void setNetworkAccessPointCodes(ActiveParticipantType msg, String ipAddress) throws ATNAException {
        msg.setNetworkAccessPointTypeCode("2");
        msg.setNetworkAccessPointID(ipAddress);
    }
}

