/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.ihe.pixpdq;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;
import org.eclipse.ohf.bridge.BridgeException;
import org.eclipse.ohf.bridge.Utils;
import org.eclipse.ohf.bridge.conf.AbstractRhioDedicatedResources;
import org.eclipse.ohf.bridge.conf.DefaultMessageQueryName;
import org.eclipse.ohf.bridge.conf.GlobalConfigurations;
import org.eclipse.ohf.bridge.conf.SessionContext;
import org.eclipse.ohf.bridge.conf.TransactionContext;
import org.eclipse.ohf.bridge.conf.UnavailableResourcesException;
import org.eclipse.ohf.bridge.conf.rhio.ApplicationAndFacilityProperties;
import org.eclipse.ohf.bridge.conf.rhio.IheUri;
import org.eclipse.ohf.bridge.conf.rhio.RhioConfig;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.ihe.common.hl7v2.mllpclient.ClientException;
import org.eclipse.ohf.ihe.common.mllp.MLLPDestination;
import org.eclipse.ohf.ihe.pdq.consumer.PdqConsumer;
import org.eclipse.ohf.ihe.pix.consumer.PixConsumer;
import org.eclipse.ohf.ihe.pix.source.PixSource;

public class PixPdqResources
extends AbstractRhioDedicatedResources {
    static final Logger mLogger = Logger.getLogger(PixPdqResources.class);
    private PdqConsumer mPdqConsumer;
    private PixConsumer mHl7PixConsumer;
    private PixSource mPixSourcePixDestination;
    private PixSource mPixSourceXdsDestination;
    private GlobalConfigurations mConfigurations;

    public PixPdqResources(RhioConfig pRhioConfig, GlobalConfigurations pConfigurations) {
        super(pRhioConfig);
        this.mConfigurations = pConfigurations;
    }

    private void checkResourseAvaliability() throws UnavailableResourcesException {
        if (this.getRhioConfiguration().getPixConfig().getPixFeedUri() == null && this.getRhioConfiguration().getPixConfig().getPixQueryUri() == null && this.getRhioConfiguration().getPixConfig().getPdqQueryUri() == null) {
            throw new UnavailableResourcesException("RESOURCE DOS NOT EXIST: PIX server not configured for this RHIO [" + this.getRhioConfiguration().getName() + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PdqConsumer getPdqConsumer() throws ClientException, HL7V2Exception, URISyntaxException, FileNotFoundException, UnavailableResourcesException {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting PdqConsumer getPdqConsumer()  in " + TransactionContext.instant().getSessionContext() + " using " + this.getRhioConfiguration()));
        }
        this.checkResourseAvaliability();
        IheUri queryURI = this.getRhioConfiguration().getPixConfig().getPdqQueryUri();
        if (queryURI == null) {
            throw new UnavailableResourcesException("RESOURCE DOS NOT EXIST: PIX server not configured to use PDQ for this RHIO [" + this.getRhioConfiguration().getName() + "]");
        }
        PixPdqResources pixPdqResources = this;
        synchronized (pixPdqResources) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"creating PdqConsumer");
            }
            this.mPdqConsumer = new PdqConsumer();
            this.mPdqConsumer.setMaxVerifyEvent(3);
            this.mPdqConsumer.setMLLPDestination(this.createMLLPDestination(new URI(queryURI.defaultUri())));
            this.mPdqConsumer.setConformanceProfile((InputStream)new FileInputStream(this.mConfigurations.getPDQConsumerConformanceProfileFile()));
            return this.mPdqConsumer;
        }
    }

    private MLLPDestination createMLLPDestination(URI pUri) throws URISyntaxException {
        MLLPDestination mllpDestination = new MLLPDestination(pUri);
        return mllpDestination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PixConsumer getPixConsumer() throws ClientException, HL7V2Exception, FileNotFoundException, URISyntaxException, UnavailableResourcesException {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting PixConsumer getPixConsumer()  in " + TransactionContext.instant().getSessionContext() + " using " + this.getRhioConfiguration()));
        }
        this.checkResourseAvaliability();
        IheUri queryURI = this.getRhioConfiguration().getPixConfig().getPixQueryUri();
        if (queryURI == null) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("No PIX configured for " + this.getRhioConfiguration()));
            }
            return null;
        }
        PixPdqResources pixPdqResources = this;
        synchronized (pixPdqResources) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"creating PixConsumer");
            }
            PixConsumer pixConsumer = new PixConsumer();
            pixConsumer.setMaxVerifyEvent(3);
            pixConsumer.setMLLPDestination(this.createMLLPDestination(new URI(queryURI.defaultUri())));
            pixConsumer.setConformanceProfile((InputStream)new FileInputStream(this.mConfigurations.getPIXConsumerConformanceProfileFile()));
            this.mHl7PixConsumer = pixConsumer;
        }
        return this.mHl7PixConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PixSource getPixSourcePixDestination() throws ClientException, HL7V2Exception, URISyntaxException, UnavailableResourcesException {
        IheUri uri;
        this.checkResourseAvaliability();
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting PixSource getPixSourcePixDestination()  in " + TransactionContext.instant().getSessionContext() + " using " + this.getRhioConfiguration()));
        }
        if ((uri = this.getRhioConfiguration().getPixConfig().getPixFeedUri()) == null) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("No PIX Feed URI configured for " + this.getRhioConfiguration()));
            }
            return null;
        }
        PixPdqResources pixPdqResources = this;
        synchronized (pixPdqResources) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"creating PixSource");
            }
            PixSource source = new PixSource();
            source.setMaxVerifyEvent(3);
            source.setMLLPDestination(this.createMLLPDestination(new URI(uri.defaultUri())));
            this.mPixSourcePixDestination = source;
        }
        return this.mPixSourcePixDestination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PixSource getPixSourceXdsDestination() throws ClientException, HL7V2Exception, URISyntaxException, UnavailableResourcesException {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting PixSource getPixSourceXdsDestination()  in " + TransactionContext.instant().getSessionContext() + " using " + this.getRhioConfiguration()));
        }
        this.checkResourseAvaliability();
        if (this.getRhioConfiguration().getXdsRegistryConfig().getPixFeedUrl() == null) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("No Registry MLLP configured for " + this.getRhioConfiguration()));
            }
            return null;
        }
        PixPdqResources pixPdqResources = this;
        synchronized (pixPdqResources) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"creating new PixSource");
            }
            PixSource source = new PixSource();
            source.setMaxVerifyEvent(3);
            source.setMLLPDestination(this.createMLLPDestination(new URI(this.getRhioConfiguration().getXdsRegistryConfig().getPixFeedUrl().defaultUri())));
            this.mPixSourceXdsDestination = source;
        }
        return this.mPixSourceXdsDestination;
    }

    public ApplicationAndFacilityProperties getPixConsumerProperties() throws BridgeException {
        ApplicationAndFacilityProperties properties = this.createSessionApplicationAndFacilityProperties();
        if (Utils.isEmptyOrNull((String)properties.getFacility())) {
            properties.setFacility(this.getRhioConfiguration().getPixConfig().getPixConsumerProperties().getFacility());
        }
        if (Utils.isEmptyOrNull((String)properties.getApplication())) {
            properties.setApplication(this.getRhioConfiguration().getPixConfig().getPixConsumerProperties().getApplication());
        }
        return properties;
    }

    public ApplicationAndFacilityProperties getPixSourceProperties() throws BridgeException {
        ApplicationAndFacilityProperties properties = this.createSessionApplicationAndFacilityProperties();
        if (Utils.isEmptyOrNull((String)properties.getFacility())) {
            properties.setFacility(this.getRhioConfiguration().getPixConfig().getPixSourceProperties().getFacility());
        }
        if (Utils.isEmptyOrNull((String)properties.getApplication())) {
            properties.setApplication(this.getRhioConfiguration().getPixConfig().getPixSourceProperties().getApplication());
        }
        return properties;
    }

    public ApplicationAndFacilityProperties getPdqConsumerProperties() throws BridgeException {
        ApplicationAndFacilityProperties properties = this.createSessionApplicationAndFacilityProperties();
        if (Utils.isEmptyOrNull((String)properties.getFacility())) {
            properties.setFacility(this.getRhioConfiguration().getPixConfig().getPdqConsumerProperties().getFacility());
        }
        if (Utils.isEmptyOrNull((String)properties.getApplication())) {
            properties.setApplication(this.getRhioConfiguration().getPixConfig().getPdqConsumerProperties().getApplication());
        }
        return properties;
    }

    private ApplicationAndFacilityProperties createSessionApplicationAndFacilityProperties() {
        ApplicationAndFacilityProperties properties = new ApplicationAndFacilityProperties();
        SessionContext session = TransactionContext.instant().getSessionContext();
        properties.setFacility(session.getUserFacilityName());
        properties.setApplication(session.getUserApplicationName());
        return properties;
    }

    public DefaultMessageQueryName getDefaultMessageQueryName() {
        return this.getRhioConfiguration().getPixConfig().getDefaultMessageQueryName();
    }
}

