/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.ihe.pixpdq;

import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.eclipse.ohf.bridge.BridgeException;
import org.eclipse.ohf.bridge.Utils;
import org.eclipse.ohf.bridge.conf.rhio.ApplicationAndFacilityProperties;
import org.eclipse.ohf.bridge.type.GenericAdtValue;
import org.eclipse.ohf.bridge.type.PatientInfoType;
import org.eclipse.ohf.bridge.type.ResponseType;
import org.eclipse.ohf.bridge.type.SearchPatientResponseType;
import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessage;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageException;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageUtilities;
import org.eclipse.ohf.ihe.common.hl7v2.mllpclient.ClientException;
import org.eclipse.ohf.ihe.pdq.consumer.PdqConsumerException;
import org.eclipse.ohf.ihe.pdq.consumer.PdqConsumerResponse;
import org.eclipse.ohf.ihe.pix.consumer.PixConsumerException;
import org.eclipse.ohf.ihe.pix.consumer.PixConsumerResponse;
import org.eclipse.ohf.ihe.pix.source.PixMsgADT;
import org.eclipse.ohf.ihe.pix.source.PixSourceException;
import org.eclipse.ohf.ihe.pix.source.PixSourceResponse;

public abstract class PixUtils {
    static final Logger mLogger = Logger.getLogger(PixUtils.class);

    public static void feedPixMsgADT(PixMsgADT message, PatientInfoType patientInfo) throws PixSourceException, PixPdqMessageException {
        if (patientInfo.getPatientName() != null) {
            if (Utils.notEmpty((String)patientInfo.getPatientName().getFamilyName())) {
                message.addOptionalPatientNameFamilyName(patientInfo.getPatientName().getFamilyName());
            }
            if (Utils.notEmpty((String)patientInfo.getPatientName().getGivenName())) {
                message.addOptionalPatientNameGivenName(patientInfo.getPatientName().getGivenName());
            }
            if (Utils.notEmpty((String)patientInfo.getPatientName().getOtherName())) {
                message.addOptionalPatientNameOtherName(patientInfo.getPatientName().getOtherName());
            }
            if (Utils.notEmpty((String)patientInfo.getPatientName().getSuffix())) {
                message.addOptionalPatientNameSuffix(patientInfo.getPatientName().getSuffix());
            }
            if (Utils.notEmpty((String)patientInfo.getPatientName().getPrefix())) {
                message.addOptionalPatientNamePrefix(patientInfo.getPatientName().getPrefix());
            }
        }
        if (Utils.notEmpty((String)patientInfo.getPatientSex())) {
            message.addOptionalPatientSex(patientInfo.getPatientSex());
        }
        if (Utils.notEmpty((String)patientInfo.getPatientDateOfBirth())) {
            message.addOptionalPatientDateOfBirth(patientInfo.getPatientDateOfBirth());
        }
        if (patientInfo.getPatientAddress() != null) {
            if (Utils.notEmpty((String)patientInfo.getPatientAddress().getStreetAddress())) {
                message.addOptionalPatientAddressStreetAddress(patientInfo.getPatientAddress().getStreetAddress());
            }
            if (Utils.notEmpty((String)patientInfo.getPatientAddress().getCity())) {
                message.addOptionalPatientAddressCity(patientInfo.getPatientAddress().getCity());
            }
            if (Utils.notEmpty((String)patientInfo.getPatientAddress().getCountyParishCode())) {
                message.addOptionalPatientAddressCountyParishCode(patientInfo.getPatientAddress().getCountyParishCode());
            }
            if (Utils.notEmpty((String)patientInfo.getPatientAddress().getStateOrProvince())) {
                message.addOptionalPatientAddressStateOrProvince(patientInfo.getPatientAddress().getStateOrProvince());
            }
            if (Utils.notEmpty((String)patientInfo.getPatientAddress().getCountry())) {
                message.addOptionalPatientAddressCountry(patientInfo.getPatientAddress().getCountry());
            }
            if (Utils.notEmpty((String)patientInfo.getPatientAddress().getZipOrPostalCode())) {
                message.addOptionalPatientAddressZipOrPostalCode(patientInfo.getPatientAddress().getZipOrPostalCode());
            }
            if (Utils.notEmpty((String)patientInfo.getPatientAddress().getOtherDesignation())) {
                message.addOptionalPatientAddressOtherDesignation(patientInfo.getPatientAddress().getOtherDesignation());
            }
        }
        if (patientInfo.getPatientPhoneHome() != null && Utils.notEmpty((String)patientInfo.getPatientPhoneHome().getUnformattedTelephoneNumber())) {
            message.addOptionalPatientPhoneHomeUnformattedTelephoneNumber(patientInfo.getPatientPhoneHome().getUnformattedTelephoneNumber());
        }
        if (patientInfo.getPatientPhoneBusiness() != null && Utils.notEmpty((String)patientInfo.getPatientPhoneBusiness().getUnformattedTelephoneNumber())) {
            message.addOptionalPatientPhoneBusinessUnformattedTelephoneNumber(patientInfo.getPatientPhoneBusiness().getUnformattedTelephoneNumber());
        }
        PixUtils.setFields(message, patientInfo);
    }

    private static void setFields(PixMsgADT pMessage, PatientInfoType pPatientInfo) throws PixPdqMessageException {
        GenericAdtValue[] values = pPatientInfo.getGenericAdtValues();
        int i = 0;
        while (i < values.length) {
            PixUtils.setField(pMessage, values[i]);
            ++i;
        }
    }

    private static void setField(PixMsgADT pMessage, GenericAdtValue value) throws PixPdqMessageException {
        if (value == null) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"the GenericAdtValue is null");
            }
            return;
        }
        if (Utils.isEmptyOrNull((String)value.getPath()) || Utils.isEmptyOrNull((String)value.getData())) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("Not setting incompleate GenericAdtValue: " + value));
            }
            return;
        }
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("setting fields for " + value));
        }
        pMessage.setField(value.getPath(), value.getData());
    }

    public static void populateMessageWithApplicationAndFacility(PixPdqMessage message, ApplicationAndFacilityProperties clientProperties, ApplicationAndFacilityProperties serverProperties) throws BridgeException, PixPdqMessageException {
        String[] stringParts = PixUtils.getStringParts(clientProperties.getApplication());
        message.changeDefaultSendingApplication(stringParts[0], stringParts[1], stringParts[2]);
        stringParts = PixUtils.getStringParts(clientProperties.getFacility());
        message.changeDefaultSendingFacility(stringParts[0], stringParts[1], stringParts[2]);
        stringParts = PixUtils.getStringParts(serverProperties.getApplication());
        message.changeDefaultReceivingApplication(stringParts[0], stringParts[1], stringParts[2]);
        stringParts = PixUtils.getStringParts(serverProperties.getFacility());
        message.changeDefaultRecievingFacility(stringParts[0], stringParts[1], stringParts[2]);
    }

    public static String[] getStringParts(String pString) {
        StringTokenizer st = new StringTokenizer(pString, "^");
        String[] parts = new String[3];
        int index = 0;
        while (st.hasMoreTokens()) {
            parts[index] = st.nextToken();
            ++index;
        }
        return parts;
    }

    public static ResponseType handleResponse(PixSourceResponse pResponse) throws PixSourceException, ClientException, PixPdqMessageException {
        ResponseType responce = new ResponseType();
        if (!pResponse.hasError()) {
            responce.setResponse(0);
            String message = pResponse.getResponseAckCode(false);
            responce.setResponseMessage(message);
            return responce;
        }
        String errorMessage = PixUtils.parseErrorForPixSource(pResponse);
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("error on message " + PixPdqMessageUtilities.msgToString((Message)pResponse)));
            mLogger.debug((Object)errorMessage);
        }
        responce.setResponse(4);
        responce.setResponseMessage(errorMessage);
        return responce;
    }

    private static String parseErrorForPixSource(PixSourceResponse response) throws PixSourceException {
        StringBuffer sb;
        block5: {
            int rptCnt;
            block4: {
                sb = new StringBuffer();
                int segCnt = response.getErrorCountBySegment();
                rptCnt = response.getErrorCountByRepeat();
                sb.append("Errors returned: seg-" + segCnt + " rpt-" + rptCnt);
                if (segCnt <= 0) break block4;
                int i = 0;
                while (i < segCnt) {
                    String[] errLoc = response.getErrorCodeAndLocation(i, 0);
                    int j = 0;
                    while (j < errLoc.length) {
                        sb.append("\n  Error: " + errLoc[j]);
                        ++j;
                    }
                    ++i;
                }
                break block5;
            }
            if (rptCnt <= 0) break block5;
            int i = 0;
            while (i < rptCnt) {
                String[] errLoc = response.getErrorCodeAndLocation(0, i);
                int j = 0;
                while (j < errLoc.length) {
                    sb.append("\n  Error: " + errLoc[j]);
                    ++j;
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public static String parseErrorForPdq(PdqConsumerResponse response) throws PdqConsumerException {
        StringBuffer sb = new StringBuffer();
        int segCnt = response.getErrorCountbySegment();
        int rptCnt = response.getErrorCountbyRepeat();
        mLogger.debug((Object)("Errors returned: seg-" + segCnt + " rpt-" + rptCnt));
        if (segCnt > 0) {
            int i = 0;
            while (i < segCnt) {
                String[] errLoc = response.getErrorLocation(i, 0);
                String[] errCode = response.getErrorCode(i);
                sb.append("  Error location: " + errLoc[0] + "^" + errLoc[1] + "^" + errLoc[2] + "^" + errLoc[3] + "^" + errLoc[4] + "^" + errLoc[5]);
                sb.append("  Error code: " + errCode[0]);
                sb.append("  Error severity: " + response.getErrorSeverity(i, true));
                ++i;
            }
        } else if (rptCnt > 0) {
            int i = 0;
            while (i < rptCnt) {
                String[] errLoc = response.getErrorLocation(0, i);
                String[] errCode = response.getErrorCode(0);
                sb.append("  Error location: " + errLoc[0] + "^" + errLoc[1] + "^" + errLoc[2] + "^" + errLoc[3] + "^" + errLoc[4] + "^" + errLoc[5]);
                sb.append("  Error code: " + errCode[0]);
                sb.append("  Error severity: " + response.getErrorSeverity(0, true));
                ++i;
            }
        }
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("got the following error message: " + sb.toString()));
        }
        return sb.toString();
    }

    public static String parseErrorForPixConsumer(PixConsumerResponse response) throws PixConsumerException {
        StringBuffer sb = new StringBuffer();
        int segCnt = response.getErrorCountBySegment();
        int rptCnt = response.getErrorCountByRepeat();
        mLogger.debug((Object)("Errors returned: seg-" + segCnt + " rpt-" + rptCnt));
        if (segCnt > 0) {
            int i = 0;
            while (i < segCnt) {
                String[] errLoc = response.getErrorLocation(i, 0);
                String[] errCode = response.getErrorCode(i);
                sb.append("  Error location: " + errLoc[0] + "^" + errLoc[1] + "^" + errLoc[2] + "^" + errLoc[3] + "^" + errLoc[4] + "^" + errLoc[5]);
                sb.append("  Error code: " + errCode[0]);
                sb.append("  Error severity: " + response.getErrorSeverity(i, true));
                ++i;
            }
        } else if (rptCnt > 0) {
            int i = 0;
            while (i < rptCnt) {
                String[] errLoc = response.getErrorLocation(0, i);
                String[] errCode = response.getErrorCode(0);
                sb.append("  Error location: " + errLoc[0] + "^" + errLoc[1] + "^" + errLoc[2] + "^" + errLoc[3] + "^" + errLoc[4] + "^" + errLoc[5]);
                sb.append("  Error code: " + errCode[0]);
                sb.append("  Error severity: " + response.getErrorSeverity(0, true));
                ++i;
            }
        }
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("got the followign error message: " + sb.toString()));
        }
        return sb.toString();
    }

    public static SearchPatientResponseType getErrorPdqResponse(PdqConsumerResponse pReturnMessage) throws PdqConsumerException {
        if (!pReturnMessage.hasError()) {
            return null;
        }
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)"found a PDQ error");
        }
        SearchPatientResponseType response = new SearchPatientResponseType();
        response.setResponse(4);
        response.setResponseMessage(PixUtils.parseErrorForPdq(pReturnMessage));
        return response;
    }

    public static SearchPatientResponseType getErrorPixConsumerResponse(PixConsumerResponse pReturnMessage) throws PixConsumerException {
        if (!pReturnMessage.hasError()) {
            return null;
        }
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)"found a PIX error");
        }
        SearchPatientResponseType response = new SearchPatientResponseType();
        response.setResponse(4);
        response.setResponseMessage(PixUtils.parseErrorForPixConsumer(pReturnMessage));
        return response;
    }
}

