/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.ohf.bridge.Utils;
import org.eclipse.ohf.bridge.conf.SessionContext;
import org.eclipse.ohf.bridge.conf.TransactionContext;
import org.eclipse.ohf.ihe.atna.audit.util.TimeStamp;

public class BridgeTransactionAwareLog4jAppender
extends DailyRollingFileAppender {
    private static final String NAME_SEPERATOR = "::";
    private static final String DEFAULT_NAME = "DEFAULT";
    private static final String FILE_EXTENSION = ".log";
    private static final String BASE_LOG_NAME = "bridge.log";
    private Map mDailyRollingFileAppenders = new HashMap();
    private File mRootDir = null;
    public static BridgeTransactionAwareLog4jAppender INSTANT;

    public BridgeTransactionAwareLog4jAppender() {
        if (INSTANT != null) {
            System.err.println("There should be only one BridgeTransactionAwareLog4jAppender configured for log4j, are you running the config again from JUNIT? if not, there is something wrong!");
            return;
        }
        INSTANT = this;
    }

    public BridgeTransactionAwareLog4jAppender(Layout layout, String filename, String datePattern) throws IOException {
        super(layout, filename, datePattern);
        if (INSTANT != null) {
            throw new IllegalStateException("There should be only one BridgeTransactionAwareLog4jAppender configured for log4j");
        }
        INSTANT = this;
    }

    public synchronized void setFile(String rootDirName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        LogLog.debug((String)("setFile called: " + rootDirName + ", " + append));
        if (bufferedIO) {
            this.setImmediateFlush(false);
        }
        this.reset();
        this.setFile(rootDirName);
        this.fileAppend = append;
        this.bufferedIO = bufferedIO;
        this.bufferSize = bufferSize;
        LogLog.debug((String)"setFile (Dir) ended");
    }

    public void setFile(String rootDirName) {
        File rootDir = new File(rootDirName);
        if (!rootDir.exists()) {
            rootDir.mkdirs();
        }
        this.mRootDir = rootDir;
        System.out.println("Logger root output directory is: " + this.mRootDir.getAbsolutePath());
        this.fileName = rootDirName;
    }

    private void runActors(Action pAction) {
        for (DailyRollingFileAppender appender : this.mDailyRollingFileAppenders.values()) {
            pAction.act(appender);
        }
    }

    public void append(LoggingEvent pLoggingEvent) {
        try {
            DailyRollingFileAppender appender = this.getDailyRollingFileAppender();
            appender.append(pLoggingEvent);
            this.appendToSession(pLoggingEvent);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void appendToSession(LoggingEvent pLoggingEvent) {
        TransactionContext transactionContext = TransactionContext.instant();
        if (transactionContext == null) {
            return;
        }
        SessionContext sessionContext = transactionContext.getSessionContext();
        if (sessionContext.logLevel() != null && pLoggingEvent.getLevel().isGreaterOrEqual((Priority)sessionContext.logLevel())) {
            String message = String.valueOf(TimeStamp.generateUTCDateTime()) + " " + pLoggingEvent.getRenderedMessage();
            if (message.length() > 10001) {
                message = message.substring(0, 10000);
                message = message.concat(" ... Log overflow, truncated.  Please see log file for full message.");
            }
            Utils.addLineToLogList(sessionContext.logList(), message);
            sessionContext.addLogSize(message.length());
            if (sessionContext.logSize() > 4000) {
                Utils.addLineToLogList(sessionContext.logList(), "Log overflow, the log was trimmed since it is to large to send in one message");
                sessionContext.setReturnLogLevel(null);
            }
        }
    }

    private DailyRollingFileAppender getDailyRollingFileAppender() throws IOException {
        TransactionContext transactionContext = TransactionContext.instant();
        String appenderName = this.getAppenderName(transactionContext);
        DailyRollingFileAppender appender = (DailyRollingFileAppender)this.mDailyRollingFileAppenders.get(appenderName);
        if (appender != null) {
            return appender;
        }
        String logFilename = null;
        if (appenderName != BASE_LOG_NAME) {
            SessionContext sessionContext = transactionContext.getSessionContext();
            File ipDir = this.mRootDir;
            if (!(Utils.isEmptyOrNull(sessionContext.callerIp()) || (ipDir = new File(this.mRootDir, sessionContext.callerIp())).exists() || ipDir.mkdirs())) {
                throw new FileNotFoundException(ipDir.getAbsolutePath());
            }
            File rhioDir = new File(ipDir, this.getRhioName(sessionContext));
            if (!rhioDir.exists() && !rhioDir.mkdirs()) {
                throw new FileNotFoundException(rhioDir.getAbsolutePath());
            }
            File facilityNameDir = new File(rhioDir, this.getFacilityName(sessionContext));
            if (!facilityNameDir.exists() && !facilityNameDir.mkdirs()) {
                throw new FileNotFoundException(facilityNameDir.getAbsolutePath());
            }
            logFilename = String.valueOf(facilityNameDir.getAbsolutePath()) + File.separator + this.getUserName(sessionContext) + FILE_EXTENSION;
        } else {
            logFilename = String.valueOf(this.mRootDir.getAbsolutePath()) + File.separator + BASE_LOG_NAME;
        }
        appender = new DailyRollingFileAppender(this.layout, logFilename, this.getDatePattern());
        this.mDailyRollingFileAppenders.put(appenderName, appender);
        return appender;
    }

    public BufferedReader getMyLog() throws FileNotFoundException {
        TransactionContext transactionContext = TransactionContext.instant();
        String appenderName = this.getAppenderName(transactionContext);
        DailyRollingFileAppender appender = (DailyRollingFileAppender)this.mDailyRollingFileAppenders.get(appenderName);
        System.out.println("getting log from file " + appender.getFile());
        File file = new File(appender.getFile());
        if (!file.exists()) {
            throw new FileNotFoundException("Log file does not exist: " + file.getAbsolutePath());
        }
        FileReader fr = new FileReader(file);
        BufferedReader br = new BufferedReader(fr);
        return br;
    }

    private String getAppenderName(TransactionContext transactionContext) {
        String appenderName = null;
        if (transactionContext == null) {
            appenderName = BASE_LOG_NAME;
        } else {
            SessionContext context = transactionContext.getSessionContext();
            appenderName = String.valueOf(this.getRhioName(context)) + NAME_SEPERATOR + this.getFacilityName(context) + NAME_SEPERATOR + this.getUserName(context);
            if (!Utils.isEmptyOrNull(context.callerIp())) {
                appenderName = String.valueOf(context.callerIp()) + NAME_SEPERATOR + appenderName;
            }
        }
        return appenderName;
    }

    private String getUserName(SessionContext context) {
        return Utils.isEmptyOrNull(context.getInitiatingUser()) ? DEFAULT_NAME : context.getInitiatingUser();
    }

    private String getFacilityName(SessionContext context) {
        return Utils.isEmptyOrNull(context.getUserFacilityName()) ? DEFAULT_NAME : context.getUserFacilityName();
    }

    private String getRhioName(SessionContext context) {
        return Utils.isEmptyOrNull(context.getRhioName()) ? DEFAULT_NAME : context.getRhioName();
    }

    public void activateOptions() {
        this.runActors(new Action(){

            public void setPrameter(Object pObject) {
            }

            public void act(DailyRollingFileAppender pAppender) {
                pAppender.activateOptions();
            }
        });
    }

    public void setDatePattern(String pattern) {
        Action action = new Action(){
            private String mString = null;

            public void act(DailyRollingFileAppender pAppender) {
                pAppender.setDatePattern(this.mString);
            }

            public void setPrameter(Object pObject) {
                this.mString = (String)pObject;
            }
        };
        action.setPrameter(pattern);
        this.runActors(action);
    }

    public void setAppend(boolean pFlag) {
        super.setAppend(pFlag);
        Action action = new Action(){
            private boolean mBool;

            public void act(DailyRollingFileAppender pAppender) {
                pAppender.setAppend(this.mBool);
            }

            public void setPrameter(Object pObject) {
                this.mBool = (Boolean)pObject;
            }
        };
        action.setPrameter(new Boolean(pFlag));
        this.runActors(action);
    }

    public void setBufferedIO(boolean pBufferedIO) {
        super.setBufferedIO(pBufferedIO);
        Action action = new Action(){
            private boolean mBool;

            public void act(DailyRollingFileAppender pAppender) {
                pAppender.setAppend(this.mBool);
            }

            public void setPrameter(Object pObject) {
                this.mBool = (Boolean)pObject;
            }
        };
        action.setPrameter(new Boolean(pBufferedIO));
        this.runActors(action);
    }

    public void setBufferSize(int pBufferSize) {
        super.setBufferSize(pBufferSize);
        Action action = new Action(){
            private int mInt;

            public void act(DailyRollingFileAppender pAppender) {
                pAppender.setBufferSize(this.mInt);
            }

            public void setPrameter(Object pObject) {
                this.mInt = (Integer)pObject;
            }
        };
        action.setPrameter(new Integer(pBufferSize));
        this.runActors(action);
    }

    protected void setQWForFiles(Writer writer) {
        throw new UnsupportedOperationException("method shoul not be called");
    }

    public synchronized void close() {
        super.close();
        Action action = new Action(){

            public void act(DailyRollingFileAppender pAppender) {
                pAppender.close();
            }

            public void setPrameter(Object pObject) {
            }
        };
        this.runActors(action);
    }

    public void setEncoding(String pValue) {
        super.setEncoding(pValue);
        Action action = new Action(){
            private String mVal;

            public void act(DailyRollingFileAppender pAppender) {
                pAppender.setEncoding(this.mVal);
            }

            public void setPrameter(Object pObject) {
                this.mVal = (String)pObject;
            }
        };
        action.setPrameter(pValue);
        this.runActors(action);
    }

    public synchronized void setErrorHandler(ErrorHandler pEh) {
        super.setErrorHandler(pEh);
        Action action = new Action(){
            private ErrorHandler mVal;

            public void act(DailyRollingFileAppender pAppender) {
                pAppender.setErrorHandler(this.mVal);
            }

            public void setPrameter(Object pObject) {
                this.mVal = (ErrorHandler)pObject;
            }
        };
        action.setPrameter(pEh);
        this.runActors(action);
    }

    public void setImmediateFlush(boolean pValue) {
        super.setImmediateFlush(pValue);
        Action action = new Action(){
            private boolean mBool;

            public void act(DailyRollingFileAppender pAppender) {
                pAppender.setImmediateFlush(this.mBool);
            }

            public void setPrameter(Object pObject) {
                this.mBool = (Boolean)pObject;
            }
        };
        action.setPrameter(new Boolean(pValue));
        this.runActors(action);
    }

    public synchronized void setWriter(Writer pWriter) {
        throw new UnsupportedOperationException("setWriter");
    }

    public void clearFilters() {
        super.clearFilters();
        Action action = new Action(){

            public void act(DailyRollingFileAppender pAppender) {
                pAppender.clearFilters();
            }

            public void setPrameter(Object pObject) {
            }
        };
        this.runActors(action);
    }

    public synchronized void doAppend(LoggingEvent pEvent) {
        try {
            DailyRollingFileAppender appender = this.getDailyRollingFileAppender();
            appender.append(pEvent);
            this.appendToSession(pEvent);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void finalize() {
        Action action = new Action(){

            public void act(DailyRollingFileAppender pAppender) {
                pAppender.finalize();
            }

            public void setPrameter(Object pObject) {
            }
        };
        this.runActors(action);
        super.finalize();
    }

    public void setLayout(Layout pLayout) {
        Action action = new Action(){
            private Layout mVal;

            public void act(DailyRollingFileAppender pAppender) {
                pAppender.setLayout(this.mVal);
            }

            public void setPrameter(Object pObject) {
                this.mVal = (Layout)pObject;
            }
        };
        action.setPrameter(pLayout);
        this.runActors(action);
        super.setLayout(pLayout);
    }

    public void setName(String pName) {
        Action action = new Action(){
            private String mVal;

            public void act(DailyRollingFileAppender pAppender) {
                pAppender.setName(this.mVal);
            }

            public void setPrameter(Object pObject) {
                this.mVal = (String)pObject;
            }
        };
        action.setPrameter(pName);
        this.runActors(action);
        super.setName(pName);
    }

    public void setThreshold(Priority pThreshold) {
        Action action = new Action(){
            private Priority mVal;

            public void act(DailyRollingFileAppender pAppender) {
                pAppender.setThreshold(this.mVal);
            }

            public void setPrameter(Object pObject) {
                this.mVal = (Priority)pObject;
            }
        };
        action.setPrameter(pThreshold);
        this.runActors(action);
        super.setThreshold(pThreshold);
    }

    private static interface Action {
        public void setPrameter(Object var1);

        public void act(DailyRollingFileAppender var1);
    }
}

