/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.type;

import java.io.Serializable;
import org.apache.log4j.Logger;
import org.eclipse.ohf.bridge.Utils;
import org.eclipse.ohf.bridge.conf.RhioDedicatedResources;
import org.eclipse.ohf.bridge.conf.TransactionContext;
import org.eclipse.ohf.bridge.conf.UnavailableResourcesException;
import org.eclipse.ohf.bridge.conf.rhio.ApplicationFacilityAndAuthorityProperties;

public class AssigningAuthorityType
implements Serializable {
    private static final long serialVersionUID = -5384966639085688012L;
    public static final AssigningAuthorityType[] EMPTY_ARRAY = new AssigningAuthorityType[0];
    private String namespaceId = "";
    private String universalId = "";
    private String universalIdType = "";
    private boolean useDefaultAssigningAuthority = false;
    private String universalIdTypeCode = "";
    static final Logger mLogger = Logger.getLogger(AssigningAuthorityType.class);

    public void applyPixConsumerDefaults() throws UnavailableResourcesException {
        RhioDedicatedResources resources;
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting void applyPixConsumerDefaults() in " + TransactionContext.instant().getSessionContext()));
        }
        if ((resources = TransactionContext.instant().getPixPdqResources()) == null) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"No PixPdqResources available for setting defaults");
            }
            return;
        }
        ApplicationFacilityAndAuthorityProperties properties = resources.getRhioConfiguration().getPixConfig().getPixConsumerProperties();
        this.setDefaults(properties);
    }

    public void applyPixSourceDefaults() throws UnavailableResourcesException {
        RhioDedicatedResources resources;
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting void applyPixSourceDefaults() in " + TransactionContext.instant().getSessionContext()));
        }
        if ((resources = TransactionContext.instant().getPixPdqResources()) == null) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"No PixPdqResources available for setting defaults");
            }
            return;
        }
        ApplicationFacilityAndAuthorityProperties properties = resources.getRhioConfiguration().getPixConfig().getPixSourceProperties();
        this.setDefaults(properties);
    }

    public void applyPdqConsumerDefaults() throws UnavailableResourcesException {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting void applyPdqConsumerDefaults() in " + TransactionContext.instant().getSessionContext()));
        }
        this.applyPixConsumerDefaults();
    }

    private void setDefaults(ApplicationFacilityAndAuthorityProperties properties) {
        if (!this.useDefaultAssigningAuthority) {
            return;
        }
        if (Utils.isEmptyOrNull(this.namespaceId)) {
            this.namespaceId = properties.getAssigningAuthorityNamespaceId();
        }
        if (Utils.isEmptyOrNull(this.universalId)) {
            this.universalId = properties.getAssigningAuthorityUniversalId();
        }
        if (Utils.isEmptyOrNull(this.universalIdType)) {
            this.universalIdType = properties.getAssigningAuthorityUniversalIdType();
        }
    }

    public String getNamespaceId() throws UnavailableResourcesException {
        return this.namespaceId;
    }

    public void setNamespaceId(String pNamespaceId) {
        this.namespaceId = pNamespaceId;
    }

    public String getUniversalId() throws UnavailableResourcesException {
        return this.universalId;
    }

    public void setUniversalId(String pUniversalId) {
        this.universalId = pUniversalId;
    }

    public String getUniversalIdType() throws UnavailableResourcesException {
        return this.universalIdType;
    }

    public void setUniversalIdType(String pUniversalIdType) {
        this.universalIdType = pUniversalIdType;
    }

    public String getUniversalIdTypeCode() throws UnavailableResourcesException {
        return this.universalIdTypeCode;
    }

    public void setUniversalIdTypeCode(String pUniversalIdTypeCode) {
        this.universalIdTypeCode = pUniversalIdTypeCode;
    }

    public boolean isUseDefaultAssigningAuthority() {
        return this.useDefaultAssigningAuthority;
    }

    public void setUseDefaultAssigningAuthority(boolean pUseDefaultAssigningAuthority) {
        this.useDefaultAssigningAuthority = pUseDefaultAssigningAuthority;
    }

    public String toHL7Id() {
        String rhioId = this.namespaceId.concat("&").concat(this.universalId).concat("&").concat(this.universalIdType);
        return rhioId;
    }

    public String toString() {
        StringBuffer retValue = new StringBuffer();
        retValue.append("AssigningAuthority ( ").append("namespaceId=[").append(this.namespaceId).append("]").append("    ").append("universalId=[").append(this.universalId).append("]").append("    ").append("universalIdType=[").append(this.universalIdType).append("]").append("    ").append("useDefaultAssigningAuthority=[").append(this.useDefaultAssigningAuthority).append("]").append("    ").append("universalIdTypeCode=[").append(this.universalIdTypeCode).append("]").append("    ").append(" )");
        return retValue.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.namespaceId == null ? 0 : this.namespaceId.hashCode());
        result = 31 * result + (this.universalId == null ? 0 : this.universalId.hashCode());
        result = 31 * result + (this.universalIdType == null ? 0 : this.universalIdType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssigningAuthorityType other = (AssigningAuthorityType)obj;
        if (this.namespaceId == null ? other.namespaceId != null : !this.namespaceId.equals(other.namespaceId)) {
            return false;
        }
        if (this.universalId == null ? other.universalId != null : !this.universalId.equals(other.universalId)) {
            return false;
        }
        return !(this.universalIdType == null ? other.universalIdType != null : !this.universalIdType.equals(other.universalIdType));
    }
}

