/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.xds;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.ohf.bridge.conf.Configurations;
import org.eclipse.ohf.bridge.conf.UnavailableResourcesException;
import org.eclipse.ohf.bridge.type.PatientIdType;
import org.eclipse.ohf.bridge.type.PatientInfoType;
import org.eclipse.ohf.bridge.type.XDSDocType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XDSDocTypeToCDA {
    private DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private DocumentBuilder parser = this.factory.newDocumentBuilder();
    private Document xmlDoc = this.parser.parse(Configurations.getGlobalConfigurations().getCdaBase());
    private XPath xpath = XPathFactory.newInstance().newXPath();

    public Document getDocument() {
        return this.xmlDoc;
    }

    private Node searchPath(String searchExpr) throws XPathExpressionException {
        Node objectNode = (Node)this.xpath.evaluate(searchExpr, this.xmlDoc, XPathConstants.NODE);
        return objectNode;
    }

    private String transform() throws TransformerFactoryConfigurationError, TransformerException {
        DOMSource source = new DOMSource(this.xmlDoc);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(os);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(source, result);
        return os.toString();
    }

    public String convert(XDSDocType pDocument) throws TransformerFactoryConfigurationError, TransformerException, XPathExpressionException, UnavailableResourcesException {
        PatientInfoType patient = pDocument.getPatientInfo();
        PatientIdType id = patient.getPatientIdentifier();
        this.setPatientId(id.getIdNumber());
        this.setPatientIdRoot(id.getAssigningAuthorityType().getUniversalId());
        this.setPatientFirstName(patient.getPatientName().getGivenName());
        this.setPatientLastName(patient.getPatientName().getFamilyName());
        this.setPatientStreetAddress(patient.getPatientAddress().getStreetAddress());
        this.setPatientCity(patient.getPatientAddress().getCity());
        this.setPatientState(patient.getPatientAddress().getStateOrProvince());
        this.setPatientPostalCode(patient.getPatientAddress().getZipOrPostalCode());
        this.setPatientCountry(patient.getPatientAddress().getCountry());
        this.setPatientGender(patient.getPatientSex());
        this.setPatientBirthTime(patient.getPatientDateOfBirth());
        this.setDocumentTitle(pDocument.getDocumentTitle());
        this.setDocumentContent(pDocument.getBase64EncodedDocument());
        this.setDocumentMime(pDocument.getMimeType());
        this.setDocumentEncoding(pDocument.getEncodingType());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        this.setEffectiveTime(sdf.format(new Date()));
        return this.transform();
    }

    private void setElementValue(String path, String value) throws XPathExpressionException {
        Node n = this.searchPath(path);
        if (n != null && value != null && !value.equals("")) {
            n.setTextContent(value);
        }
    }

    private void setAttributeValue(String path, String attributeName, String value) throws XPathExpressionException {
        Node a;
        Node n = this.searchPath(path);
        if (n != null && value != null && !value.equals("") && (a = n.getAttributes().getNamedItem(attributeName)) != null) {
            a.setTextContent(value);
        }
    }

    private void setPatientId(String v) throws XPathExpressionException {
        this.setAttributeValue("/ClinicalDocument/recordTarget/patientRole/id", "extension", v);
    }

    private void setPatientIdRoot(String v) throws XPathExpressionException {
        this.setAttributeValue("/ClinicalDocument/recordTarget/patientRole/id", "root", v);
    }

    private void setEffectiveTime(String v) throws XPathExpressionException {
        this.setAttributeValue("/ClinicalDocument/effectiveTime", "value", v);
    }

    private void setPatientFirstName(String v) throws XPathExpressionException {
        this.setElementValue("/ClinicalDocument/recordTarget/patientRole/patient/name/family", v);
    }

    private void setPatientLastName(String f) throws XPathExpressionException {
        this.setElementValue("/ClinicalDocument/recordTarget/patientRole/patient/name/given", f);
    }

    private void setPatientGender(String f) throws XPathExpressionException {
        this.setAttributeValue("/ClinicalDocument/recordTarget/patientRole/patient/administrativeGenderCode", "code", f);
    }

    private void setPatientBirthTime(String f) throws XPathExpressionException {
        this.setAttributeValue("/ClinicalDocument/recordTarget/patientRole/patient/birthTime", "value", f);
    }

    private void setPatientStreetAddress(String f) throws XPathExpressionException {
        this.setElementValue("/ClinicalDocument/recordTarget/patientRole/addr/streetAddressLine", f);
    }

    private void setPatientCity(String f) throws XPathExpressionException {
        this.setElementValue("/ClinicalDocument/recordTarget/patientRole/addr/city", f);
    }

    private void setPatientState(String f) throws XPathExpressionException {
        this.setElementValue("/ClinicalDocument/recordTarget/patientRole/addr/state", f);
    }

    private void setPatientPostalCode(String f) throws XPathExpressionException {
        this.setElementValue("/ClinicalDocument/recordTarget/patientRole/addr/postalCode", f);
    }

    private void setPatientCountry(String f) throws XPathExpressionException {
        this.setElementValue("/ClinicalDocument/recordTarget/patientRole/addr/country", f);
    }

    private void setDocumentTitle(String f) throws XPathExpressionException {
        this.setElementValue("/ClinicalDocument/title", f);
    }

    private void setDocumentContent(String f) throws XPathExpressionException {
        this.setElementValue("/ClinicalDocument/component/nonXMLBody/text", f);
    }

    private void setDocumentMime(String f) throws XPathExpressionException {
        this.setAttributeValue("/ClinicalDocument/component/nonXMLBody/text", "mediaType", f);
    }

    private void setDocumentEncoding(String f) throws XPathExpressionException {
        this.setAttributeValue("/ClinicalDocument/component/nonXMLBody/text", "representation", f);
    }
}

