/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.utilities;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.eclipse.ohf.utilities.OHFException;

public class Iso8601Date {
    public static final int IGNORE = 0;
    public static final int REQUIRED = 1;
    public static final int OPTIONAL = 2;
    public static final int PROHIBITED = 3;
    public static final int CLEAR = 4;
    public static final int SETLOCAL = 5;
    public static final int IF_PRESENT = 6;
    public static final String ISO_DATE_VALIDATION_FULL = "YYYY[MM[DD[HH[NN[SS[.U[U[U[U]]]]]]]]]";
    public static final String ISO_DATE_VALIDATION_DATE = "YYYY[MM[DD]]]";
    public static final String DEF_OUTPUT_FORMAT = "YYYYMMDDHHNNSS.SSS";
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;
    private int milli;
    private int tzHour;
    private int tzMinute;
    private Boolean tzNegative = null;
    private boolean inFraction;

    public Iso8601Date() {
        this.reset(true);
    }

    private void reset(boolean timezoneToo) {
        this.year = -1;
        this.month = -1;
        this.day = -1;
        this.hour = -1;
        this.minute = -1;
        this.second = -1;
        this.milli = -1;
        if (timezoneToo) {
            this.tzHour = 0;
            this.tzMinute = 0;
            this.tzNegative = null;
        }
    }

    public String validate() {
        StringBuilder s = new StringBuilder();
        boolean content = false;
        content = this.checkField(s, this.milli, content, 0, 999, "millseconds");
        content = this.checkField(s, this.second, content, 0, 59, "seconds");
        content = this.checkField(s, this.minute, content, 0, 59, "minutes");
        content = this.checkField(s, this.hour, content, 0, 23, "hours");
        content = this.checkField(s, this.day, content, 1, 31, "days");
        content = this.checkField(s, this.month, content, 1, 12, "months");
        if (!(content = this.checkField(s, this.year, content, 1000, 2500, "years"))) {
            s.append("No values have been set\r\n");
        }
        if (this.year != -1 && this.month != -1 && this.day != -1 && this.day > this.daysForMonth(this.month, this.year)) {
            s.append("the day " + Integer.toString(this.day) + " is not valid for the month " + Integer.toString(this.month) + " in the year " + Integer.toString(this.year) + "\r\n");
        }
        if (this.tzNegative != null) {
            content = this.checkField(s, this.tzMinute, content, 0, 59, "timezone minutes");
            content = this.checkField(s, this.tzHour, content, 0, 13, "timezone hours");
        }
        if (s.length() > 0) {
            return s.toString();
        }
        return null;
    }

    private boolean checkField(StringBuilder s, int value, boolean required, int min, int max, String desc) {
        if (value == -1) {
            if (required) {
                s.append("value for " + desc + " is missing and required in this context");
            }
            return required;
        }
        if (value < min || value > max) {
            s.append("value for " + desc + " is invalid (" + Integer.toString(min) + " - " + Integer.toString(max) + ")");
        }
        return true;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        this.minute = minute;
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int second) {
        this.second = second;
    }

    public int getMilli() {
        return this.milli;
    }

    public void setMilli(int milli) {
        this.milli = milli;
    }

    public int getTzHour() {
        return this.tzHour;
    }

    public void setTzHour(int tzHour) {
        this.tzHour = tzHour;
    }

    public int getTzMinute() {
        return this.tzMinute;
    }

    public void setTzMinute(int tzMinute) {
        this.tzMinute = tzMinute;
    }

    public Boolean getTzNegative() {
        return this.tzNegative;
    }

    public void setTzNegative(Boolean tzNegative) {
        this.tzNegative = tzNegative;
    }

    public Iso8601Date correctForTZ() {
        Iso8601Date result = new Iso8601Date();
        result.year = this.year;
        result.month = this.month;
        result.day = this.day;
        result.hour = this.hour;
        result.minute = this.minute;
        result.second = this.second;
        result.milli = this.milli;
        if (this.tzNegative != null) {
            if (this.tzNegative.booleanValue()) {
                result.addMin(-(this.tzHour * 60 + this.tzMinute));
            } else {
                result.addMin(this.tzHour * 60 + this.tzMinute);
            }
        }
        return result;
    }

    private void addMin(int i) {
        if (i != 0) {
            if (this.minute == -1) {
                this.addHour(i / 60);
            } else {
                this.minute += i;
                int hr = 0;
                while (this.minute < 0) {
                    this.minute += 60;
                    --hr;
                }
                while (this.minute >= 60) {
                    this.minute -= 60;
                    ++hr;
                }
                this.addHour(hr);
            }
        }
    }

    private void addHour(int i) {
        if (i != 0) {
            if (this.hour == -1) {
                this.addDay(i / 24);
            } else {
                this.hour += i;
                int d = 0;
                while (this.hour < 0) {
                    this.hour += 60;
                    --d;
                }
                while (this.hour >= 60) {
                    this.hour -= 60;
                    ++d;
                }
                this.addDay(d);
            }
        }
    }

    private void addDay(int i) {
        if (i != 0 && this.day != -1) {
            this.day += i;
            while (this.day < 1 || this.day > this.daysForMonth(this.month, this.year)) {
                if (this.day < 1) {
                    this.day += this.daysForMonth(this.month, this.year);
                    --this.month;
                    if (this.month == 0) {
                        this.month = 12;
                        --this.year;
                    }
                }
                if (this.day <= this.daysForMonth(this.month, this.year)) continue;
                ++this.month;
                if (this.month == 13) {
                    this.month = 1;
                    ++this.year;
                }
                this.day -= this.daysForMonth(this.month, this.year);
            }
        }
    }

    public Date getAsDate(int timezone) throws OHFException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.clear();
        if (this.year != -1) {
            cal.set(1, this.year);
        }
        if (this.month != -1) {
            cal.set(2, this.month);
        }
        if (this.day != -1) {
            cal.set(5, this.day);
        }
        if (this.hour != -1) {
            cal.set(11, this.hour);
        }
        if (this.minute != -1) {
            cal.set(12, this.minute);
        }
        if (this.second != -1) {
            cal.set(13, this.second);
        }
        if (this.milli != -1) {
            cal.set(14, this.milli);
        }
        if (timezone == 1 || timezone == 6 || timezone == 2) {
            if (timezone == 1 && this.tzNegative == null) {
                throw new OHFException("Timezone required, but not defined");
            }
            if (this.tzNegative != null) {
                TimeZone tzMsg = TimeZone.getTimeZone("GMT" + this.prepTimezone());
                cal.setTimeZone(tzMsg);
            }
        }
        return cal.getTime();
    }

    public void setAsDate(Date date, int timezone) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        this.reset(true);
        this.year = cal.get(1);
        this.month = cal.get(2);
        this.day = cal.get(5);
        this.hour = cal.get(11);
        this.minute = cal.get(12);
        this.second = cal.get(13);
        this.milli = cal.get(14);
        if (timezone == 4) {
            this.tzHour = 0;
            this.tzMinute = 0;
            this.tzNegative = null;
        } else if (timezone == 5) {
            TimeZone tzLcl = TimeZone.getDefault();
            int offset = tzLcl.getOffset(date.getTime());
            if (offset < 0) {
                this.tzNegative = new Boolean(true);
                offset = -offset;
            } else {
                this.tzNegative = new Boolean(true);
            }
            this.tzHour = offset / 3600000;
            this.tzMinute = (offset - this.tzHour * 1000 * 60 * 60) / 60000;
        }
    }

    public String render(String format, boolean checkValues, int timezone) throws OHFException {
        String v = this.validate();
        if (v != null) {
            throw new OHFException(v);
        }
        StringBuffer str = new StringBuffer();
        this.render(str, checkValues, format.length() >= 4 && "yyyy".equalsIgnoreCase(format.substring(0, 4)), 4, this.year, format, "year", null);
        this.render(str, checkValues, format.length() >= 6 && "mm".equalsIgnoreCase(format.substring(4, 6)), 2, this.month, format, "month", null);
        this.render(str, checkValues, format.length() >= 8 && "dd".equalsIgnoreCase(format.substring(6, 8)), 2, this.day, format, "day", null);
        this.render(str, checkValues, format.length() >= 10 && "hh".equalsIgnoreCase(format.substring(8, 10)), 2, this.hour, format, "hour", null);
        this.render(str, checkValues, format.length() >= 12 && "nn".equalsIgnoreCase(format.substring(10, 12)), 2, this.minute, format, "minute", null);
        this.render(str, checkValues, format.length() >= 14 && "ss".equalsIgnoreCase(format.substring(12, 14)), 2, this.second, format, "second", null);
        if (format.length() >= 18 && "sss".equalsIgnoreCase(format.substring(15, 18))) {
            this.render(str, checkValues, true, 3, this.milli, format, "millisecond", ".");
        } else if (format.length() == 17 && "ss".equalsIgnoreCase(format.substring(15, 17))) {
            this.render(str, checkValues, true, 2, this.milli / 10, format, "millisecond", ".");
        } else if (format.length() == 16 && "s".equalsIgnoreCase(format.substring(15, 16))) {
            this.render(str, checkValues, true, 1, this.milli / 100, format, "millisecond", ".");
        }
        if (timezone == 1 || timezone == 6) {
            if (timezone == 1 && this.tzNegative == null) {
                throw new OHFException("Timezone required, but not defined");
            }
            if (this.tzNegative != null) {
                if (this.tzNegative.booleanValue()) {
                    str.append('-');
                } else {
                    str.append('+');
                }
                this.render(str, checkValues, true, 2, this.tzHour, format, "timezone hour", null);
                this.render(str, checkValues, true, 2, this.tzMinute, format, "timezone minutes", null);
            }
        }
        if (timezone == 3 && this.tzNegative != null) {
            throw new OHFException("Timezone prohibited, but is defined");
        }
        return str.toString();
    }

    private void render(StringBuffer str, boolean checkValues, boolean render, int len, int value, String format, String desc, String prefix) throws OHFException {
        if (render) {
            if (value != -1) {
                if (prefix != null) {
                    str.append(prefix);
                }
                str.append(StringUtils.leftPad((String)Integer.toString(value), (int)len, (String)"0"));
            } else if (checkValues) {
                throw new OHFException("format '" + format + "' specifies " + desc + " but no such value has been provided");
            }
        }
    }

    public void parse(String value) {
        this.parse(value, ISO_DATE_VALIDATION_FULL, 2);
    }

    public String parse(String value, String format, int timezone) {
        this.reset(timezone != 0);
        String[] parts = new String[]{value};
        this.tzNegative = null;
        if (value.indexOf(43) > 0) {
            parts = StringUtils.split((String)value, (String)"+", (int)2);
            this.tzNegative = new Boolean(false);
        } else if (value.indexOf(45) > 0) {
            parts = StringUtils.split((String)value, (String)"-", (int)2);
            this.tzNegative = new Boolean(true);
        }
        String error = this.checkSections(parts[0], value, format);
        if (error != null) {
            return error;
        }
        if (parts.length > 1 && timezone != 0) {
            error = this.checkSections(parts[1], value, "TTtt");
        }
        if (error != null) {
            return error;
        }
        if (timezone == 1 ? parts.length < 2 : timezone == 3 && parts.length > 1) {
            return "No Timezone allowed, but a timezone found";
        }
        return null;
    }

    public static Date parseToDate(String value, String format, int timezone) throws OHFException {
        Iso8601Date d = new Iso8601Date();
        String err = d.parse(value, format, timezone);
        if (err != null) {
            throw new OHFException("Error occurred reading date: '" + value + "': " + err);
        }
        return d.getAsDate(timezone);
    }

    public static String renderFromDate(Date date, String format, int timezone) throws OHFException {
        Iso8601Date d = new Iso8601Date();
        d.setAsDate(date, timezone == 1 ? 5 : 4);
        return d.render(format, true, timezone);
    }

    private String checkSections(String content, String whole, String mask) {
        String workingMask = StringUtils.strip((String)mask, (String)"]");
        String[] parts = new String[]{"", workingMask};
        boolean first = true;
        this.inFraction = false;
        do {
            String token;
            if ((token = (parts = StringUtils.splitPreserveAllTokens((String)parts[1], (String)"[", (int)2))[0]) != null) {
                String section;
                String string = section = content == null || content.length() < token.length() ? null : content.substring(0, token.length());
                if (section == null) {
                    if (first) {
                        return "The section " + token + " in the Date format " + mask + " was not found in the value " + whole;
                    }
                } else {
                    if (section.length() < token.length()) {
                        return "The section " + token + " in the Date format " + mask + " was not completed in the value " + whole + " - value was " + section;
                    }
                    String error = this.checkSection(token, section);
                    if (error != null) {
                        return error;
                    }
                    content = section.length() >= content.length() ? null : content.substring(section.length());
                }
            }
            first = false;
        } while (parts.length > 1 && content != null);
        if (content != null) {
            return "The content " + content + " in the Date " + whole + " is not allowed by the format " + mask;
        }
        return null;
    }

    private boolean starts(String source, String test) {
        return source == null || source.length() < test.length() ? false : source.substring(0, test.length()).equals(test);
    }

    private String checkSection(String token, String content) {
        String error = null;
        if (this.starts(token, "YYYY")) {
            error = this.checkYear(content.substring(0, 4));
            if (error != null) {
                return error;
            }
            token = token.substring(4, token.length());
            content = content.substring(4, content.length());
        }
        if (this.starts(token, "MM")) {
            error = this.checkMonth(content.substring(0, 2));
            if (error != null) {
                return error;
            }
            token = token.substring(2, token.length());
            content = content.substring(2, content.length());
        }
        if (this.starts(token, "DD")) {
            error = this.checkDay(content.substring(0, 2));
            if (error != null) {
                return error;
            }
            token = token.substring(2, token.length());
            content = content.substring(2, content.length());
        }
        if (this.starts(token, "HH")) {
            error = this.checkHour(content.substring(0, 2), false);
            if (error != null) {
                return error;
            }
            token = token.substring(2, token.length());
            content = content.substring(2, content.length());
        }
        if (this.starts(token, "TT")) {
            error = this.checkHour(content.substring(0, 2), true);
            if (error != null) {
                return error;
            }
            token = token.substring(2, token.length());
            content = content.substring(2, content.length());
        }
        if (this.starts(token, "NN")) {
            error = this.checkMinute(content.substring(0, 2), false);
            if (error != null) {
                return error;
            }
            token = token.substring(2, token.length());
            content = content.substring(2, content.length());
        }
        if (this.starts(token, "tt")) {
            error = this.checkMinute(content.substring(0, 2), true);
            if (error != null) {
                return error;
            }
            token = token.substring(2, token.length());
            content = content.substring(2, content.length());
        }
        if (this.starts(token, "SS") && !this.inFraction) {
            error = this.checkSecond(content.substring(0, 2));
            if (error != null) {
                return error;
            }
            token = token.substring(2, token.length());
            content = content.substring(2, content.length());
        }
        if (this.starts(token, ".") && !this.inFraction) {
            error = this.checkDot(content.substring(0, 1));
            if (error != null) {
                return error;
            }
            token = token.substring(1, token.length());
            content = content.substring(1, content.length());
        }
        while (this.starts(token, "U") && this.inFraction) {
            error = this.checkFraction(content.substring(0, 1));
            if (error != null) {
                return error;
            }
            token = token.substring(1, token.length());
            content = content.substring(1, content.length());
        }
        if (token != null && !token.equals("")) {
            return "The Date Format fragment " + token + " is not known";
        }
        return null;
    }

    private String checkYear(String value) {
        if (value.length() != 4) {
            return "Year Value " + value + " is not 4 digits in length";
        }
        if (!StringUtils.isNumeric((String)value)) {
            return "Year Value " + value + " is not numerical";
        }
        this.year = Integer.parseInt(value);
        if (this.year <= 0) {
            return "Year Value " + value + ": negative numbers are not supported";
        }
        return null;
    }

    private String checkMonth(String value) {
        if (value.length() != 2) {
            return "Month Value " + value + " is not 2 digits in length";
        }
        if (!StringUtils.isNumeric((String)value)) {
            return "Month Value " + value + " is not numerical";
        }
        this.month = Integer.parseInt(value);
        if (this.month <= 0 || this.month > 12) {
            return "Month Value " + value + ": month must be 1 - 12";
        }
        return null;
    }

    private String checkDay(String value) {
        if (value.length() != 2) {
            return "Day Value " + value + " is not 2 digits in length";
        }
        if (!StringUtils.isNumeric((String)value)) {
            return "Day Value " + value + " is not numerical";
        }
        this.day = Integer.parseInt(value);
        if (this.day <= 0) {
            return "Day Value " + value + ": Day must be >= 1";
        }
        if (this.month == 0) {
            return "Day Value " + value + ": Month must be known";
        }
        if (this.year == 0) {
            return "Day Value " + value + ": Year must be known";
        }
        if (this.day > this.daysForMonth(this.month, this.year)) {
            return "Day Value " + value + ": is illegal for the month " + Integer.toString(this.month) + "-" + Integer.toString(this.year);
        }
        return null;
    }

    private int daysForMonth(int m, int y) {
        int[] daysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (m == 2 && new GregorianCalendar().isLeapYear(y)) {
            return 29;
        }
        return daysInMonth[m - 1];
    }

    private String checkHour(String value, boolean inTimezone) {
        if (value.length() != 2) {
            return "Hour Value " + value + " is not 2 digits in length";
        }
        if (!StringUtils.isNumeric((String)value)) {
            return "Hour Value " + value + " is not numerical";
        }
        if (inTimezone) {
            this.tzHour = Integer.parseInt(value);
            if (this.tzHour < 0) {
                return "Timezone Hour Value " + value + ": Hour must be >= 0";
            }
            if (this.tzHour > 12) {
                return "Timezone Hour Value " + value + ": Hour must be <= 12";
            }
        } else {
            this.hour = Integer.parseInt(value);
            if (this.hour < 0) {
                return "Hour Value " + value + ": Hour must be >= 0";
            }
            if (inTimezone && this.hour > 12) {
                return "Hour Value " + value + ": Hour must be <= 12";
            }
            if (this.hour > 23) {
                return "Hour Value " + value + ": Hour must be <= 23";
            }
        }
        return null;
    }

    private String checkMinute(String value, boolean inTimezone) {
        if (value.length() != 2) {
            return "Minute Value " + value + " is not 2 digits in length";
        }
        if (!StringUtils.isNumeric((String)value)) {
            return "Minute Value " + value + " is not numerical";
        }
        if (inTimezone) {
            this.tzMinute = Integer.parseInt(value);
            if (this.tzMinute != 0 && this.tzMinute != 30) {
                return "Timezone Minute Value " + value + ": Minute must be 0 or 30";
            }
        } else {
            this.minute = Integer.parseInt(value);
            if (this.minute < 0 || this.minute > 59) {
                return "Minute Value " + value + ": Minute must be 0 and 59";
            }
        }
        return null;
    }

    private String checkSecond(String value) {
        if (value.length() != 2) {
            return "Second Value " + value + " is not 2 digits in length";
        }
        if (!StringUtils.isNumeric((String)value)) {
            return "Second Value " + value + " is not numerical";
        }
        this.second = Integer.parseInt(value);
        if (this.second < 0 || this.second > 59) {
            return "Second Value " + value + ": Second must be 0 and 59";
        }
        return null;
    }

    private String checkDot(String value) {
        if (value.equals(".")) {
            this.inFraction = true;
            return null;
        }
        return "Expected '.'";
    }

    private String checkFraction(String value) {
        if (!StringUtils.isNumeric((String)value)) {
            return "Fraction Value " + value + " is not numerical";
        }
        return null;
    }

    private String prepTimezone() {
        return String.valueOf(this.tzNegative != false ? "-" : "+") + StringUtils.leftPad((String)Integer.toString(this.tzHour), (int)2, (char)'0') + StringUtils.leftPad((String)Integer.toString(this.tzMinute), (int)2, (char)'0');
    }
}

