/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.utilities;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.ohf.utilities.PreviewStreamBuffer;

public class PreviewStream
extends InputStream {
    private InputStream source;
    private PreviewStreamBuffer buffer;
    private boolean finished;

    public PreviewStream(InputStream stream) {
        this.setSource(stream);
    }

    public InputStream getSource() {
        return this.source;
    }

    public void setSource(InputStream source) {
        this.source = source;
        this.buffer = new PreviewStreamBuffer();
    }

    public void reset(boolean finished) {
        this.buffer.reset();
        this.finished = finished;
    }

    public int read() throws IOException {
        if (this.buffer.hasContent()) {
            return this.buffer.read();
        }
        int value = this.source.read();
        if (!this.finished) {
            this.buffer.add(value);
        }
        return value;
    }

    public int available() throws IOException {
        return this.buffer.available() + this.source.available();
    }

    public void close() throws IOException {
        this.reset(true);
        this.source.close();
    }

    public boolean markSupported() {
        return false;
    }
}

