/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.metadata.transform;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ohf.ihe.common.ebxml._3._0.lcm.LCMFactory;
import org.eclipse.ohf.ihe.common.ebxml._3._0.lcm.SubmitObjectsRequestType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.AssociationType1;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.ClassificationType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.ObjectRefType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.RimFactory;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.RimPackage;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.SlotType1;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.ValueListType;
import org.eclipse.ohf.ihe.xds.metadata.DocumentEntryType;
import org.eclipse.ohf.ihe.xds.metadata.FolderType;
import org.eclipse.ohf.ihe.xds.metadata.ProvideAndRegisterDocumentSetType;
import org.eclipse.ohf.ihe.xds.metadata.transform.EbXML_3_0DocumentEntryTransformer;
import org.eclipse.ohf.ihe.xds.metadata.transform.EbXML_3_0FolderTransformer;
import org.eclipse.ohf.ihe.xds.metadata.transform.EbXML_3_0SubmissionSetTransformer;
import org.eclipse.ohf.ihe.xds.metadata.transform.EbXML_3_0TransformerUtils;
import org.eclipse.ohf.ihe.xds.metadata.transform.MetadataTransformationException;
import org.eclipse.ohf.ihe.xds.metadata.transform.ProvideAndRegisterDocumentSetTransformer;

public class EbXML_3_0ProvideAndRegisterDocumentSetTransformer
implements ProvideAndRegisterDocumentSetTransformer {
    public static final String DESCRIPTOR = "EBXML_3_0_PRDS_XFRMR";
    private static final Logger logger;
    private SubmitObjectsRequestType submitReq = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.xds.metadata.transform.EbXML_3_0ProvideAndRegisterDocumentSetTransformer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public SubmitObjectsRequestType getSubmitReq() {
        return this.submitReq;
    }

    public void transform(ProvideAndRegisterDocumentSetType docSet) throws MetadataTransformationException {
        if (docSet.getSubmissionSet() == null) {
            logger.error((Object)"SubmissionSet metadata is null.Cannot proceed with transformation.");
            throw new MetadataTransformationException("SubmissionSet metadata is null.Cannot proceed with transformation.");
        }
        if (docSet.getSubmissionSet().getEntryUUID() == null) {
            logger.error((Object)"SubmissionSet entryUUID is null. Cannot proceed with transformation.");
            throw new MetadataTransformationException("SubmissionSet entryUUID is null. Cannot proceed with transformation.");
        }
        this.submitReq = LCMFactory.eINSTANCE.createSubmitObjectsRequestType();
        this.submitReq.setRegistryObjectList(RimFactory.eINSTANCE.createRegistryObjectListType());
        this.setObjectRefs();
        this.setSubmissionSet(docSet);
        ClassificationType classification = RimFactory.eINSTANCE.createClassificationType();
        classification.setId(EbXML_3_0TransformerUtils.getRandomId("cl", 0));
        classification.setClassifiedObject(docSet.getSubmissionSet().getEntryUUID());
        classification.setClassificationNode("urn:uuid:a54d6aa5-d40d-43f9-88c5-b4633d873bdd");
        this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__CLASSIFICATION, (Object)classification);
        if (docSet.getDocumentEntry().isEmpty()) {
            logger.info((Object)"Submission set contains no documents.");
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding document metadata to submission set.  There are " + docSet.getDocumentEntry().size() + " documents to add."));
            }
            this.setDocumentEntries(docSet);
        }
        if (docSet.getFolder().isEmpty()) {
            logger.info((Object)"Submission set contains no folders.");
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding folder metadata to submission set.  There are " + docSet.getFolder().size() + " folders to add."));
            }
            this.setFolders(docSet);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Verifying Submission Set associated documents and associated folders.");
        }
        this.validateAssociations(docSet);
    }

    private void setObjectRefs() {
        ObjectRefType oRef = RimFactory.eINSTANCE.createObjectRefType();
        oRef.setId("urn:uuid:7edca82f-054d-47f2-a032-9b2a5b5186c1");
        this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)oRef);
        oRef = RimFactory.eINSTANCE.createObjectRefType();
        oRef.setId("urn:uuid:93606bcf-9494-43ec-9b4e-a7748d1a838d");
        this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)oRef);
        oRef = RimFactory.eINSTANCE.createObjectRefType();
        oRef.setId("urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a");
        this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)oRef);
        oRef = RimFactory.eINSTANCE.createObjectRefType();
        oRef.setId("urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f");
        this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)oRef);
        oRef = RimFactory.eINSTANCE.createObjectRefType();
        oRef.setId("urn:uuid:2c6b8cb7-8b2a-4051-b291-b1ae6a575ef4");
        this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)oRef);
        oRef = RimFactory.eINSTANCE.createObjectRefType();
        oRef.setId("urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d");
        this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)oRef);
        oRef = RimFactory.eINSTANCE.createObjectRefType();
        oRef.setId("urn:uuid:f33fb8ac-18af-42cc-ae0e-ed0b0bdb91e1");
        this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)oRef);
        oRef = RimFactory.eINSTANCE.createObjectRefType();
        oRef.setId("urn:uuid:cccf5598-8b07-4b77-a05e-ae952c785ead");
        this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)oRef);
        oRef = RimFactory.eINSTANCE.createObjectRefType();
        oRef.setId("urn:uuid:f0306f51-975f-434e-a61c-c59651d33983");
        this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)oRef);
        oRef = RimFactory.eINSTANCE.createObjectRefType();
        oRef.setId("urn:uuid:2e82c1f6-a085-4c72-9da3-8640a32e42ab");
        this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)oRef);
        oRef = RimFactory.eINSTANCE.createObjectRefType();
        oRef.setId("urn:uuid:58a6f841-87b3-4a3e-92fd-a8ffeff98427");
        this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)oRef);
        oRef = RimFactory.eINSTANCE.createObjectRefType();
        oRef.setId("urn:uuid:a7058bb9-b4e4-4307-ba5b-e3f0ab85e12d");
        this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)oRef);
        oRef = RimFactory.eINSTANCE.createObjectRefType();
        oRef.setId("urn:uuid:aa543740-bdda-424e-8c96-df4873be8500");
        this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)oRef);
        oRef = RimFactory.eINSTANCE.createObjectRefType();
        oRef.setId("urn:uuid:554ac39e-e3fe-47fe-b233-965d2a147832");
        this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)oRef);
        oRef = RimFactory.eINSTANCE.createObjectRefType();
        oRef.setId("urn:uuid:96fdda7c-d067-4183-912e-bf5ee74998a8");
        this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)oRef);
        oRef = RimFactory.eINSTANCE.createObjectRefType();
        oRef.setId("urn:uuid:6b5aea1a-874d-4603-a4bc-96a0a7b38446");
        this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)oRef);
        oRef = RimFactory.eINSTANCE.createObjectRefType();
        oRef.setId("urn:uuid:1ba97051-7806-41a8-a48b-8fce7af683c5");
        this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)oRef);
        oRef = RimFactory.eINSTANCE.createObjectRefType();
        oRef.setId("urn:uuid:75df8f67-9973-4fbe-a900-df66cefecc5a");
        this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)oRef);
        oRef = RimFactory.eINSTANCE.createObjectRefType();
        oRef.setId("urn:uuid:f64ffdf0-4b97-4e06-b79f-a52b38ec2f8a");
        this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)oRef);
        oRef = RimFactory.eINSTANCE.createObjectRefType();
        oRef.setId("urn:uuid:a54d6aa5-d40d-43f9-88c5-b4633d873bdd");
        this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)oRef);
        oRef = RimFactory.eINSTANCE.createObjectRefType();
        oRef.setId("urn:uuid:d9d542f3-6cc4-48b6-8870-ea235fbc94c2");
        this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)oRef);
        oRef = RimFactory.eINSTANCE.createObjectRefType();
        oRef.setId("urn:uuid:2d03bffb-f426-4830-8413-bab8537a995b");
        this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)oRef);
    }

    private void setDocumentEntries(ProvideAndRegisterDocumentSetType docSet) throws MetadataTransformationException {
        Iterator i = docSet.getDocumentEntry().iterator();
        EbXML_3_0DocumentEntryTransformer deTransformer = new EbXML_3_0DocumentEntryTransformer();
        while (i.hasNext()) {
            DocumentEntryType de = (DocumentEntryType)i.next();
            if (de.getEntryUUID() == null) {
                logger.error((Object)"DocumentEntry.entryUUID is null. This DocumentEntry will not be included in the transformation.");
                continue;
            }
            if (de.isExisting()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found an existing Document Entry: " + de.getEntryUUID()));
                }
                ObjectRefType docRef = RimFactory.eINSTANCE.createObjectRefType();
                docRef.setId(de.getEntryUUID());
                this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)docRef);
            } else {
                deTransformer.transform(de);
                if (deTransformer.getExtrinsicObject() == null) {
                    logger.error((Object)("Null Extrinsic Object produced for " + de.getEntryUUID() + " . This DocumentEntry will not be included in the transformation."));
                    continue;
                }
                this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__EXTRINSIC_OBJECT, (Object)deTransformer.getExtrinsicObject());
                if (deTransformer.getAssociation() != null) {
                    this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__ASSOCIATION, (Object)deTransformer.getAssociation());
                    ObjectRefType parentRef = RimFactory.eINSTANCE.createObjectRefType();
                    parentRef.setId(deTransformer.getAssociation().getTargetObject());
                    this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)parentRef);
                }
            }
            AssociationType1 association = RimFactory.eINSTANCE.createAssociationType1();
            association.setId(EbXML_3_0TransformerUtils.getRandomId("a", 0));
            association.setAssociationType("urn:oasis:names:tc:ebxml-regrep:AssociationType:HasMember");
            association.setSourceObject(docSet.getSubmissionSet().getEntryUUID());
            association.setTargetObject(de.getEntryUUID());
            SlotType1 submissionSetStatusSlot = RimFactory.eINSTANCE.createSlotType1();
            submissionSetStatusSlot.setName("SubmissionSetStatus");
            submissionSetStatusSlot.setValueList(RimFactory.eINSTANCE.createValueListType());
            ValueListType submissionSetStatusSlotValueList = submissionSetStatusSlot.getValueList();
            if (de.isExisting()) {
                submissionSetStatusSlotValueList.getValue().add((Object)"Reference");
            } else {
                submissionSetStatusSlotValueList.getValue().add((Object)"Original");
            }
            association.getSlot().add((Object)submissionSetStatusSlot);
            this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__ASSOCIATION, (Object)association);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"All document metadata added to submission set.");
        }
    }

    private void setSubmissionSet(ProvideAndRegisterDocumentSetType docSet) throws MetadataTransformationException {
        EbXML_3_0SubmissionSetTransformer ssTransformer = new EbXML_3_0SubmissionSetTransformer();
        ssTransformer.transform(docSet.getSubmissionSet());
        if (ssTransformer.getRegistryPackage() == null) {
            logger.error((Object)"Null RegistryPackage produced for submission set metadata.");
            throw new MetadataTransformationException("Null RegistryPackage produced for submission set metadata.");
        }
        this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__REGISTRY_PACKAGE, (Object)ssTransformer.getRegistryPackage());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"All submission set metadata added.");
        }
    }

    private void setFolders(ProvideAndRegisterDocumentSetType docSet) throws MetadataTransformationException {
        Iterator i = docSet.getFolder().iterator();
        EbXML_3_0FolderTransformer fTransformer = new EbXML_3_0FolderTransformer();
        while (i.hasNext()) {
            FolderType fol = (FolderType)i.next();
            if (fol.getEntryUUID() == null) {
                logger.error((Object)"Folder.entryUUID is null. This Folder will not be included in the transformation.");
                continue;
            }
            fTransformer.transform(fol);
            if (fol.isExisting()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found an existing Folder: " + fol.getEntryUUID()));
                }
                ObjectRefType folRef = RimFactory.eINSTANCE.createObjectRefType();
                folRef.setId(fol.getEntryUUID());
                this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)folRef);
            } else {
                if (fTransformer.getRegistryPackage() == null) {
                    logger.error((Object)("Null RegistryPackage produced for " + fol.getEntryUUID() + ". This Folder will not be included in the transformation."));
                    continue;
                }
                this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__REGISTRY_PACKAGE, (Object)fTransformer.getRegistryPackage());
                ClassificationType classification = RimFactory.eINSTANCE.createClassificationType();
                classification.setId(EbXML_3_0TransformerUtils.getRandomId("cf", 0));
                classification.setClassifiedObject(fol.getEntryUUID());
                classification.setClassificationNode("urn:uuid:d9d542f3-6cc4-48b6-8870-ea235fbc94c2");
                this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__CLASSIFICATION, (Object)classification);
            }
            if (fTransformer.getAssociatedDocuments() != null) {
                int j = 0;
                while (j < fTransformer.getAssociatedDocuments().length) {
                    this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__ASSOCIATION, (Object)fTransformer.getAssociatedDocuments()[j]);
                    AssociationType1 association = RimFactory.eINSTANCE.createAssociationType1();
                    association.setId(EbXML_3_0TransformerUtils.getRandomId("a", 0));
                    association.setAssociationType("urn:oasis:names:tc:ebxml-regrep:AssociationType:HasMember");
                    association.setSourceObject(docSet.getSubmissionSet().getEntryUUID());
                    association.setTargetObject(fTransformer.getAssociatedDocuments()[j].getId());
                    this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__ASSOCIATION, (Object)association);
                    ++j;
                }
            }
            AssociationType1 association = RimFactory.eINSTANCE.createAssociationType1();
            association.setId(EbXML_3_0TransformerUtils.getRandomId("a", 0));
            association.setAssociationType("urn:oasis:names:tc:ebxml-regrep:AssociationType:HasMember");
            association.setSourceObject(docSet.getSubmissionSet().getEntryUUID());
            association.setTargetObject(fol.getEntryUUID());
            this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__ASSOCIATION, (Object)association);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"All folder metadata added to submission set.");
        }
    }

    private void validateAssociations(ProvideAndRegisterDocumentSetType docSet) {
        AssociationType1 association;
        AssociationType1 assoc;
        Object o;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Verifying associated documents");
        }
        Iterator i = docSet.getSubmissionSet().getAssociatedDocuments().iterator();
        Iterator j = this.submitReq.getRegistryObjectList().getIdentifiable().iterator();
        boolean found = false;
        int numMissing = 0;
        while (i.hasNext()) {
            String docUUID = (String)i.next();
            while (j.hasNext() && !found) {
                o = j.next();
                if (!(o instanceof AssociationType1) || !(assoc = (AssociationType1)o).getAssociationType().equals("urn:oasis:names:tc:ebxml-regrep:AssociationType:HasMember") || !assoc.getSourceObject().equals(docSet.getSubmissionSet().getEntryUUID()) || !docUUID.equals(assoc.getTargetObject())) continue;
                found = true;
                break;
            }
            if (found) continue;
            logger.info((Object)("Found an associated document that is not represented as an AssocationType1: " + docUUID + ". Adding this document as an existing document to the metadata."));
            this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)docUUID);
            association = RimFactory.eINSTANCE.createAssociationType1();
            association.setId(EbXML_3_0TransformerUtils.getRandomId("a", 0));
            association.setAssociationType("urn:oasis:names:tc:ebxml-regrep:AssociationType:HasMember");
            association.setSourceObject(docSet.getSubmissionSet().getEntryUUID());
            association.setTargetObject(docUUID);
            SlotType1 submissionSetStatusSlot = RimFactory.eINSTANCE.createSlotType1();
            submissionSetStatusSlot.setName("SubmissionSetStatus");
            submissionSetStatusSlot.setValueList(RimFactory.eINSTANCE.createValueListType());
            ValueListType submissionSetStatusSlotValueList = submissionSetStatusSlot.getValueList();
            submissionSetStatusSlotValueList.getValue().add((Object)"Reference");
            association.getSlot().add((Object)submissionSetStatusSlot);
            this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__ASSOCIATION, (Object)association);
            ++numMissing;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Number of \"forgotten\" submission set existing associated documents: " + numMissing));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Verifying associated folders");
        }
        i = docSet.getSubmissionSet().getAssociatedFolders().iterator();
        j = this.submitReq.getRegistryObjectList().getIdentifiable().iterator();
        found = false;
        numMissing = 0;
        while (i.hasNext()) {
            String folUUID = (String)i.next();
            while (j.hasNext() && !found) {
                o = j.next();
                if (!(o instanceof AssociationType1) || !(assoc = (AssociationType1)o).getAssociationType().equals("urn:oasis:names:tc:ebxml-regrep:AssociationType:HasMember") || !assoc.getSourceObject().equals(docSet.getSubmissionSet().getEntryUUID()) || !folUUID.equals(assoc.getTargetObject())) continue;
                found = true;
                break;
            }
            if (found) continue;
            logger.info((Object)("Found an associated folder that is not represented as an AssocationType1: " + folUUID + ". Adding this document as an existing document to the metadata."));
            this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__OBJECT_REF, (Object)folUUID);
            association = RimFactory.eINSTANCE.createAssociationType1();
            association.setId(EbXML_3_0TransformerUtils.getRandomId("a", 0));
            association.setAssociationType("urn:oasis:names:tc:ebxml-regrep:AssociationType:HasMember");
            association.setSourceObject(docSet.getSubmissionSet().getEntryUUID());
            association.setTargetObject(folUUID);
            this.submitReq.getRegistryObjectList().getIdentifiableGroup().add((EStructuralFeature)RimPackage.Literals.DOCUMENT_ROOT__ASSOCIATION, (Object)association);
            ++numMissing;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Number of \"forgotten\" submission set existing associated folders: " + numMissing));
        }
    }
}

