/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.pix.source;

import org.apache.log4j.Logger;
import org.eclipse.ohf.hl7v2.core.message.MessageManager;
import org.eclipse.ohf.hl7v2.core.message.model.Segment;
import org.eclipse.ohf.hl7v2.core.message.model.SegmentList;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessage;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageException;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageUtilities;
import org.eclipse.ohf.ihe.pix.source.PixSourceException;

public class PixSourceResponse
extends PixPdqMessage {
    private static Logger logger;
    private boolean hasERR = false;
    private static final int version = 6;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.pix.source.PixSourceResponse");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public PixSourceResponse(MessageManager globalFactory) throws PixSourceException {
        try {
            this.setDefinitions(globalFactory.getVersionDefinitions());
            this.setVersion(6);
        }
        catch (HL7V2Exception e) {
            throw new PixSourceException(e);
        }
    }

    public void init() {
        SegmentList segList = this.getSegments();
        int i = 0;
        while (i < segList.size()) {
            if (!this.hasERR && segList.item(i).getCode().compareTo("ERR") == 0) {
                this.hasERR = true;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"PixSourceResponse: init - found error segment in pix source response ");
                }
            }
            ++i;
        }
    }

    public String getResponseAckCode(boolean expandString) throws PixSourceException {
        String value = null;
        Segment seg = this.getSegments().getByCodeAndIndex("MSA", 1);
        int fieldIndex = 0;
        try {
            value = expandString ? seg.forceField(fieldIndex).getAsTableDescription() : seg.forceField(fieldIndex).getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PixSourceException(e);
        }
        return value;
    }

    public String getControlId() throws PixSourceException {
        Segment seg = this.getSegments().getByCodeAndIndex("MSA", 1);
        int fieldIndex = 1;
        try {
            return seg.forceField(fieldIndex).getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PixSourceException(e);
        }
    }

    public boolean hasError() {
        return this.hasERR;
    }

    public int getErrorCountBySegment() {
        if (!this.hasERR) {
            return -1;
        }
        return this.getSegments().countByCode("ERR");
    }

    public int getErrorCountByRepeat() {
        if (!this.hasERR) {
            return -1;
        }
        try {
            return this.getSegments().getByCodeAndIndex("ERR", 1).getFields().item(0).getNonEmptyCount();
        }
        catch (HL7V2Exception hL7V2Exception) {
            return -1;
        }
    }

    public String[] getErrorCodeAndLocation(int segmentIndex, int repeatIndex) throws PixSourceException {
        if (!this.hasERR) {
            return null;
        }
        Segment seg = this.getSegments().getByCodeAndIndex("ERR", segmentIndex + 1);
        int fieldIndex = 0;
        try {
            return PixPdqMessageUtilities.getFieldComponentsInRepeat((Segment)seg, (int)fieldIndex, (int)repeatIndex);
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
    }
}

