/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.common.hl7v2.format;

import java.util.ArrayList;
import org.eclipse.ohf.ihe.common.hl7v2.CX;
import org.eclipse.ohf.ihe.common.hl7v2.Hl7v2Factory;
import org.eclipse.ohf.ihe.common.hl7v2.XAD;
import org.eclipse.ohf.ihe.common.hl7v2.XCN;
import org.eclipse.ohf.ihe.common.hl7v2.XON;
import org.eclipse.ohf.ihe.common.hl7v2.XPN;
import org.eclipse.ohf.ihe.common.hl7v2.XTN;
import org.eclipse.ohf.ihe.common.hl7v2.format.Config;
import org.eclipse.ohf.ihe.common.hl7v2.format.HL7V2MessageUtils;

public class HL7V2MessageFormat {
    public static String toMessageString(XON xon, char componentSeparator, char subComponentSeparator) {
        StringBuffer result = new StringBuffer("");
        if (xon == null) {
            return result.toString();
        }
        if (xon.getOrganizationName() != null) {
            result.append(xon.getOrganizationName());
        }
        result.append(componentSeparator);
        result.append(componentSeparator);
        if (xon.getIdNumber() != null) {
            result.append(xon.getIdNumber());
        }
        result.append(componentSeparator);
        result.append(componentSeparator);
        result.append(componentSeparator);
        if (xon.getAssigningAuthorityName() != null) {
            result.append(xon.getAssigningAuthorityName());
        }
        result.append(subComponentSeparator);
        if (xon.getAssigningAuthorityUniversalId() != null) {
            result.append(xon.getAssigningAuthorityUniversalId());
        }
        result.append(subComponentSeparator);
        if (xon.getAssigningAuthorityUniversalIdType() != null) {
            result.append(xon.getAssigningAuthorityUniversalIdType());
        }
        HL7V2MessageUtils.trimDelimiters(result, componentSeparator, subComponentSeparator);
        return result.toString();
    }

    public static XON buildXONFromMessageString(String msg, char componentSeparator, char subComponentSeparator) {
        XON xon = Hl7v2Factory.eINSTANCE.createXON();
        ArrayList comps = HL7V2MessageUtils.parse(msg, componentSeparator);
        if (comps.size() > 0 && comps.get(0) != null) {
            xon.setOrganizationName((String)comps.get(0));
        }
        if (comps.size() > 2 && comps.get(2) != null) {
            xon.setIdNumber((String)comps.get(2));
        }
        if (comps.size() > 5 && comps.get(5) != null) {
            ArrayList subComps = HL7V2MessageUtils.parse((String)comps.get(5), subComponentSeparator);
            if (subComps.size() > 0 && subComps.get(0) != null) {
                xon.setAssigningAuthorityName((String)subComps.get(0));
            }
            if (subComps.size() > 1 && subComps.get(1) != null) {
                xon.setAssigningAuthorityUniversalId((String)subComps.get(1));
            }
            if (subComps.size() > 2 && subComps.get(2) != null) {
                xon.setAssigningAuthorityUniversalIdType((String)subComps.get(2));
            }
        }
        return xon;
    }

    public static String toMessageString(XTN xtn, char componentSeparator) {
        StringBuffer result = new StringBuffer("");
        if (xtn == null) {
            return result.toString();
        }
        if (xtn.getUnformattedTelephoneNumber() == null) {
            return result.toString();
        }
        result.append(componentSeparator);
        result.append(componentSeparator);
        result.append(componentSeparator);
        result.append(componentSeparator);
        result.append(componentSeparator);
        result.append(componentSeparator);
        result.append(componentSeparator);
        result.append(componentSeparator);
        result.append(componentSeparator);
        result.append(componentSeparator);
        result.append(componentSeparator);
        result.append(xtn.getUnformattedTelephoneNumber());
        return result.toString();
    }

    public static XTN buildXTNFromMessageString(String msg, char componentSeparator) {
        XTN xtn = Hl7v2Factory.eINSTANCE.createXTN();
        ArrayList comps = HL7V2MessageUtils.parse(msg, componentSeparator);
        if (comps.size() > 11 && comps.get(11) != null) {
            xtn.setUnformattedTelephoneNumber((String)comps.get(11));
        }
        return xtn;
    }

    public static String toMessageString(CX cx, char componentSeparator, char subComponentSeparator) {
        StringBuffer result = new StringBuffer("");
        if (cx == null) {
            return result.toString();
        }
        if (cx.getIdNumber() != null) {
            result.append(cx.getIdNumber());
        }
        result.append(componentSeparator);
        result.append(componentSeparator);
        result.append(componentSeparator);
        if (Config.instant().isIncludeCxAssigningAuthorityName() && cx.getAssigningAuthorityName() != null) {
            result.append(cx.getAssigningAuthorityName());
        }
        result.append(subComponentSeparator);
        if (cx.getAssigningAuthorityUniversalId() != null) {
            result.append(cx.getAssigningAuthorityUniversalId());
        }
        result.append(subComponentSeparator);
        if (cx.getAssigningAuthorityUniversalIdType() != null) {
            result.append(cx.getAssigningAuthorityUniversalIdType());
        }
        HL7V2MessageUtils.trimDelimiters(result, componentSeparator, subComponentSeparator);
        return result.toString();
    }

    public static CX buildCXFromMessageString(String msg, char componentSeparator, char subComponentSeparator) {
        CX cx = Hl7v2Factory.eINSTANCE.createCX();
        ArrayList comps = HL7V2MessageUtils.parse(msg, componentSeparator);
        if (comps.size() > 0 && comps.get(0) != null) {
            cx.setIdNumber((String)comps.get(0));
        }
        if (comps.size() > 3 && comps.get(3) != null) {
            ArrayList subComps = HL7V2MessageUtils.parse((String)comps.get(3), subComponentSeparator);
            if (subComps.size() > 0 && subComps.get(0) != null) {
                cx.setAssigningAuthorityName((String)subComps.get(0));
            }
            if (subComps.size() > 1 && subComps.get(1) != null) {
                cx.setAssigningAuthorityUniversalId((String)subComps.get(1));
            }
            if (subComps.size() > 2 && subComps.get(2) != null) {
                cx.setAssigningAuthorityUniversalIdType((String)subComps.get(2));
            }
        }
        return cx;
    }

    public static String toMessageString(XCN xcn, char componentSeparator, char subComponentSeparator) {
        StringBuffer result = new StringBuffer("");
        if (xcn == null) {
            return result.toString();
        }
        if (xcn.getIdNumber() != null) {
            result.append(xcn.getIdNumber());
        }
        result.append(componentSeparator);
        if (xcn.getFamilyName() != null) {
            result.append(xcn.getFamilyName());
        }
        result.append(componentSeparator);
        if (xcn.getGivenName() != null) {
            result.append(xcn.getGivenName());
        }
        result.append(componentSeparator);
        if (xcn.getOtherName() != null) {
            result.append(xcn.getOtherName());
        }
        result.append(componentSeparator);
        if (xcn.getSuffix() != null) {
            result.append(xcn.getSuffix());
        }
        result.append(componentSeparator);
        if (xcn.getPrefix() != null) {
            result.append(xcn.getPrefix());
        }
        result.append(componentSeparator);
        result.append(componentSeparator);
        result.append(componentSeparator);
        if (xcn.getAssigningAuthorityName() != null) {
            result.append(xcn.getAssigningAuthorityName());
        }
        result.append(subComponentSeparator);
        if (xcn.getAssigningAuthorityUniversalId() != null) {
            result.append(xcn.getAssigningAuthorityUniversalId());
        }
        result.append(subComponentSeparator);
        if (xcn.getAssigningAuthorityUniversalIdType() != null) {
            result.append(xcn.getAssigningAuthorityUniversalIdType());
        }
        HL7V2MessageUtils.trimDelimiters(result, componentSeparator, subComponentSeparator);
        return result.toString();
    }

    public static XCN buildXCNFromMessageString(String msg, char componentSeparator, char subComponentSeparator) {
        XCN xcn = Hl7v2Factory.eINSTANCE.createXCN();
        ArrayList comps = HL7V2MessageUtils.parse(msg, componentSeparator);
        if (comps.size() > 0 && comps.get(0) != null) {
            xcn.setIdNumber((String)comps.get(0));
        }
        if (comps.size() > 1 && comps.get(1) != null) {
            xcn.setFamilyName((String)comps.get(1));
        }
        if (comps.size() > 2 && comps.get(2) != null) {
            xcn.setGivenName((String)comps.get(2));
        }
        if (comps.size() > 3 && comps.get(3) != null) {
            xcn.setOtherName((String)comps.get(3));
        }
        if (comps.size() > 4 && comps.get(4) != null) {
            xcn.setSuffix((String)comps.get(4));
        }
        if (comps.size() > 5 && comps.get(5) != null) {
            xcn.setPrefix((String)comps.get(5));
        }
        if (comps.size() > 8 && comps.get(8) != null) {
            ArrayList subComps = HL7V2MessageUtils.parse((String)comps.get(8), subComponentSeparator);
            if (subComps.size() > 0 && subComps.get(0) != null) {
                xcn.setAssigningAuthorityName((String)subComps.get(0));
            }
            if (subComps.size() > 1 && subComps.get(1) != null) {
                xcn.setAssigningAuthorityUniversalId((String)subComps.get(1));
            }
            if (subComps.size() > 2 && subComps.get(2) != null) {
                xcn.setAssigningAuthorityUniversalIdType((String)subComps.get(2));
            }
        }
        return xcn;
    }

    public static String toMessageString(XPN xpn, char componentSeparator) {
        StringBuffer result = new StringBuffer("");
        if (xpn == null) {
            return result.toString();
        }
        if (xpn.getFamilyName() != null) {
            result.append(xpn.getFamilyName());
        }
        result.append(componentSeparator);
        if (xpn.getGivenName() != null) {
            result.append(xpn.getGivenName());
        }
        result.append(componentSeparator);
        if (xpn.getOtherName() != null) {
            result.append(xpn.getOtherName());
        }
        result.append(componentSeparator);
        if (xpn.getSuffix() != null) {
            result.append(xpn.getSuffix());
        }
        result.append(componentSeparator);
        if (xpn.getPrefix() != null) {
            result.append(xpn.getPrefix());
        }
        result.append(componentSeparator);
        HL7V2MessageUtils.trimDelimiters(result, componentSeparator);
        return result.toString();
    }

    public static XPN buildXPNFromMessageString(String msg, char componentSeparator) {
        XPN xpn = Hl7v2Factory.eINSTANCE.createXPN();
        ArrayList comps = HL7V2MessageUtils.parse(msg, componentSeparator);
        if (comps.size() > 0 && comps.get(0) != null) {
            xpn.setFamilyName((String)comps.get(0));
        }
        if (comps.size() > 1 && comps.get(1) != null) {
            xpn.setGivenName((String)comps.get(1));
        }
        if (comps.size() > 2 && comps.get(2) != null) {
            xpn.setOtherName((String)comps.get(2));
        }
        if (comps.size() > 3 && comps.get(3) != null) {
            xpn.setSuffix((String)comps.get(3));
        }
        if (comps.size() > 4 && comps.get(4) != null) {
            xpn.setPrefix((String)comps.get(4));
        }
        return xpn;
    }

    public static String toMessageString(XAD xad, char componentSeparator) {
        StringBuffer result = new StringBuffer("");
        if (xad == null) {
            return result.toString();
        }
        if (xad.getStreetAddress() != null) {
            result.append(xad.getStreetAddress());
        }
        result.append(componentSeparator);
        if (xad.getOtherDesignation() != null) {
            result.append(xad.getOtherDesignation());
        }
        result.append(componentSeparator);
        if (xad.getCity() != null) {
            result.append(xad.getCity());
        }
        result.append(componentSeparator);
        if (xad.getStateOrProvince() != null) {
            result.append(xad.getStateOrProvince());
        }
        result.append(componentSeparator);
        if (xad.getZipOrPostalCode() != null) {
            result.append(xad.getZipOrPostalCode());
        }
        result.append(componentSeparator);
        if (xad.getCountry() != null) {
            result.append(xad.getCountry());
        }
        result.append(componentSeparator);
        result.append(componentSeparator);
        result.append(componentSeparator);
        if (xad.getCountyParishCode() != null) {
            result.append(xad.getCountyParishCode());
        }
        result.append(componentSeparator);
        HL7V2MessageUtils.trimDelimiters(result, componentSeparator);
        return result.toString();
    }

    public static XAD buildXADFromMessageString(String msg, char componentSeparator) {
        XAD xad = Hl7v2Factory.eINSTANCE.createXAD();
        ArrayList comps = HL7V2MessageUtils.parse(msg, componentSeparator);
        if (comps.size() > 0 && comps.get(0) != null) {
            xad.setStreetAddress((String)comps.get(0));
        }
        if (comps.size() > 1 && comps.get(1) != null) {
            xad.setOtherDesignation((String)comps.get(1));
        }
        if (comps.size() > 2 && comps.get(2) != null) {
            xad.setCity((String)comps.get(2));
        }
        if (comps.size() > 3 && comps.get(3) != null) {
            xad.setStateOrProvince((String)comps.get(3));
        }
        if (comps.size() > 4 && comps.get(4) != null) {
            xad.setZipOrPostalCode((String)comps.get(4));
        }
        if (comps.size() > 5 && comps.get(5) != null) {
            xad.setCountry((String)comps.get(5));
        }
        if (comps.size() > 8 && comps.get(8) != null) {
            xad.setCountyParishCode((String)comps.get(8));
        }
        return xad;
    }
}

