/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.formats;

import org.apache.commons.lang.StringUtils;
import org.eclipse.ohf.hl7v2.core.conformance.formats.CPDescribedXML;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPItem;
import org.eclipse.ohf.utilities.xml.XMLObjectParser;
import org.eclipse.ohf.utilities.xml.XMLStringParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CPItemXML
extends CPDescribedXML {
    public CPItemXML(CPItem item) {
        super(item);
    }

    private CPItem item() {
        return (CPItem)this.element;
    }

    public void start(String namespace, String name, String defaultNamespace, Attributes attributes) throws SAXException {
        this.item().setUsage(this.readUsage(attributes.getValue("Usage")));
        super.start(namespace, name, defaultNamespace, attributes);
    }

    public XMLObjectParser startElement(String namespace, String name, String defaultNamespace, Attributes attributes) throws SAXException {
        if (name.equals("Predicate")) {
            return new XMLStringParser();
        }
        return super.startElement(namespace, name, defaultNamespace, attributes);
    }

    public void endChild(XMLObjectParser child) throws SAXException {
        if (child.getName().equals("Predicate")) {
            this.item().setPredicate(((XMLStringParser)child).getContent());
        } else {
            super.endChild(child);
        }
    }

    protected int readMax(String value) throws SAXException {
        if (value == null || value.equals("")) {
            return 1;
        }
        if (value.equals("*")) {
            return -1;
        }
        if (StringUtils.isNumeric((String)value)) {
            return Integer.parseInt(value);
        }
        throw new SAXException("illegal value \"" + value + "\" for Max at " + this.getPath());
    }

    protected int readMin(String value) throws SAXException {
        if (value == null || value.equals("")) {
            return 1;
        }
        if (StringUtils.isNumeric((String)value)) {
            return Integer.parseInt(value);
        }
        throw new SAXException("illegal value \"" + value + "\" for Min at " + this.getPath());
    }
}

