/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.model;

import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.hl7v2.core.utilities.Worker;

public abstract class CPElement
extends Worker
implements Cloneable {
    public static final int ET_LIST = 1;
    public static final int ET_DOCUMENT = 2;
    public static final int ET_PROFILE = 3;
    public static final int ET_USECASE = 4;
    public static final int ET_USECASEELEM = 5;
    public static final int ET_METADATA = 6;
    public static final int ET_INTERACTION = 7;
    public static final int ET_DYNDEF = 8;
    public static final int ET_STATICDEFN = 9;
    public static final int ET_GROUP = 10;
    public static final int ET_SEGMENT = 11;
    public static final int ET_FIELD = 12;
    public static final int ET_COMPONENT = 13;
    public static final int ET_TABLE = 14;
    public static final int ET_TABLEITEM = 15;
    public static final int PROPERTY_NAME = 1;
    public static final int PROPERTY_TYPE = 2;
    public static final int PROPERTY_VALUE = 3;
    public static final int PROPERTY_PURPOSE = 4;
    public static final int PROPERTY_DESCRIPTION = 5;
    public static final int PROPERTY_DISPLAYNAME = 6;
    public static final int PROPERTY_KEY = 7;
    public static final int PROPERTY_CODE = 8;
    public static final int PROPERTY_ORDER = 9;
    public static final int PROPERTY_USAGE = 10;
    public static final int PROPERTY_ID = 11;
    public static final int PROPERTY_TABLETYPE = 12;
    public static final int PROPERTY_CODESYSTEM = 13;
    public static final int PROPERTY_ROLE = 14;
    public static final int PROPERTY_ORGNAME = 15;
    public static final int PROPERTY_VERSION = 16;
    public static final int PROPERTY_STATUS = 17;
    public static final int PROPERTY_TOPICS = 18;
    public static final int PROPERTY_MSGTYPE = 19;
    public static final int PROPERTY_EVENTTYPE = 20;
    public static final int PROPERTY_MSGSTRUCTID = 21;
    public static final int PROPERTY_ORDERCONTROL = 22;
    public static final int PROPERTY_EVENTDESC = 23;
    public static final int PROPERTY_LONGNAME = 24;
    public static final int PROPERTY_MIN = 25;
    public static final int PROPERTY_MAX = 26;
    public static final int PROPERTY_IMPLTYPE = 27;
    public static final int PROPERTY_HL7VERSION = 28;
    public static final int PROPERTY_DERIVATION = 29;
    public static final int PROPERTY_PREDICATE = 30;
    public static final int PROPERTY_ITEMNO = 31;
    public static final int PROPERTY_ACC_ACK = 32;
    public static final int PROPERTY_APP_ACK = 33;
    public static final int PROPERTY_ACKMODE = 34;
    public static final int PROPERTY_QRY_TYPE = 35;
    public static final int PROPERTY_QRY_MODE = 36;
    public static final int PROPERTY_IMPL_NOTE = 37;
    public static final int PROPERTY_REFERENCE = 38;
    public static final int PROPERTY_LENGTH = 39;
    public static final int PROPERTY_VALUES = 40;
    public static final int PROPERTY_DATATYPE = 41;
    public static final int PROPERTY_TABLE = 42;
    public static final int PROPERTY_FIXED_VALUE = 43;
    public static final int PROPERTY_PROFILETYPE = 44;
    public static final int PROPERTY_ENCODINGS = 45;
    public static final int PROPERTY_CARDINALITY = 46;
    public static final int PROPERTY_METAVERSION = 47;
    public static final int PROPERTY_CONTEXT = 48;
    private CPElement owner;

    public static String getPropertyName(int id) {
        switch (id) {
            case 1: {
                return "Name";
            }
            case 2: {
                return "Type";
            }
            case 3: {
                return "Value";
            }
            case 4: {
                return "Prupose";
            }
            case 5: {
                return "Description";
            }
            case 6: {
                return "DisplayName";
            }
            case 7: {
                return "Key";
            }
            case 8: {
                return "Code";
            }
            case 9: {
                return "Order";
            }
            case 10: {
                return "Usage";
            }
            case 11: {
                return "Id";
            }
            case 12: {
                return "TableType";
            }
            case 13: {
                return "CodeSystem";
            }
            case 14: {
                return "Role";
            }
            case 15: {
                return "Organisation Name";
            }
            case 16: {
                return "Version";
            }
            case 17: {
                return "Status";
            }
            case 18: {
                return "Topics";
            }
            case 19: {
                return "Message Type";
            }
            case 20: {
                return "Event Type";
            }
            case 21: {
                return "Messge Structure";
            }
            case 22: {
                return "Order Control";
            }
            case 23: {
                return "Event Description";
            }
            case 24: {
                return "Long Name";
            }
            case 25: {
                return "Min";
            }
            case 26: {
                return "Max";
            }
            case 27: {
                return "Implementation Type";
            }
            case 28: {
                return "HL7 Version";
            }
            case 29: {
                return "Derivation";
            }
            case 30: {
                return "Predicate";
            }
            case 31: {
                return "Item#";
            }
            case 32: {
                return "Accept Acknowledgement";
            }
            case 33: {
                return "Application Acknowledgement";
            }
            case 34: {
                return "Acknowledgement Mode";
            }
            case 35: {
                return "Query Type";
            }
            case 36: {
                return "Query Mode";
            }
            case 37: {
                return "Implementation Notes";
            }
            case 38: {
                return "Reference";
            }
            case 39: {
                return "Length";
            }
            case 40: {
                return "Values";
            }
            case 41: {
                return "DataType";
            }
            case 42: {
                return "Table";
            }
            case 43: {
                return "Fixed Value";
            }
            case 44: {
                return "Profile Type";
            }
            case 45: {
                return "Encodings";
            }
            case 46: {
                return "Cardinality";
            }
        }
        return "Unknown";
    }

    public CPElement(CPElement owner) {
        this.clear();
        this.owner = owner;
    }

    public void clear() {
    }

    public CPElement getOwner() {
        return this.owner;
    }

    public void setOwner(CPElement owner) {
        this.owner = owner;
    }

    public String getPath() {
        return "";
    }

    public int[] getPropertyIds() {
        return new int[0];
    }

    public String getProperty(int id) throws HL7V2Exception {
        throw new HL7V2Exception("The Property " + CPElement.getPropertyName(id) + " is not a property of the class " + this.getClass().getName(), 19);
    }

    public void setProperty(int id, String value) throws HL7V2Exception {
        throw new HL7V2Exception("The Property " + CPElement.getPropertyName(id) + " is not a property of the class " + this.getClass().getName(), 19);
    }

    public String getHumanType() {
        return "Element";
    }

    public void defaults() {
    }

    public abstract int elementType();

    public void assign(CPElement source) throws CloneNotSupportedException {
        this.owner = null;
    }

    protected Object clone() throws CloneNotSupportedException {
        CPElement elem = (CPElement)super.clone();
        elem.assign(this);
        elem.owner = null;
        return elem;
    }

    public CPElement cloneElement() throws CloneNotSupportedException {
        return (CPElement)this.clone();
    }

    protected int[] mergeIds(int[] list1, int[] list2) {
        int[] result = new int[list1.length + list2.length];
        int i = 0;
        while (i < result.length) {
            result[i] = i < list1.length ? list1[i] : list2[i - list1.length];
            ++i;
        }
        return null;
    }

    public boolean hasProperty(int id) {
        int[] props = this.getPropertyIds();
        int i = 0;
        while (i < props.length) {
            if (props[i] == id) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String typeToString(int type) throws HL7V2Exception {
        switch (type) {
            case 1: {
                return "LIST";
            }
            case 2: {
                return "DOCUMENT";
            }
            case 3: {
                return "PROFILE";
            }
            case 4: {
                return "USECASE";
            }
            case 5: {
                return "USECASEELEM";
            }
            case 6: {
                return "METADATA";
            }
            case 7: {
                return "INTERACTION";
            }
            case 8: {
                return "DYNDEF";
            }
            case 9: {
                return "STATICDEFN";
            }
            case 10: {
                return "GROUP";
            }
            case 11: {
                return "SEGMENT";
            }
            case 12: {
                return "FIELD";
            }
            case 13: {
                return "COMPONENT";
            }
            case 14: {
                return "TABLE";
            }
            case 15: {
                return "TABLEITEM";
            }
        }
        throw new HL7V2Exception("invalid value " + Integer.toString(type) + " for element type", 25);
    }
}

