/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.model;

import java.util.Vector;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPElement;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPElementIterator;

public class CPElements
extends CPElement {
    private Vector items = new Vector();

    public CPElements(CPElement owner) {
        super(owner);
    }

    public int size() {
        return this.items.size();
    }

    public CPElement itemElement(int index) {
        return (CPElement)this.items.get(index);
    }

    public void add(CPElement element) {
        this.items.add(element);
    }

    public void insert(CPElement element, int index) {
        this.items.insertElementAt(element, index);
    }

    public void clear() {
        if (this.items != null) {
            this.items.clear();
        }
    }

    protected CPElement makeElement() {
        throw new Error("need to override makeElement");
    }

    public CPElement addElement() {
        CPElement element = this.makeElement();
        this.add(element);
        return element;
    }

    public CPElementIterator iteratorElement() {
        return this.makeIterator();
    }

    protected CPElementIterator makeIterator() {
        return new CPElementIterator(this);
    }

    public int indexOf(CPElement element) {
        return this.items.indexOf(element);
    }

    public void remove(int index) {
        this.items.remove(index);
    }

    public CPElement[] asArray() {
        CPElement[] result = new CPElement[this.size()];
        int i = 0;
        while (i < this.size()) {
            result[i] = this.itemElement(i);
            ++i;
        }
        return result;
    }

    public int elementType() {
        return 1;
    }

    public void assign(CPElement source) throws CloneNotSupportedException {
        super.assign(source);
        CPElements src = (CPElements)source;
        this.items = new Vector();
        int i = 0;
        while (i < src.items.size()) {
            CPElement item = src.itemElement(i).cloneElement();
            item.setOwner(this);
            this.add(item);
            ++i;
        }
    }

    public CPElements cloneElements() throws CloneNotSupportedException {
        return (CPElements)this.clone();
    }

    public void exchange(int index1, int index2) {
        CPElement temp = (CPElement)this.items.get(index1);
        this.items.set(index1, this.items.get(index2));
        this.items.set(index2, temp);
    }
}

