/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.model;

import org.eclipse.ohf.hl7v2.core.conformance.model.CPElement;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class CPMetaData
extends CPElement {
    private String name;
    private String context;
    private String orgName;
    private String version;
    private String metaVersion;
    private String status;
    private String topics;

    public CPMetaData(CPElement owner) {
        super(owner);
    }

    public void clear() {
        super.clear();
        this.name = null;
        this.orgName = null;
        this.version = null;
        this.metaVersion = null;
        this.status = null;
        this.topics = null;
        this.context = null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getTopics() {
        return this.topics;
    }

    public void setTopics(String topics) {
        this.topics = topics;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getMetaVersion() {
        return this.metaVersion;
    }

    public void setMetaVersion(String metaVersion) {
        this.metaVersion = metaVersion;
    }

    public String getDescriptiveName() {
        return this.orgName + this.name + this.version + "(" + this.status + ")";
    }

    public int[] getPropertyIds() {
        return this.mergeIds(super.getPropertyIds(), new int[]{1, 15, 16, 47, 17, 18, 48});
    }

    public String getProperty(int id) throws HL7V2Exception {
        switch (id) {
            case 1: {
                return this.getName();
            }
            case 48: {
                return this.getContext();
            }
            case 15: {
                return this.getOrgName();
            }
            case 16: {
                return this.getVersion();
            }
            case 47: {
                return this.getMetaVersion();
            }
            case 17: {
                return this.getStatus();
            }
            case 18: {
                return this.getTopics();
            }
        }
        return super.getProperty(id);
    }

    public void setProperty(int id, String value) throws HL7V2Exception {
        switch (id) {
            case 1: {
                this.setName(value);
                break;
            }
            case 48: {
                this.setContext(value);
                break;
            }
            case 15: {
                this.setOrgName(value);
                break;
            }
            case 16: {
                this.setVersion(value);
                break;
            }
            case 47: {
                this.setMetaVersion(value);
                break;
            }
            case 17: {
                this.setStatus(value);
                break;
            }
            case 18: {
                this.setTopics(value);
                break;
            }
            default: {
                super.setProperty(id, value);
            }
        }
    }

    public void defaults() {
        super.defaults();
        this.name = null;
        this.orgName = null;
        this.version = null;
        this.metaVersion = null;
        this.status = null;
        this.topics = null;
        this.context = null;
    }

    public int elementType() {
        return 6;
    }

    public void assign(CPElement source) throws CloneNotSupportedException {
        super.assign(source);
        CPMetaData src = (CPMetaData)source;
        this.name = src.name;
        this.context = src.context;
        this.orgName = src.orgName;
        this.version = src.version;
        this.metaVersion = src.metaVersion;
        this.status = src.status;
        this.topics = src.topics;
    }

    public CPMetaData cloneMetaData() throws CloneNotSupportedException {
        return (CPMetaData)this.clone();
    }
}

