/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message;

import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefnList;
import org.eclipse.ohf.hl7v2.core.message.formats.Formats;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.hl7v2.core.utilities.Worker;

public class ComposingOptions
extends Worker {
    public static final int csAscii = 0;
    public static final int csUTF8 = 1;
    public static final int csUTF16BE = 2;
    public static final int csUTF16LE = 3;
    private boolean extraFieldDelimiter;
    private boolean escapeExtendedCharacters;
    private boolean allowMappingToFail;
    private boolean optimisticMapping;
    private boolean addStructureName;
    private int format;
    private int charset;

    public ComposingOptions() {
        this.reset();
    }

    public void reset() {
        this.extraFieldDelimiter = false;
        this.escapeExtendedCharacters = true;
        this.allowMappingToFail = false;
        this.optimisticMapping = false;
        this.addStructureName = true;
        this.format = 1;
        this.charset = 0;
    }

    public boolean isAllowMappingToFail() {
        return this.allowMappingToFail;
    }

    public void setAllowMappingToFail(boolean allowMappingToFail) {
        this.allowMappingToFail = allowMappingToFail;
    }

    public boolean isEscapeExtendedCharacters() {
        return this.escapeExtendedCharacters;
    }

    public void setEscapeExtendedCharacters(boolean escapeExtendedCharacters) {
        this.escapeExtendedCharacters = escapeExtendedCharacters;
    }

    public boolean isExtraFieldDelimiter() {
        return this.extraFieldDelimiter;
    }

    public void setExtraFieldDelimiter(boolean extraFieldDelimiter) {
        this.extraFieldDelimiter = extraFieldDelimiter;
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int format) throws HL7V2Exception {
        if (!Formats.isValid(format)) {
            throw new HL7V2Exception("Format value is not valid", 19);
        }
        this.format = format;
    }

    public boolean isAddStructureName() {
        return this.addStructureName;
    }

    public void setAddStructureName(boolean addStructureName) {
        this.addStructureName = addStructureName;
    }

    public boolean isOptimisticMapping() {
        return this.optimisticMapping;
    }

    public void setOptimisticMapping(boolean optimisticMapping) {
        this.optimisticMapping = optimisticMapping;
    }

    public int getCharset() {
        return this.charset;
    }

    public void setCharset(int charset) throws HL7V2Exception {
        this.condition(this.isValidCharset(charset), "Invalid encoding charset " + Integer.toString(charset), 19);
        this.charset = charset;
    }

    public boolean isValidCharset(int charset) {
        return charset >= 0 && charset <= 3;
    }

    public String getCharsetName() throws HL7V2Exception {
        return this.getCharsetName(this.charset);
    }

    public String getCharsetName(int charset) throws HL7V2Exception {
        switch (this.getCharset()) {
            case 0: {
                return "US-ASCII";
            }
            case 1: {
                return "UTF-8";
            }
            case 2: {
                return "UTF-16BE";
            }
            case 3: {
                return "UTF-16LE";
            }
        }
        throw new HL7V2Exception("Illegal encoding method", 19);
    }

    public String getCharsetHL7Code(int version) throws HL7V2Exception {
        if (this.charset == 0) {
            return "";
        }
        if (version == 7) {
            return "UNICODE";
        }
        if (version >= 8) {
            switch (this.getCharset()) {
                case 1: {
                    return "UNICODE UTF-8";
                }
                case 2: {
                    return "UNICODE UTF-16";
                }
                case 3: {
                    return "UNICODE UTF-16";
                }
            }
        }
        throw new HL7V2Exception("Illegal encoding method " + this.getCharsetName(this.charset) + " for HL7 version " + VersionDefnList.display(version), 19);
    }

    public String getXMLCharset() throws HL7V2Exception {
        switch (this.getCharset()) {
            case 0: {
                return "UTF-8";
            }
            case 1: {
                return "UTF-8";
            }
            case 2: {
                return "UTF-16";
            }
            case 3: {
                return "UTF-16";
            }
        }
        throw new HL7V2Exception("Illegal encoding method", 19);
    }
}

