/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.formats;

import java.io.IOException;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefnList;
import org.eclipse.ohf.hl7v2.core.message.formats.Composer;
import org.eclipse.ohf.hl7v2.core.message.model.Cell;
import org.eclipse.ohf.hl7v2.core.message.model.Component;
import org.eclipse.ohf.hl7v2.core.message.model.Content;
import org.eclipse.ohf.hl7v2.core.message.model.ContentBinary;
import org.eclipse.ohf.hl7v2.core.message.model.Field;
import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.hl7v2.core.message.model.Segment;
import org.eclipse.ohf.hl7v2.core.message.model.SegmentGroup;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.utilities.OHFException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DOMComposer
extends Composer {
    private static final String V2_XML_NS = "urn:hl7-org:v2xml";
    private static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    private Document document;
    private Element[] composed;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.hl7v2.core.message.formats.DOMComposer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DOMComposer(Document document) {
        this.document = document;
    }

    public void compose(Message message) throws HL7V2Exception {
        try {
            this.condition(message.getVersion() >= 6, "Unable to encode messages with VersionDefn " + VersionDefnList.display(message.getVersion()) + " in XML", 22);
            this.condition(message.getStructId() != "", "Cannot encode an XML message with no assigned structure (" + VersionDefnList.display(message.getVersion()) + "/" + message.getEvent() + "/" + message.getMessageType() + ")", 22);
            message.getSegments().buildSegmentMap(this.getOptions());
            this.condition(message.getSegments().getMap() != null, "Cannot encode an XML message with no segment map (" + VersionDefnList.display(message.getVersion()) + "/" + message.getEvent() + "/" + message.getMessageType() + ")", 22);
            message.resolveVariableTypes();
            Element element = this.setComposed(message.getStructId());
            element.setAttribute("xmlns", V2_XML_NS);
            element.setAttribute("xmlns:xsi", XSI_NS);
            element.setAttribute("xsi:schemaLocation", "urn:hl7-org:v2xml " + message.getStructId() + ".xsd");
            this.encodeSegmentGroup(this.composed[0], message.getSegments().getMap());
        }
        catch (OHFException e1) {
            throw new HL7V2Exception(e1, 22);
        }
        catch (Exception e) {
            throw new HL7V2Exception(e, 19);
        }
    }

    private Element setComposed(String name) {
        this.composed = new Element[]{this.document.createElement(name)};
        return this.composed[0];
    }

    private Element addComposed(String name) {
        Element result = this.document.createElement(name);
        Element[] temp = new Element[this.composed == null ? 1 : this.composed.length + 1];
        if (this.composed != null) {
            int i = 0;
            while (i < this.composed.length) {
                temp[i] = this.composed[i];
                ++i;
            }
        }
        this.composed = temp;
        return result;
    }

    public void compose(SegmentGroup segGroup) throws HL7V2Exception {
        try {
            this.encodeSegmentGroup(this.setComposed(segGroup.getName()), segGroup);
        }
        catch (Exception e1) {
            throw new HL7V2Exception(e1, 22);
        }
    }

    private void encodeSegmentGroup(Element parent, SegmentGroup segmentGroup) throws OHFException, IOException {
        int i = 0;
        while (i < segmentGroup.getChildren().size()) {
            SegmentGroup child = segmentGroup.getChildren().item(i);
            if (child.isGroup()) {
                String name = child.getName();
                if (name.equals("")) {
                    name = "what_is_this_group_called";
                }
                Element element = this.document.createElement(name);
                this.encodeSegmentGroup(element, child);
                parent.appendChild(element);
            } else {
                int j = 0;
                while (j < child.getSegments().size()) {
                    this.composeSegment(parent, child.getSegments().item(j));
                    ++j;
                }
            }
            ++i;
        }
    }

    private void composeSegment(Element parent, Segment segment) throws HL7V2Exception {
        try {
            Element element = this.document.createElement(segment.getCode());
            parent.appendChild(element);
            this.encodeSegmentContent(element, segment);
        }
        catch (Exception e1) {
            throw new HL7V2Exception(e1, 22);
        }
    }

    public void compose(Segment segment) throws HL7V2Exception {
        try {
            this.encodeSegmentContent(this.setComposed(segment.getCode()), segment);
        }
        catch (Exception e1) {
            throw new HL7V2Exception(e1, 22);
        }
    }

    private void encodeSegmentContent(Element parent, Segment segment) throws OHFException {
        int i = 0;
        while (i < segment.getFields().size()) {
            this.encode(parent, segment.getFields().item(i), String.valueOf(segment.getCode()) + "." + Integer.toString(i + 1));
            ++i;
        }
    }

    private void encode(Element parent, Field field, String name) throws HL7V2Exception {
        try {
            Element element = this.document.createElement(name);
            parent.appendChild(element);
            this.encodeCell(element, field);
            if (field.hasRepeats()) {
                int i = 0;
                while (i < field.getRepeats().size()) {
                    element = this.document.createElement(name);
                    parent.appendChild(element);
                    this.encodeCell(element, field.getRepeats().item(i));
                    ++i;
                }
            }
        }
        catch (Exception e1) {
            throw new HL7V2Exception(e1, 22);
        }
    }

    public void encode(Field field, String name) throws HL7V2Exception {
        try {
            this.encodeCell(this.setComposed(name), field);
            if (field.hasRepeats()) {
                int i = 0;
                while (i < field.getRepeats().size()) {
                    this.encodeCell(this.addComposed(name), field.getRepeats().item(i));
                    ++i;
                }
            }
        }
        catch (Exception e1) {
            throw new HL7V2Exception(e1, 22);
        }
    }

    private void writeCell(Element parent, String value) throws OHFException, IOException {
        if (value != null && !value.equals("")) {
            parent.appendChild(this.document.createTextNode(value));
        }
    }

    private void encodeCell(Element parent, Cell cell) throws OHFException, IOException {
        if (cell.hasContent()) {
            if (cell.hasComponents()) {
                String type = "UNK";
                if (cell.getCellType() == 4) {
                    Field field = (Field)cell;
                    if (field.hasSpecifiedDataType()) {
                        type = field.getSpecifiedDataType();
                    } else if (field.getStructure() != null) {
                        type = field.getStructure().getDataTypeCode();
                    }
                } else {
                    Component comp = (Component)cell;
                    if (comp.getDefinition() != null) {
                        type = comp.getDefinition().getDataTypeCode();
                    }
                }
                int i = 0;
                while (i < cell.getComponents().size()) {
                    Element element = this.document.createElement(String.valueOf(type) + "." + Integer.toString(i + 1));
                    this.encodeCell(element, cell.getComponents().itemCell(i));
                    ++i;
                }
            } else if (cell.getNullify()) {
                this.writeCell(parent, "\"\"");
            } else if (cell.isSimple()) {
                this.writeCell(parent, cell.getRawContent());
            } else {
                this.buildComplexContent(parent, cell);
            }
        }
    }

    private void buildComplexContent(Element parent, Cell cell) throws OHFException, IOException {
        int i = 0;
        while (i < cell.getContents().size()) {
            Content content = cell.getContents().itemContent(i);
            if (content.getContentType() == 1) {
                throw new HL7V2Exception("cannot find a null here", 18);
            }
            if (content.getContentType() == 0) {
                parent.appendChild(this.document.createTextNode(content.getText()));
            } else if (content.getContentType() == 2) {
                Element child = this.document.createElement("escape");
                child.setAttribute("V", content.getText());
                parent.appendChild(child);
            } else if (content.getContentType() == 3) {
                parent.appendChild(this.document.createTextNode(((ContentBinary)content).getXmlText()));
            } else {
                throw new HL7V2Exception("unknown content type " + Integer.toString(content.getContentType()), 18);
            }
            ++i;
        }
    }

    public void compose(Field field) throws HL7V2Exception {
        this.encode(field, String.valueOf(field.getSegment().getCode()) + "." + field.getIndex());
    }

    public void compose(Component component) throws HL7V2Exception {
        try {
            if (component.getComponent() != null && component.getComponent().getDataType() != null) {
                this.encodeCell(this.setComposed(String.valueOf(component.getComponent().getDataType().getName()) + "." + component.getIndex()), component);
            } else if (component.getField() != null && component.getField().getDataType() != null) {
                this.encodeCell(this.setComposed(String.valueOf(component.getField().getDataType().getName()) + "." + component.getIndex()), component);
            } else {
                this.encodeCell(this.setComposed("UNK.0"), component);
            }
        }
        catch (Exception e1) {
            throw new HL7V2Exception(e1, 22);
        }
    }

    public Element getComposed() {
        if (!($assertionsDisabled || this.composed != null && this.composed.length == 1)) {
            throw new AssertionError();
        }
        return this.composed[0];
    }

    public Element[] getComposedList() {
        return this.composed;
    }
}

