/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.formats;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.ohf.hl7v2.core.message.formats.StreamComposer;
import org.eclipse.ohf.hl7v2.core.message.model.Cell;
import org.eclipse.ohf.hl7v2.core.message.model.Component;
import org.eclipse.ohf.hl7v2.core.message.model.Content;
import org.eclipse.ohf.hl7v2.core.message.model.ContentBinary;
import org.eclipse.ohf.hl7v2.core.message.model.Delimiters;
import org.eclipse.ohf.hl7v2.core.message.model.Field;
import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.hl7v2.core.message.model.Segment;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class VerticalBarComposer
extends StreamComposer {
    private Delimiters delimiters = new Delimiters();

    public VerticalBarComposer() {
        this.init();
    }

    public VerticalBarComposer(OutputStream stream) throws HL7V2Exception {
        super(stream);
        this.init();
    }

    private void init() {
        this.getOptions().setEscapeExtendedCharacters(true);
    }

    public void compose(Message message) throws HL7V2Exception {
        this.delimiters = message.getDelimiters();
        this.delimiters.check();
        Cell msh18 = message.getElement("MSH-18");
        msh18.clearContent();
        msh18.setAsString(this.getOptions().getCharsetHL7Code(message.getVersion()));
        int i = 0;
        while (i < message.getSegments().size()) {
            this.compose(message.getSegments().item(i));
            ++i;
        }
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new HL7V2Exception(e, 19);
        }
    }

    public void compose(Segment segment) throws HL7V2Exception {
        this.write(segment.getCode());
        int start = 0;
        if (segment.getCode().equals("MSH") || segment.getCode().equals("FHS") || segment.getCode().equals("BHS")) {
            this.write(this.delimiters.getFieldDelimiter());
            this.write(this.delimiters.getComponentDelimiter());
            this.write(this.delimiters.getRepetitionDelimiter());
            this.write(this.delimiters.getEscapeCharacter());
            this.write(this.delimiters.getSubComponentDelimiter());
            start = 2;
        }
        String hold = "";
        int i = start;
        while (i < segment.getFields().size()) {
            if (segment.getCode().equals("OBR") && i == 24) {
                start = 3;
            }
            Field field = segment.getFields().item(i);
            hold = String.valueOf(hold) + this.delimiters.getFieldDelimiter() + this.formatDataElement(field);
            if (field.hasContent() || i == 0) {
                this.write(hold);
                hold = "";
            }
            ++i;
        }
        if (this.getOptions().isExtraFieldDelimiter()) {
            this.write(this.delimiters.getFieldDelimiter());
        }
        this.write("\r");
    }

    private String formatDataElement(Field field) throws HL7V2Exception {
        String value = this.formatCell(field);
        if (field.hasRepeats()) {
            int i = 0;
            while (i < field.getRepeats().size()) {
                value = String.valueOf(value) + this.delimiters.getRepetitionDelimiter() + this.formatCell(field.getRepeats().item(i));
                ++i;
            }
        }
        return value;
    }

    private String formatCell(Cell cell) throws HL7V2Exception {
        char ch = ' ';
        if (cell.getCellType() == 4) {
            ch = this.delimiters.getComponentDelimiter();
        } else if (cell.getCellType() == 5) {
            ch = this.delimiters.getSubComponentDelimiter();
        } else if (cell.getCellType() != 6) {
            throw new HL7V2Exception("CPCell Type is not valid", 19);
        }
        if (cell.hasContent()) {
            if (cell.hasComponents() && !cell.hasOnlyFirstComponent()) {
                this.condition(ch != ' ', "Attempt to encode sub-sub-components at " + cell.elementName(), 19);
                String result = this.formatCell(cell.getComponents().itemCell(0));
                String hold = "";
                int i = 1;
                while (i < cell.getComponents().size()) {
                    Cell child = cell.getComponents().itemCell(i);
                    hold = String.valueOf(hold) + ch + this.formatCell(child);
                    if (child.hasContent()) {
                        result = String.valueOf(result) + hold;
                        hold = "";
                    }
                    ++i;
                }
                return result;
            }
            if (cell.getNullify()) {
                return "\"\"";
            }
            if (cell.isSimple()) {
                return this.escape(cell.getRawContent());
            }
            return this.buildComplexContent(cell);
        }
        return "";
    }

    private String buildComplexContent(Cell cell) throws HL7V2Exception {
        String value = "";
        int i = 0;
        while (i < cell.getContents().size()) {
            Content content = cell.getContents().itemContent(i);
            if (content.getContentType() == 1) {
                throw new HL7V2Exception("cannot find a null here", 18);
            }
            if (content.getContentType() == 0) {
                value = String.valueOf(value) + this.escape(content.getText());
            } else if (content.getContentType() == 2) {
                value = String.valueOf(value) + this.delimiters.getEscapeCharacter() + content.getText() + this.delimiters.getEscapeCharacter();
            } else if (content.getContentType() == 3) {
                value = String.valueOf(value) + this.delimiters.getEscapeCharacter() + "X" + ((ContentBinary)content).getHexText() + this.delimiters.getEscapeCharacter();
            } else {
                throw new HL7V2Exception("unknown content type", 18);
            }
            ++i;
        }
        return value;
    }

    private String escape(String content) throws HL7V2Exception {
        if (content == null || content.equals("")) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < content.length()) {
            char ch = content.charAt(i);
            if (this.delimiters.isDelimiter(ch)) {
                sb.append(this.delimiters.getEscape(ch));
            } else if (this.hexEscape(ch)) {
                sb.append(this.getHexEscape(ch));
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    private Object getHexEscape(char ch) {
        return String.valueOf(this.delimiters.getEscapeCharacter()) + "X" + Integer.toHexString(new Character(ch).hashCode()).toUpperCase() + this.delimiters.getEscapeCharacter();
    }

    private boolean hexEscape(char ch) throws HL7V2Exception {
        return ch == '\r' || ch == '\n' || ch == '\t' || ch > '\u007f' && this.getOptions().isEscapeExtendedCharacters();
    }

    public void compose(Field field) throws HL7V2Exception {
        this.write(this.formatDataElement(field));
    }

    public void compose(Component component) throws HL7V2Exception {
        this.write(this.formatCell(component));
    }

    protected void write(String s) throws HL7V2Exception {
        if (s != null) {
            try {
                this.writer.write(s);
            }
            catch (IOException e) {
                throw new HL7V2Exception(e, 19);
            }
        }
    }

    protected void write(char c) throws HL7V2Exception {
        try {
            this.writer.write(c);
        }
        catch (IOException e) {
            throw new HL7V2Exception(e, 19);
        }
    }
}

