/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.eclipse.ohf.hl7v2.core.message.model.Item;
import org.eclipse.ohf.hl7v2.core.message.model.Segment;
import org.eclipse.ohf.hl7v2.core.message.model.SegmentGroupList;
import org.eclipse.ohf.hl7v2.core.message.model.SegmentList;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class SegmentGroup
extends Item {
    private boolean group;
    private String name;
    private SegmentList segments;
    private SegmentGroupList children;

    public SegmentGroup(boolean group, String name) {
        this.setGroup(group);
        this.setName(name);
    }

    public boolean matches(Item obj, boolean path) throws HL7V2Exception {
        boolean result;
        boolean bl = result = super.matches(obj, path) && obj instanceof SegmentGroup;
        if (result) {
            SegmentGroup other = (SegmentGroup)obj;
            other.group = this.group && this.equals(other.name, this.name);
            result = other.group;
            result = other.group ? result && other.children.matches(this.children, path) : result && other.segments.matches(this.segments, path);
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            name = "";
        }
        this.name = name;
    }

    public void clear() {
        this.group = false;
        this.name = "";
        this.segments = null;
        this.children = null;
    }

    public boolean hasChildren() {
        return this.children != null;
    }

    public SegmentGroupList getChildren() {
        if (this.children == null && this.group) {
            this.children = new SegmentGroupList(this);
        }
        return this.children;
    }

    public SegmentList getSegments() {
        return this.segments;
    }

    public void addSegment(Segment segment) throws HL7V2Exception {
        SegmentGroup child = null;
        if (this.getChildren().size() > 0 && this.children.item(this.children.size() - 1).getName() == "") {
            child = this.children.item(this.children.size() - 1);
        } else {
            child = new SegmentGroup(false, "");
            this.children.add(child);
        }
        child.getSegments().add(segment);
    }

    public void addGroup(SegmentGroup segGroup) throws HL7V2Exception {
        this.getChildren().add(segGroup);
    }

    public boolean isGroup() {
        return this.group;
    }

    public void setGroup(boolean group) {
        this.clear();
        this.group = group;
        if (group) {
            this.children = new SegmentGroupList(this);
        } else {
            this.segments = new SegmentList(null, false);
        }
    }

    public void clearContent() throws HL7V2Exception {
        this.clear();
    }

    public String elementName() throws HL7V2Exception {
        return null;
    }

    protected Item.ElementTestResult testIsElement(String name, boolean last) throws HL7V2Exception {
        return null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.segments != null) {
            this.segments.setOwner(this);
        }
        if (this.children != null) {
            this.children.setOwner(this);
        }
    }
}

