/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.validators;

import org.eclipse.ohf.hl7v2.core.conformance.model.CPCell;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPComponent;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPConformanceProfile;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPField;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPFieldIterator;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPInteractionIterator;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPSegment;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPSegmentElementIterator;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPSegmentElements;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPStaticDefinition;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPTable;
import org.eclipse.ohf.hl7v2.core.definitions.model.TableDefn;
import org.eclipse.ohf.hl7v2.core.message.model.Cell;
import org.eclipse.ohf.hl7v2.core.message.model.Component;
import org.eclipse.ohf.hl7v2.core.message.model.Field;
import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.hl7v2.core.message.model.Segment;
import org.eclipse.ohf.hl7v2.core.message.model.SegmentIterator;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.hl7v2.core.validators.ICPValidatorProvider;
import org.eclipse.ohf.hl7v2.core.validators.Validator;

public class CPValidator
extends Validator
implements ICPValidatorProvider {
    private ICPValidatorProvider provider;
    private CPConformanceProfile providedProfile;

    public CPValidator() {
    }

    public CPValidator(ICPValidatorProvider provider) {
        this.setProvider(provider);
    }

    public CPValidator(CPConformanceProfile profile) {
        this.setProfile(profile);
    }

    public CPConformanceProfile getProfile() {
        return this.providedProfile;
    }

    public void setProfile(CPConformanceProfile profile) {
        this.provider = this;
        this.providedProfile = profile;
    }

    public ICPValidatorProvider getProvider() {
        return this.provider;
    }

    public void setProvider(ICPValidatorProvider provider) {
        this.provider = provider;
        this.providedProfile = null;
    }

    public CPConformanceProfile provide(Message message) {
        return this.providedProfile;
    }

    public void validate(Message message) throws HL7V2Exception {
        CPConformanceProfile profile = this.provider.provide(message);
        if (profile != null) {
            CPInteractionIterator iterator = profile.getInteractions().iteratorInteraction();
            iterator.first();
            CPStaticDefinition definition = null;
            while (iterator.more() && definition == null) {
                if (iterator.currentInteraction().getStaticDefinition().getEventType().equals(message.getEvent()) && iterator.currentInteraction().getStaticDefinition().getMsgType().equals(message.getMessageType())) {
                    definition = iterator.currentInteraction().getStaticDefinition();
                }
                iterator.next();
            }
            if (definition == null) {
                String msg = "The message type \"" + message.getMessageType() + "\\" + message.getEvent() + "\" is not allowed by the conformance profile " + profile.getMetaData().getDescriptiveName();
                this.event(message, 4, 21, msg);
            } else {
                this.validateMessage(message, definition);
            }
        }
    }

    private void validateMessage(Message message, CPStaticDefinition definition) throws HL7V2Exception {
        if (!message.hasStructId() && !definition.hasMsgStructId()) {
            this.event(message, 1, 21, "HL7 Message and Specification do not specify the Message StructureDefn ID");
        } else if (!message.hasStructId() && definition.hasMsgStructId()) {
            this.event(message, 3, 21, "HL7 Message does not specify the Message StructureDefn ID. Expected '" + definition.getMsgStructId() + "'");
        } else if (message.hasStructId() && !definition.hasMsgStructId()) {
            this.event(message, 2, 21, "Specification does not specify the Message StructureDefn ID. Message has '" + message.getStructId() + "'");
        } else if (!message.getStructId().equals(definition.getMsgStructId())) {
            this.event(message, 3, 21, "Message StructureDefn ID mismatch. Expected '" + definition.getMsgStructId() + "' Got '" + message.getStructId() + "'");
        }
        this.validateSegmentSequence(message, definition);
    }

    private void validateSegmentSequence(Message message, CPStaticDefinition definition) throws HL7V2Exception {
        SegmentIterator segments = message.getSegments().iteratorSegment();
        segments.first();
        if (!this.validateSegmentSequence(message, definition.getElements(), segments, true)) {
            this.event(message, 3, 1, "Validating segments - unable to find root segment group");
        }
        while (segments.more()) {
            this.event(segments.currentSegment(), 3, 1, "SegmentDefn " + segments.currentSegment().getCode() + " not described in conformance profile");
            segments.next();
        }
    }

    private boolean validateSegmentSequence(Message message, CPSegmentElements elements, SegmentIterator segments, boolean required) throws HL7V2Exception {
        boolean result = false;
        CPSegmentElementIterator sequence = elements.iteratorSegmentElement();
        sequence.first();
        int count = 0;
        while (sequence.more()) {
            boolean found;
            if (sequence.isSegment()) {
                found = this.validateSegment(sequence.currentSegment(), segments);
            } else if (sequence.isSegmentGroup()) {
                found = this.validateSegmentSequence(message, sequence.currentSegmentGroup().getElements(), segments, required || result);
            } else {
                throw new HL7V2Exception("unexpected type " + sequence.currentSegmentBase().getClass().getName(), 25);
            }
            if (found) {
                ++count;
                result = true;
            } else if (sequence.currentSegmentBase().getMin() > 0 && count == 0) {
                if (required || result) {
                    this.event(segments.more() ? segments.currentNode() : message, 3, 1, "Required SegmentDefn group " + elements.getPath() + " not found in message");
                } else {
                    return false;
                }
            }
            if (found && sequence.currentSegmentBase().getMax() < count) continue;
            sequence.next();
            count = 0;
        }
        return result;
    }

    private boolean validateSegment(CPSegment segment, SegmentIterator segments) throws HL7V2Exception {
        boolean result;
        boolean bl = result = segments.more() && segments.currentSegment().getCode().equals(segment.getName());
        if (result) {
            this.validateSegmentContents(segment, segments.currentSegment());
            segments.next();
        }
        return result;
    }

    private void validateSegmentContents(CPSegment definition, Segment instance) throws HL7V2Exception {
        CPFieldIterator iter = definition.getFields().iteratorField();
        iter.first();
        int max = 0;
        while (iter.more()) {
            max = iter.getCurrentIndex();
            if (max >= instance.getFields().size()) {
                this.validateMissingField(iter.currentField(), instance);
            } else {
                this.validateField(iter.currentField(), instance.getFields().item(max));
            }
            iter.next();
        }
        int i = max + 1;
        while (i < instance.getFields().size()) {
            this.validateUnexpectedField(instance.getFields().item(i));
            ++i;
        }
    }

    private void validateMissingField(CPField field, Segment instance) throws HL7V2Exception {
        if (field.isRequired()) {
            this.event(instance, 3, 25, "Field " + field.getName() + " not found");
        }
    }

    private void validateUnexpectedField(Field field) throws HL7V2Exception {
        if (field.hasContent()) {
            this.event(field, 3, 25, "Unexpected Field");
        }
    }

    private void validateField(CPField definition, Field instance) throws HL7V2Exception {
        int fieldCount = instance.getNonEmptyCount();
        if (definition.getUsage() == 1) {
            if (fieldCount == 0) {
                this.event(instance, 3, 25, "Required Field not found");
            }
        } else if (definition.getUsage() == 6) {
            if (fieldCount > 0) {
                this.event(instance, 3, 25, "Field is prohibited");
            }
        } else if (definition.getMin() > 1 && fieldCount > 0 && fieldCount < definition.getMin()) {
            this.event(instance, 3, 25, "Field must be absent or present at least " + Integer.toString(definition.getMin()) + " times");
        }
        if (definition.getMax() > -1 && fieldCount > definition.getMax()) {
            this.event(instance, 3, 25, "Field Repeat count (" + Integer.toString(fieldCount) + ") exceeds limit (" + Integer.toString(definition.getMax()) + ")");
        }
        if (instance.hasContent()) {
            if (definition.getComponents().size() == 0) {
                this.checkCell(definition, instance);
            } else {
                int i = 0;
                while (i < definition.getComponents().size()) {
                    if (i >= instance.getComponents().size()) {
                        this.validateMissingComponent(definition.getComponents().itemComponent(i), instance);
                    } else {
                        this.validateComponent(definition.getComponents().itemComponent(i), instance.getComponents().item(i));
                    }
                    ++i;
                }
                if (definition.hasLength() && instance.getConformanceLength() > definition.getLength()) {
                    this.event(instance, 3, 25, "Field length " + Integer.toString(instance.getConformanceLength()) + " exceeds allowed length " + Integer.toString(definition.getLength()));
                }
            }
        }
    }

    private void validateMissingComponent(CPComponent definition, Cell instance) throws HL7V2Exception {
        if (definition.isRequired()) {
            this.event(instance, 3, 25, "Component " + definition.getName() + " is required");
        }
    }

    private void validateComponent(CPComponent definition, Component instance) throws HL7V2Exception {
        if (definition.getUsage() == 1) {
            if (!instance.hasContent()) {
                this.event(instance, 3, 25, "Required Component not found");
            }
        } else if (definition.getUsage() == 6 && instance.hasContent()) {
            this.event(instance, 3, 25, "Component is prohibited");
        }
        if (instance.hasContent()) {
            if (definition.getComponents().size() == 0) {
                this.checkCell(definition, instance);
            } else {
                int i = 0;
                while (i < definition.getComponents().size()) {
                    if (i >= instance.getComponents().size()) {
                        this.validateMissingComponent(definition.getComponents().itemComponent(i), instance);
                    } else {
                        this.validateComponent(definition.getComponents().itemComponent(i), instance.getComponents().item(i));
                    }
                    ++i;
                }
                if (definition.hasLength() && instance.getConformanceLength() > definition.getLength()) {
                    this.event(instance, 3, 25, "Component length " + Integer.toString(instance.getConformanceLength()) + " exceeds allowed length " + Integer.toString(definition.getLength()));
                }
            }
        }
    }

    private void checkCell(CPCell definition, Cell instance) throws HL7V2Exception {
        CPTable profileTable;
        if (definition.getLength() > 0 && instance.getRawContent().length() > definition.getLength()) {
            this.event(instance, 3, 25, "length (" + Integer.toString(instance.getRawContent().length()) + ") exceeds length limitation (" + Integer.toString(definition.getLength()) + ")");
        }
        if (definition.hasFixedValue() && !instance.getRawContent().equals(definition.getFixedValue())) {
            this.event(instance, 3, 25, "content is not correct");
        }
        if (definition.hasTable() && (profileTable = this.getProfileTable(definition.getTable())) != null) {
            if (profileTable.getItems().existsByCode(instance.getAsString())) {
                this.event(instance, 3, 25, "Table value not allowed");
            } else {
                TableDefn defnTable = this.getDefinitionTable(instance, definition.getTable());
                if (defnTable != null && !defnTable.getItems().existsByCode(instance.getAsString())) {
                    this.event(instance, 3, 25, "Table value not allowed");
                }
            }
        }
    }

    private TableDefn getDefinitionTable(Cell instance, String table) {
        return instance.getVersionDefinition().getTables().itemById(table);
    }

    private CPTable getProfileTable(String table) {
        return null;
    }
}

