/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.consumer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xmi.DOMHandler;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.DefaultDOMHandlerImpl;
import org.eclipse.ohf.ihe.atna.audit.client.ATNAAuditClient;
import org.eclipse.ohf.ihe.common.hl7v2.CX;
import org.eclipse.ohf.ihe.common.hl7v2.format.HL7V2MessageFormat;
import org.eclipse.ohf.ihe.xds.XDSResponseParser;
import org.eclipse.ohf.ihe.xds.XDSUtils;
import org.eclipse.ohf.ihe.xds.consumer.AbstractConsumer;
import org.eclipse.ohf.ihe.xds.consumer.ConsumerException;
import org.eclipse.ohf.ihe.xds.consumer.retrieve.DocumentRequestType;
import org.eclipse.ohf.ihe.xds.consumer.retrieve.DocumentRoot;
import org.eclipse.ohf.ihe.xds.consumer.retrieve.RetrieveDocumentSetRequestType;
import org.eclipse.ohf.ihe.xds.consumer.retrieve.RetrieveFactory;
import org.eclipse.ohf.ihe.xds.consumer.retrieve.util.RetrieveResourceFactoryImpl;
import org.eclipse.ohf.ihe.xds.consumer.storedquery.StoredQuery;
import org.eclipse.ohf.ihe.xds.document.Document;
import org.eclipse.ohf.ihe.xds.response.ResponseFactory;
import org.eclipse.ohf.ihe.xds.response.XDSErrorCode;
import org.eclipse.ohf.ihe.xds.response.XDSErrorType;
import org.eclipse.ohf.ihe.xds.response.XDSQueryResponseType;
import org.eclipse.ohf.ihe.xds.response.XDSResponseType;
import org.eclipse.ohf.ihe.xds.response.XDSStatusType;
import org.eclipse.ohf.ihe.xds.soap.B_XDSSoapClient;
import org.eclipse.ohf.ihe.xds.soap.XDSSoapClient;
import org.w3c.dom.Element;

public class B_Consumer
extends AbstractConsumer {
    private static Logger logger;
    private java.net.URI initiatingGatewayURI;
    private java.net.URI primaryRepositoryURI;
    private Map repositoryMap;
    XDSSoapClient sender;
    private String ACTOR_NAME = "OHF_XDS_B_CONSUMER";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.xds.consumer.B_Consumer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public B_Consumer(java.net.URI regURI) {
        super(regURI);
        this.repositoryMap = new HashMap();
    }

    public B_Consumer(java.net.URI regURI, java.net.URI initiatingGatewayURI) {
        super(regURI);
        this.initiatingGatewayURI = initiatingGatewayURI;
        this.repositoryMap = new HashMap();
    }

    public B_Consumer(java.net.URI regURI, java.net.URI initiatingGatewayURI, Map repositoryMap) {
        super(regURI);
        this.initiatingGatewayURI = initiatingGatewayURI;
        this.repositoryMap = repositoryMap;
    }

    public java.net.URI getInitiatingGatewayURI() {
        return this.initiatingGatewayURI;
    }

    public void setInitiatingGatewayURI(java.net.URI initiatingGatewayURI) {
        this.initiatingGatewayURI = initiatingGatewayURI;
    }

    public Map getRepositoryMap() {
        return this.repositoryMap;
    }

    public void setRepositoryMap(Map repositoryMap) {
        this.repositoryMap = repositoryMap;
    }

    public java.net.URI getPrimaryRepositoryURI() {
        return this.primaryRepositoryURI;
    }

    public void setPrimaryRepositoryURI(java.net.URI primaryRepositoryURI) {
        this.primaryRepositoryURI = primaryRepositoryURI;
    }

    private void initializeSender() throws Exception {
        if (this.sender == null) {
            this.sender = new B_XDSSoapClient();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XDSQueryResponseType invokeStoredQuery(StoredQuery q, boolean returnReferencesOnly) throws Exception {
        if (this.regURI == null) {
            logger.fatal((Object)"Registry URI is null.");
            if (this.isDoAudit()) {
                this.auditor.auditActorStopEvent(0, this.ACTOR_NAME);
            }
            throw new ConsumerException("Registry URI is null.");
        }
        Element ebXMLQuery = this.formEbXMLStoredQuery(q, returnReferencesOnly);
        String ebXmlQueryString = new String(XDSUtils.serialize((Element)ebXMLQuery));
        this.initializeSender();
        int eventOutcome = 0;
        Element returnXML = null;
        try {
            try {
                returnXML = this.sender.send(ebXMLQuery, null, this.regURI, "urn:ihe:iti:2007:RegistryStoredQuery");
            }
            catch (Exception e) {
                eventOutcome = 8;
                if (this.isDoAudit()) {
                    this.auditor.auditActorStopEvent(0, this.ACTOR_NAME);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (this.isDoAudit()) {
                this.auditor.auditQueryEvent(eventOutcome, this.getRegURL(), ebXmlQueryString, q.getQueryUUID(), null, ATNAAuditClient.IHE_ITI_18_EVENT_CODE);
            }
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        if (this.isDoAudit()) {
            this.auditor.auditQueryEvent(eventOutcome, this.getRegURL(), ebXmlQueryString, q.getQueryUUID(), null, ATNAAuditClient.IHE_ITI_18_EVENT_CODE);
        }
        String output = new String(XDSUtils.serialize((Element)returnXML));
        logger.debug((Object)("Got response : " + output));
        XDSQueryResponseType xdsResponse = (XDSQueryResponseType)XDSResponseParser.processResponse((Element)returnXML, (boolean)true);
        if (xdsResponse.getStatus().equals(XDSStatusType.SUCCESS_LITERAL)) {
            this.processEbXML_3_0QueryResults(returnXML, xdsResponse);
        }
        if (this.isDoAudit()) {
            this.auditor.auditActorStopEvent(0, this.ACTOR_NAME);
        }
        return xdsResponse;
    }

    public XDSResponseType retrieveDocumentSet(RetrieveDocumentSetRequestType retrieveRequest, List documents, CX patientId) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Begin Document Retrieve.");
        }
        if (this.isDoAudit()) {
            this.auditor.auditActorStartEvent(0, this.ACTOR_NAME);
        }
        if (documents == null) {
            logger.error((Object)"Parameter 'documents' is null. This parameter is required to be instantiated.");
            throw new ConsumerException("Parameter 'documents' is null. This parameter is required to be instantiated.");
        }
        XDSResponseType aggregateResponse = ResponseFactory.eINSTANCE.createXDSResponseType();
        aggregateResponse.setStatus(XDSStatusType.SUCCESS_LITERAL);
        HashMap requestDestinationMap = new HashMap();
        Iterator i = retrieveRequest.getDocumentRequest().iterator();
        while (i.hasNext()) {
            XDSErrorType error;
            ArrayList<DocumentRequestType> list;
            DocumentRequestType docRequest = (DocumentRequestType)i.next();
            if (docRequest.getHomeCommunityId() != null && docRequest.getHomeCommunityId().length() > 0) {
                if (this.initiatingGatewayURI != null) {
                    if (requestDestinationMap.containsKey(this.initiatingGatewayURI)) {
                        ((List)requestDestinationMap.get(this.initiatingGatewayURI)).add(this.copy(docRequest));
                        continue;
                    }
                    list = new ArrayList();
                    list.add(this.copy(docRequest));
                    requestDestinationMap.put(this.initiatingGatewayURI, list);
                    continue;
                }
                if (aggregateResponse.getErrorList() == null) {
                    aggregateResponse.setErrorList(ResponseFactory.eINSTANCE.createXDSErrorListType());
                }
                error = ResponseFactory.eINSTANCE.createXDSErrorType();
                error.setErrorCode(XDSErrorCode.XDS_REPOSITORY_ERROR_LITERAL);
                error.setLocation(this.ACTOR_NAME);
                error.setSeverity(XDSStatusType.ERROR_LITERAL);
                error.setValue("DocumentRequest for: " + docRequest.getDocumentUniqueId() + "contained" + " a homeCommunityId, but the initiatingGateway on OHF B_Consumer was not set.");
                aggregateResponse.getErrorList().getError().add((Object)error);
                logger.error((Object)("DocumentRequest for: " + docRequest.getDocumentUniqueId() + "contained" + " a homeCommunityId, but the initiatingGateway on OHF B_Consumer was not set."));
                if (!aggregateResponse.getStatus().equals(XDSStatusType.SUCCESS_LITERAL)) continue;
                aggregateResponse.setStatus(XDSStatusType.FAILURE_LITERAL);
                continue;
            }
            if (this.primaryRepositoryURI != null) {
                if (requestDestinationMap.containsKey(this.primaryRepositoryURI)) {
                    ((List)requestDestinationMap.get(this.primaryRepositoryURI)).add(this.copy(docRequest));
                    continue;
                }
                list = new ArrayList<DocumentRequestType>();
                list.add(this.copy(docRequest));
                requestDestinationMap.put(this.primaryRepositoryURI, list);
                continue;
            }
            if (this.repositoryMap.containsKey(docRequest.getRepositoryUniqueId())) {
                java.net.URI repositoryURI = (java.net.URI)this.repositoryMap.get(docRequest.getRepositoryUniqueId());
                if (requestDestinationMap.containsKey(repositoryURI)) {
                    ((List)requestDestinationMap.get(repositoryURI)).add(this.copy(docRequest));
                    continue;
                }
                ArrayList<DocumentRequestType> list2 = new ArrayList<DocumentRequestType>();
                list2.add(this.copy(docRequest));
                requestDestinationMap.put(repositoryURI, list2);
                continue;
            }
            if (aggregateResponse.getErrorList() == null) {
                aggregateResponse.setErrorList(ResponseFactory.eINSTANCE.createXDSErrorListType());
            }
            error = ResponseFactory.eINSTANCE.createXDSErrorType();
            error.setErrorCode(XDSErrorCode.XDS_REPOSITORY_ERROR_LITERAL);
            error.setLocation(this.ACTOR_NAME);
            error.setSeverity(XDSStatusType.ERROR_LITERAL);
            error.setValue("DocumentRequest for: " + docRequest.getDocumentUniqueId() + "contained" + " un recognized repositoryUniqueId and no primaryRepositoryURI was set on OHF B_Consumer was not set.");
            aggregateResponse.getErrorList().getError().add((Object)error);
            logger.error((Object)("DocumentRequest for: " + docRequest.getDocumentUniqueId() + "contained" + " un recognized repositoryUniqueId and no primaryRepositoryURI was set on OHF B_Consumer was not set."));
            if (!aggregateResponse.getStatus().equals(XDSStatusType.SUCCESS_LITERAL)) continue;
            aggregateResponse.setStatus(XDSStatusType.FAILURE_LITERAL);
        }
        i = requestDestinationMap.keySet().iterator();
        while (i.hasNext()) {
            int eventOutcome = 0;
            java.net.URI destinationURI = (java.net.URI)i.next();
            RetrieveDocumentSetRequestType subRequest = RetrieveFactory.eINSTANCE.createRetrieveDocumentSetRequestType();
            Iterator j = ((List)requestDestinationMap.get(destinationURI)).iterator();
            while (j.hasNext()) {
                subRequest.getDocumentRequest().add((Object)((DocumentRequestType)j.next()));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sending " + subRequest.getDocumentRequest().size() + " document requests to: " + destinationURI.toString()));
            }
            DocumentRoot root = RetrieveFactory.eINSTANCE.createDocumentRoot();
            root.setRetrieveDocumentSetRequest(subRequest);
            XMLResource resource = (XMLResource)new RetrieveResourceFactoryImpl().createResource(URI.createURI((String)"urn:ihe:iti:xds-b:2007"));
            resource.getContents().add((Object)root);
            org.w3c.dom.Document requestDoc = XDSUtils.createDomDocument();
            resource.save(requestDoc, new HashMap(), (DOMHandler)new DefaultDOMHandlerImpl());
            this.initializeSender();
            XDSResponseType response = null;
            try {
                Element reply = this.sender.send(requestDoc.getDocumentElement(), null, destinationURI, "urn:ihe:iti:2007:RetrieveDocumentSet");
                response = XDSResponseParser.processResponse((Element)reply, (boolean)false);
            }
            catch (Exception e) {
                response = ResponseFactory.eINSTANCE.createXDSResponseType();
                response.setErrorList(ResponseFactory.eINSTANCE.createXDSErrorListType());
                response.setStatus(XDSStatusType.FAILURE_LITERAL);
                XDSErrorType error = ResponseFactory.eINSTANCE.createXDSErrorType();
                error.setErrorCode(XDSErrorCode.XDS_REPOSITORY_ERROR_LITERAL);
                error.setLocation(destinationURI.toString());
                error.setSeverity(XDSStatusType.ERROR_LITERAL);
                error.setValue("Error retrieving the requested document(s) from " + destinationURI.toString() + ": " + e.getMessage() + ". See logs for stack trace.");
                response.getErrorList().getError().add((Object)error);
                logger.error((Object)("Error retrieving the requested document(s) from " + destinationURI.toString() + ": " + e.getMessage()), (Throwable)e);
                eventOutcome = 4;
            }
            if (this.sender.getAttachments() != null) {
                documents.addAll(this.sender.getAttachments());
                if (this.isDoAudit()) {
                    this.auditor.auditPHIImportEvent(eventOutcome, destinationURI.toString(), HL7V2MessageFormat.toMessageString((CX)patientId, (char)'^', (char)'&'), XDSUtils.getDocumentUniqueIdsFromResult((List)this.sender.getAttachments()), ATNAAuditClient.IHE_ITI_43_EVENT_CODE);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Now have recieved " + documents.size() + " documents."));
            }
            if (response.getStatus().equals(XDSStatusType.SUCCESS_LITERAL) && aggregateResponse.getStatus().equals(XDSStatusType.FAILURE_LITERAL)) {
                aggregateResponse.setStatus(XDSStatusType.PARTIAL_SUCCESS_LITERAL);
            } else if ((response.getStatus().equals(XDSStatusType.FAILURE_LITERAL) || response.getStatus().equals(XDSStatusType.PARTIAL_SUCCESS_LITERAL)) && aggregateResponse.getStatus().equals(XDSStatusType.SUCCESS_LITERAL)) {
                aggregateResponse.setStatus(XDSStatusType.PARTIAL_SUCCESS_LITERAL);
            }
            if (aggregateResponse.getErrorList() == null) {
                aggregateResponse.setErrorList(ResponseFactory.eINSTANCE.createXDSErrorListType());
            }
            if (response.getErrorList() == null || response.getErrorList().getError().isEmpty()) continue;
            aggregateResponse.getErrorList().getError().addAll((Collection)response.getErrorList().getError());
        }
        if (logger.isDebugEnabled() && documents != null) {
            logger.debug((Object)("Received " + documents.size() + " documents in total"));
            Iterator allResponseDocuments = documents.iterator();
            int docCount = 1;
            while (allResponseDocuments.hasNext()) {
                Document tempDoc = (Document)allResponseDocuments.next();
                logger.debug((Object)("- Document #" + docCount + " [ID=" + tempDoc.getDocumentUniqueId() + ", REP=" + tempDoc.getRepositoryUniqueId() + ", SIZE=" + tempDoc.getDocumentData().length + "]"));
                ++docCount;
            }
        }
        if (this.isDoAudit()) {
            int eventOutcome = !aggregateResponse.getStatus().equals(XDSStatusType.SUCCESS_LITERAL) ? 4 : 0;
            this.auditor.auditActorStopEvent(eventOutcome, this.ACTOR_NAME);
        }
        return aggregateResponse;
    }

    private DocumentRequestType copy(DocumentRequestType docRequest) {
        DocumentRequestType returnRequest = RetrieveFactory.eINSTANCE.createDocumentRequestType();
        returnRequest.setDocumentUniqueId(docRequest.getDocumentUniqueId());
        returnRequest.setHomeCommunityId(docRequest.getHomeCommunityId());
        returnRequest.setRepositoryUniqueId(docRequest.getRepositoryUniqueId());
        return returnRequest;
    }
}

