/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.consumer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.net.ssl.SSLException;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xmi.DOMHandler;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.DefaultDOMHandlerImpl;
import org.eclipse.ohf.ihe.atna.agent.AtnaAgent;
import org.eclipse.ohf.ihe.atna.agent.AtnaAgentFactory;
import org.eclipse.ohf.ihe.atna.audit.client.ATNAAuditClient;
import org.eclipse.ohf.ihe.common.atna.NoSecurityDomainException;
import org.eclipse.ohf.ihe.common.ebxml._2._1.query.AdhocQueryRequestType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.query.DocumentRoot;
import org.eclipse.ohf.ihe.common.ebxml._2._1.query.QueryFactory;
import org.eclipse.ohf.ihe.common.ebxml._2._1.query.ResponseOptionType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.query.ReturnTypeType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.query.util.QueryResourceFactoryImpl;
import org.eclipse.ohf.ihe.common.hl7v2.CX;
import org.eclipse.ohf.ihe.common.hl7v2.format.HL7V2MessageFormat;
import org.eclipse.ohf.ihe.xds.XDSResponseParser;
import org.eclipse.ohf.ihe.xds.XDSUtils;
import org.eclipse.ohf.ihe.xds.consumer.AbstractConsumer;
import org.eclipse.ohf.ihe.xds.consumer.ConsumerException;
import org.eclipse.ohf.ihe.xds.consumer.query.MalformedQueryException;
import org.eclipse.ohf.ihe.xds.consumer.query.Query;
import org.eclipse.ohf.ihe.xds.consumer.query.QueryBuilder;
import org.eclipse.ohf.ihe.xds.consumer.storedquery.StoredQuery;
import org.eclipse.ohf.ihe.xds.response.XDSQueryResponseType;
import org.eclipse.ohf.ihe.xds.response.XDSStatusType;
import org.eclipse.ohf.ihe.xds.soap.A_XDSSoapClient;
import org.eclipse.ohf.ihe.xds.soap.XDSSoapClient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Consumer
extends AbstractConsumer {
    private static Logger logger;
    private XDSSoapClient sender;
    private String ACTOR_NAME = "OHF_XDS_CONSUMER";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.xds.consumer.Consumer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public Consumer(java.net.URI regURI) {
        super(regURI);
    }

    private void initializeSender() throws Exception {
        if (this.sender == null) {
            this.sender = new A_XDSSoapClient();
        }
    }

    public XDSQueryResponseType query(Query q, boolean returnReferencesOnly) throws Exception {
        if (q == null) {
            logger.fatal((Object)"NULL QUERY");
            throw new ConsumerException("NULL QUERY");
        }
        StringBuffer query = new StringBuffer();
        try {
            QueryBuilder qb = new QueryBuilder(q);
            query.append(qb.build());
        }
        catch (MalformedQueryException e) {
            logger.fatal((Object)("BAD QUERY: " + e.getMessage()), (Throwable)((Object)e));
            throw e;
        }
        Element returnXML = this.query(query.toString(), returnReferencesOnly);
        XDSQueryResponseType xdsResponse = (XDSQueryResponseType)XDSResponseParser.processResponse((Element)returnXML, (boolean)true);
        if (xdsResponse.getStatus().equals(XDSStatusType.SUCCESS_LITERAL)) {
            this.processEbXML_2_1QueryResults(returnXML, xdsResponse);
        }
        if (this.isDoAudit()) {
            this.auditor.auditActorStopEvent(0, this.ACTOR_NAME);
        }
        return xdsResponse;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Element query(String sqlQueryString, boolean returnReferencesOnly) throws Exception {
        if (this.isDoAudit()) {
            this.auditor.auditActorStartEvent(0, this.ACTOR_NAME);
        }
        if (this.regURI == null) {
            logger.fatal((Object)"Registry URI is null.");
            if (this.isDoAudit()) {
                this.auditor.auditActorStopEvent(0, this.ACTOR_NAME);
            }
            throw new ConsumerException("Registry URI is null.");
        }
        if (sqlQueryString == null) {
            logger.fatal((Object)"NULL QUERY");
            if (this.isDoAudit()) {
                this.auditor.auditActorStopEvent(0, this.ACTOR_NAME);
            }
            throw new ConsumerException("NULL QUERY");
        }
        if (sqlQueryString.length() <= 0) {
            logger.fatal((Object)"NULL QUERY");
            if (this.isDoAudit()) {
                this.auditor.auditActorStopEvent(0, this.ACTOR_NAME);
            }
            throw new ConsumerException("NULL QUERY");
        }
        ReturnTypeType returnType = null;
        returnType = returnReferencesOnly ? ReturnTypeType.OBJECT_REF_LITERAL : ReturnTypeType.LEAF_CLASS_LITERAL;
        Element ebXMLQuery = null;
        try {
            ebXMLQuery = this.formatEBXML_2_1QueryString(sqlQueryString, returnType);
        }
        catch (IOException e) {
            logger.fatal((Object)"Could not format ebXML for the query string.", (Throwable)e);
            if (this.isDoAudit()) {
                this.auditor.auditActorStopEvent(0, this.ACTOR_NAME);
            }
            throw e;
        }
        String ebXmlQueryString = new String(XDSUtils.serialize((Element)ebXMLQuery));
        int eventOutcome = 0;
        Element returnXML = null;
        try {
            try {
                returnXML = this.sendQuery(ebXMLQuery);
            }
            catch (Exception e) {
                eventOutcome = 8;
                if (this.isDoAudit()) {
                    this.auditor.auditActorStopEvent(0, this.ACTOR_NAME);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (this.isDoAudit()) {
                this.auditor.auditQueryEvent(eventOutcome, this.getRegURL(), ebXmlQueryString, "", null, ATNAAuditClient.IHE_ITI_16_EVENT_CODE);
            }
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        if (this.isDoAudit()) {
            this.auditor.auditQueryEvent(eventOutcome, this.getRegURL(), ebXmlQueryString, "", null, ATNAAuditClient.IHE_ITI_16_EVENT_CODE);
        }
        if (this.isDoAudit()) {
            this.auditor.auditActorStopEvent(0, this.ACTOR_NAME);
        }
        return returnXML;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XDSQueryResponseType invokeStoredQuery(StoredQuery q, boolean returnReferencesOnly) throws Exception {
        Element ebXMLQuery = this.formEbXMLStoredQuery(q, returnReferencesOnly);
        String ebXmlQueryString = new String(XDSUtils.serialize((Element)ebXMLQuery));
        if (this.regURI == null) {
            logger.fatal((Object)"Registry URI is null.");
            if (this.isDoAudit()) {
                this.auditor.auditActorStopEvent(0, this.ACTOR_NAME);
            }
            throw new ConsumerException("Registry URI is null.");
        }
        int eventOutcome = 0;
        Element returnXML = null;
        try {
            try {
                returnXML = this.sendQuery(ebXMLQuery);
            }
            catch (Exception e) {
                eventOutcome = 8;
                if (this.isDoAudit()) {
                    this.auditor.auditActorStopEvent(0, this.ACTOR_NAME);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (this.isDoAudit()) {
                this.auditor.auditQueryEvent(eventOutcome, this.getRegURL(), ebXmlQueryString, q.getQueryUUID(), null, ATNAAuditClient.IHE_ITI_18_EVENT_CODE);
            }
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        if (this.isDoAudit()) {
            this.auditor.auditQueryEvent(eventOutcome, this.getRegURL(), ebXmlQueryString, q.getQueryUUID(), null, ATNAAuditClient.IHE_ITI_18_EVENT_CODE);
        }
        String output = new String(XDSUtils.serialize((Element)returnXML));
        logger.debug((Object)("Got response : " + output));
        XDSQueryResponseType xdsResponse = (XDSQueryResponseType)XDSResponseParser.processResponse((Element)returnXML, (boolean)true);
        if (xdsResponse.getStatus().equals(XDSStatusType.SUCCESS_LITERAL)) {
            this.processEbXML_3_0QueryResults(returnXML, xdsResponse);
        }
        if (this.isDoAudit()) {
            this.auditor.auditActorStopEvent(0, this.ACTOR_NAME);
        }
        return xdsResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream retrieveDocument(String uri, CX patientId, String documentUniqueId) throws Exception {
        InputStream inputStream;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Begin Document Retrieve.");
        }
        int eventOutcome = 0;
        java.net.URI realURI = null;
        try {
            realURI = new java.net.URI(uri);
        }
        catch (URISyntaxException e) {
            logger.error((Object)"URL is not valid.", (Throwable)e);
            if (!this.isDoAudit()) return null;
            this.auditor.auditActorStopEvent(0, this.ACTOR_NAME);
            return null;
        }
        AtnaAgent agent = AtnaAgentFactory.getAtnaAgent();
        try {
            try {
                InputStream is;
                inputStream = is = agent.getInputStream(realURI);
                Object var8_13 = null;
            }
            catch (NoSecurityDomainException e) {
                logger.error((Object)"No Security Domain Defined.", (Throwable)e);
                if (!this.isDoAudit()) throw e;
                eventOutcome = 8;
                this.auditor.auditActorStopEvent(8, this.ACTOR_NAME);
                throw e;
            }
            catch (SSLException f) {
                logger.error((Object)"SSLException", (Throwable)f);
                if (!this.isDoAudit()) throw f;
                eventOutcome = 8;
                this.auditor.auditActorStopEvent(8, this.ACTOR_NAME);
                throw f;
            }
            catch (IOException t) {
                eventOutcome = 8;
                logger.error((Object)"IOException", (Throwable)t);
                if (!this.isDoAudit()) throw t;
                this.auditor.auditActorStopEvent(8, this.ACTOR_NAME);
                throw t;
            }
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            if (!this.isDoAudit()) throw throwable;
            this.auditor.auditPHIImportEvent(eventOutcome, realURI.toString(), HL7V2MessageFormat.toMessageString((CX)patientId, (char)'^', (char)'&'), new String[]{documentUniqueId}, ATNAAuditClient.IHE_ITI_17_EVENT_CODE);
            throw throwable;
        }
        if (!this.isDoAudit()) return inputStream;
        this.auditor.auditPHIImportEvent(eventOutcome, realURI.toString(), HL7V2MessageFormat.toMessageString((CX)patientId, (char)'^', (char)'&'), new String[]{documentUniqueId}, ATNAAuditClient.IHE_ITI_17_EVENT_CODE);
        return inputStream;
    }

    private Element formatEBXML_2_1QueryString(String sqlQuery, ReturnTypeType returnType) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"creating the ebXML for the query");
        }
        AdhocQueryRequestType adhqr = QueryFactory.eINSTANCE.createAdhocQueryRequestType();
        ResponseOptionType respType = QueryFactory.eINSTANCE.createResponseOptionType();
        respType.setReturnComposedObjects(true);
        respType.setReturnType(returnType);
        adhqr.setResponseOption(respType);
        adhqr.setSQLQuery(sqlQuery.toString());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"serializing the ebXML for the to a string");
        }
        DocumentRoot root = QueryFactory.eINSTANCE.createDocumentRoot();
        root.setAdhocQueryRequest(adhqr);
        XMLResource resource = (XMLResource)new QueryResourceFactoryImpl().createResource(URI.createURI((String)"urn:oasis:names:tc:ebxml-regrep:query:xsd:2.1"));
        resource.getContents().add((Object)root);
        HashMap saveOpt = new HashMap();
        Document domDocument = XDSUtils.createDomDocument();
        resource.save(domDocument, saveOpt, (DOMHandler)new DefaultDOMHandlerImpl());
        resource.unload();
        return domDocument.getDocumentElement();
    }

    protected Element sendQuery(Element query) throws Exception {
        if (this.regURI == null) {
            throw new ConsumerException("Failed to initialize Consumer.regURI");
        }
        logger.info((Object)("Executing query against registry URL='" + this.regURI.toString() + "'"));
        logger.info((Object)"== Query ====>");
        Element reply = null;
        this.initializeSender();
        reply = this.sender.send(query, null, this.regURI);
        if (reply == null) {
            throw new ConsumerException("No data returned from registry. Response is null.");
        }
        return reply;
    }
}

