/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.consumer.storedquery;

import org.eclipse.ohf.ihe.xds.consumer.storedquery.MalformedStoredQueryException;
import org.eclipse.ohf.ihe.xds.consumer.storedquery.StoredQuery;
import org.eclipse.ohf.ihe.xds.consumer.storedquery.StoredQueryBuilderUtils;
import org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType;

public class GetFolderAndContentsQuery
extends StoredQuery {
    public GetFolderAndContentsQuery(String folderID, boolean isUUID, CodedMetadataType[] formatCodes, CodedMetadataType[] confidentialityCodes) throws MalformedStoredQueryException {
        super("urn:uuid:b909a503-523d-4517-8acf-8e5834dfc4c7");
        if (folderID == null) {
            throw new MalformedStoredQueryException("Null folder ID. Cannot proceed with query.");
        }
        if (folderID.length() == 0) {
            throw new MalformedStoredQueryException("No folder ID. Cannot proceed with query.");
        }
        String clause = String.valueOf('\'') + folderID + '\'';
        if (isUUID) {
            this.queryParameters.put("$XDSFolderEntryUUID", clause);
        } else {
            this.queryParameters.put("$XDSFolderUniqueId", clause);
        }
        if (formatCodes != null && formatCodes.length > 0) {
            StoredQueryBuilderUtils.addCodedParameters(this.queryParameters, "urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d", formatCodes);
        }
        if (confidentialityCodes != null && confidentialityCodes.length > 0) {
            StoredQueryBuilderUtils.addCodedParameters(this.queryParameters, "urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f", confidentialityCodes);
        }
    }

    public GetFolderAndContentsQuery(String folderID, boolean isUUID, CodedMetadataType[] formatCodes, CodedMetadataType[] confidentialityCodes, String homeCommunityId) throws MalformedStoredQueryException {
        this(folderID, isUUID, formatCodes, confidentialityCodes);
        if (homeCommunityId != null && homeCommunityId.length() > 0) {
            this.homeCommunityId = homeCommunityId;
        }
    }
}

