/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.ihe;

import java.net.URI;
import org.apache.log4j.Logger;
import org.eclipse.ohf.bridge.conf.AbstractRhioDedicatedResources;
import org.eclipse.ohf.bridge.conf.TransactionContext;
import org.eclipse.ohf.bridge.conf.UnavailableResourcesException;
import org.eclipse.ohf.bridge.conf.rhio.RhioConfig;
import org.eclipse.ohf.ihe.atna.agent.AtnaAgentFactory;
import org.eclipse.ohf.ihe.xds.consumer.B_Consumer;
import org.eclipse.ohf.ihe.xds.consumer.Consumer;
import org.eclipse.ohf.ihe.xds.source.B_Source;
import org.eclipse.ohf.ihe.xds.source.Source;

public class XdsResources
extends AbstractRhioDedicatedResources {
    static final Logger mLogger = Logger.getLogger(XdsResources.class);
    private Consumer mXdsStoredQueriesDocumentConsumer;
    private Consumer mXdsNoneStoredQueriesDocumentConsumer;
    private Source mXdsDocumentSource;
    private B_Consumer mXcaDocumentConsumer;
    private B_Consumer mXdsBDocumentConsumer;
    private B_Source mXdsBDocumentSource;

    public XdsResources(RhioConfig pConfig) {
        super(pConfig);
    }

    public boolean isXdsBTransaction() {
        return this.getRhioConfiguration().getXdsRegistryConfig().getXdsType().equals("b");
    }

    public boolean isNonStoredQueryResourcesAvailable() {
        return this.getRhioConfiguration().getXdsRegistryConfig().getNonStoredQueryUrl() != null;
    }

    public boolean isStoredQueryResourcesAvailable() {
        return this.getRhioConfiguration().getXdsRegistryConfig().getStoredQueryUrl() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Consumer getNonStoredQueryXdsDocumentConsumer() throws UnavailableResourcesException, Exception {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting Consumer getNoneStoredQueriesXdsDocumentConsumer()  in " + TransactionContext.instant().getSessionContext() + " using " + this.getRhioConfiguration()));
        }
        XdsResources xdsResources = this;
        synchronized (xdsResources) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("creating Consumer with " + this.getRhioConfiguration().getXdsRegistryConfig().getNonStoredQueryUrl()));
            }
            if (this.getRhioConfiguration().getXdsRegistryConfig().getNonStoredQueryUrl() == null) {
                throw new UnavailableResourcesException("NonStoredQueryUrl is not defined for this RHIO " + TransactionContext.instant().getSessionContext());
            }
            AtnaAgentFactory.getAtnaAgent().setDoAudit(this.getRhioConfiguration().getAuditConfig().getAuditUri() != null);
            URI registryUri = new URI(this.getRhioConfiguration().getXdsRegistryConfig().getNonStoredQueryUrl().defaultUri());
            this.mXdsNoneStoredQueriesDocumentConsumer = new Consumer(registryUri);
        }
        return this.mXdsNoneStoredQueriesDocumentConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public B_Consumer getStoredQueryXcaDocumentConsumer() throws UnavailableResourcesException, Exception {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting Consumer getStoredQueryXcaDocumentConsumer()  in " + TransactionContext.instant().getSessionContext() + " using " + this.getRhioConfiguration()));
        }
        XdsResources xdsResources = this;
        synchronized (xdsResources) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("creating XCA-specific Document Consumer with " + this.getRhioConfiguration().getXcaGatewayConfig().getStoredQueryUrl().defaultUri()));
            }
            if (this.getRhioConfiguration().getXcaGatewayConfig().getStoredQueryUrl() == null) {
                throw new UnavailableResourcesException("An XCA Gateway is not defined for this RHIO " + TransactionContext.instant().getSessionContext());
            }
            AtnaAgentFactory.getAtnaAgent().setDoAudit(this.getRhioConfiguration().getAuditConfig().getAuditUri() != null);
            URI registryUri = new URI(this.getRhioConfiguration().getXcaGatewayConfig().getStoredQueryUrl().defaultUri());
            this.mXcaDocumentConsumer = new B_Consumer(registryUri);
        }
        return this.mXcaDocumentConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Consumer getStoredQueryXdsDocumentConsumer() throws UnavailableResourcesException, Exception {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting Consumer getStoredQueriesXdsDocumentConsumer()  in " + TransactionContext.instant().getSessionContext() + " using " + this.getRhioConfiguration()));
        }
        XdsResources xdsResources = this;
        synchronized (xdsResources) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("creating Consumer with " + this.getRhioConfiguration().getXdsRegistryConfig().getStoredQueryUrl().defaultUri()));
            }
            if (this.getRhioConfiguration().getXdsRegistryConfig().getStoredQueryUrl() == null) {
                throw new UnavailableResourcesException("StoredQueriesUrl is not defined for this RHIO " + TransactionContext.instant().getSessionContext());
            }
            AtnaAgentFactory.getAtnaAgent().setDoAudit(this.getRhioConfiguration().getAuditConfig().getAuditUri() != null);
            URI registryUri = new URI(this.getRhioConfiguration().getXdsRegistryConfig().getStoredQueryUrl().defaultUri());
            this.mXdsStoredQueriesDocumentConsumer = new Consumer(registryUri);
        }
        return this.mXdsStoredQueriesDocumentConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Source getXdsDocumentSource() throws Exception {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting Source getXdsDocumentSource()  in " + TransactionContext.instant().getSessionContext() + " using " + this.getRhioConfiguration()));
        }
        XdsResources xdsResources = this;
        synchronized (xdsResources) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("default repository version: " + this.getRhioConfiguration().getDefaultXdsRepositoryConfig().getXdsType()));
                mLogger.debug((Object)("creating source with " + this.getRhioConfiguration().getDefaultXdsRepositoryConfig().getProvideAndRegisterUrl().defaultUri()));
            }
            if (this.getRhioConfiguration().getDefaultXdsRepositoryConfig().getProvideAndRegisterUrl().defaultUri() == null) {
                throw new UnavailableResourcesException("XDs.a Repository URL is not defined for this RHIO " + TransactionContext.instant().getSessionContext());
            }
            if (!this.getRhioConfiguration().getDefaultXdsRepositoryConfig().getXdsType().equalsIgnoreCase("a")) {
                throw new UnavailableResourcesException("Repository URL is not defined as XDS.a" + TransactionContext.instant().getSessionContext());
            }
            AtnaAgentFactory.getAtnaAgent().setDoAudit(this.getRhioConfiguration().getAuditConfig().getAuditUri() != null);
            URI repositoryUri = new URI(this.getRhioConfiguration().getDefaultXdsRepositoryConfig().getProvideAndRegisterUrl().defaultUri());
            this.mXdsDocumentSource = new Source(repositoryUri);
        }
        return this.mXdsDocumentSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public B_Consumer getXdsBDocumentConsumer() throws UnavailableResourcesException, Exception {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting Consumer getXdsBDocumentConsumer()  in " + TransactionContext.instant().getSessionContext() + " using " + this.getRhioConfiguration()));
        }
        XdsResources xdsResources = this;
        synchronized (xdsResources) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("creating B Consumer with " + this.getRhioConfiguration().getXdsRegistryConfig().getStoredQueryUrl().defaultUri()));
            }
            if (this.getRhioConfiguration().getXdsRegistryConfig().getStoredQueryUrl() == null) {
                throw new UnavailableResourcesException("StoredQueriesUrl is not defined for this RHIO " + TransactionContext.instant().getSessionContext());
            }
            AtnaAgentFactory.getAtnaAgent().setDoAudit(this.getRhioConfiguration().getAuditConfig().getAuditUri() != null);
            URI registryUri = new URI(this.getRhioConfiguration().getXdsRegistryConfig().getStoredQueryUrl().defaultUri());
            this.mXdsBDocumentConsumer = new B_Consumer(registryUri);
        }
        return this.mXdsBDocumentConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public B_Source getXdsBDocumentSource() throws Exception {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting Source getXdsBDocumentSource()  in " + TransactionContext.instant().getSessionContext() + " using " + this.getRhioConfiguration()));
        }
        XdsResources xdsResources = this;
        synchronized (xdsResources) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("default repository version: " + this.getRhioConfiguration().getDefaultXdsRepositoryConfig().getXdsType()));
                mLogger.debug((Object)("creating B source with " + this.getRhioConfiguration().getDefaultXdsRepositoryConfig().getProvideAndRegisterUrl().defaultUri()));
            }
            if (this.getRhioConfiguration().getDefaultXdsRepositoryConfig().getProvideAndRegisterUrl().defaultUri() == null) {
                throw new UnavailableResourcesException("XDs.b Repository URL is not defined for this RHIO " + TransactionContext.instant().getSessionContext());
            }
            if (!this.getRhioConfiguration().getDefaultXdsRepositoryConfig().getXdsType().equalsIgnoreCase("b")) {
                throw new UnavailableResourcesException("Repository URL is not an XDS.b repository:  " + TransactionContext.instant().getSessionContext());
            }
            AtnaAgentFactory.getAtnaAgent().setDoAudit(this.getRhioConfiguration().getAuditConfig().getAuditUri() != null);
            URI repositoryUri = new URI(this.getRhioConfiguration().getDefaultXdsRepositoryConfig().getProvideAndRegisterUrl().defaultUri());
            this.mXdsBDocumentSource = new B_Source(repositoryUri);
        }
        return this.mXdsBDocumentSource;
    }
}

