/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.ws;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.ohf.bridge.BridgeTransactionAwareLog4jAppender;
import org.eclipse.ohf.bridge.Constants;
import org.eclipse.ohf.bridge.Utils;
import org.eclipse.ohf.bridge.conf.Configurations;
import org.eclipse.ohf.bridge.conf.RhioDedicatedResources;
import org.eclipse.ohf.bridge.conf.SessionContext;
import org.eclipse.ohf.bridge.conf.TransactionContext;
import org.eclipse.ohf.bridge.conf.UnavailableResourcesException;
import org.eclipse.ohf.bridge.conf.rhio.AuditConfig;
import org.eclipse.ohf.bridge.conf.rhio.IheUri;
import org.eclipse.ohf.bridge.conf.rhio.RhioConfig;
import org.eclipse.ohf.bridge.type.DocumentQueryPreferencesType;
import org.eclipse.ohf.bridge.type.DocumentSubmissionMetadataType;
import org.eclipse.ohf.bridge.type.FindDocumentQueryType;
import org.eclipse.ohf.bridge.type.GetDocumentQueryType;
import org.eclipse.ohf.bridge.type.PatientIdType;
import org.eclipse.ohf.bridge.type.PatientInfoType;
import org.eclipse.ohf.bridge.type.PatientSearchPreferencesType;
import org.eclipse.ohf.bridge.type.QueryDocumentsResponseType;
import org.eclipse.ohf.bridge.type.ResponseType;
import org.eclipse.ohf.bridge.type.RetrieveDocumentRequestType;
import org.eclipse.ohf.bridge.type.RetrieveDocumentResponseType;
import org.eclipse.ohf.bridge.type.SearchPatientResponseType;
import org.eclipse.ohf.bridge.type.SubmitDocumentResponseType;
import org.eclipse.ohf.bridge.type.XDSDocType;
import org.eclipse.ohf.ihe.atna.audit.client.ATNAAuditClient;
import org.eclipse.ohf.ihe.atna.audit.client.ATNAAuditClientImpl;
import sun.misc.BASE64Decoder;

public class OHFBridge {
    static final Logger mLogger = Logger.getLogger(OHFBridge.class);
    private ATNAAuditClient auditor = new ATNAAuditClientImpl();

    public QueryDocumentsResponseType QueryDocumentsByPatientId(SessionContext sessionContext, PatientIdType patientId, DocumentQueryPreferencesType queryPreferences) throws Throwable {
        QueryDocumentsResponseType response;
        block9: {
            response = null;
            try {
                try {
                    TransactionContext.start((SessionContext)sessionContext);
                    if (Utils.isEmptyOrNull((String)patientId.getIdNumber())) {
                        throw new IllegalArgumentException("patient ID can not be null");
                    }
                    if (mLogger.isDebugEnabled()) {
                        mLogger.debug((Object)("starting QueryDocumentsByPatientId using id [" + patientId + "] and " + queryPreferences));
                    }
                    response = TransactionContext.instant().getXDSBridge().queryDocumentsByPatientId(patientId, queryPreferences);
                    this.checkResponseIntegrity((ResponseType)response);
                    if (mLogger.isDebugEnabled()) {
                        mLogger.debug((Object)("got " + response.getDocumentTypeArray().length + " documents:" + response));
                    }
                }
                catch (Throwable t) {
                    mLogger.error((Object)"failed at QueryDocumentsByPatientId", t);
                    if (response == null) {
                        response = new QueryDocumentsResponseType();
                        this.feedErrorResponse((ResponseType)response, t);
                    }
                    TransactionContext.stop(response);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                TransactionContext.stop(response);
                throw throwable;
            }
            TransactionContext.stop((ResponseType)response);
        }
        return response;
    }

    private void feedErrorResponse(ResponseType response, Throwable t) throws IOException {
        response.setResponse(4);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write((String.valueOf(t.getMessage()) + "/n").getBytes());
        t.printStackTrace(new PrintStream(baos));
        response.setResponseMessage(new String(baos.toByteArray()));
        baos.close();
    }

    public QueryDocumentsResponseType QueryDocumentsFind(SessionContext sessionContext, FindDocumentQueryType queryDocumentQueryType, DocumentQueryPreferencesType queryPreferences) throws Throwable {
        QueryDocumentsResponseType response;
        block9: {
            response = null;
            try {
                try {
                    TransactionContext.start((SessionContext)sessionContext);
                    if (queryDocumentQueryType == null) {
                        throw new IllegalArgumentException("FindDocumentQueryType can not be null");
                    }
                    if (Utils.isEmptyOrNull((String)queryDocumentQueryType.getPatientId().getIdNumber())) {
                        throw new IllegalArgumentException("patient ID must exist");
                    }
                    if (mLogger.isDebugEnabled()) {
                        mLogger.debug((Object)("Starting XDSDocCollection QueryDocuments(" + queryDocumentQueryType + ", " + queryPreferences + ") "));
                    }
                    TransactionContext.instant().getPixPdqResources().normalizePatientInfo(queryDocumentQueryType.getPatientId());
                    response = TransactionContext.instant().getXDSBridge().queryDocuments(queryDocumentQueryType, queryPreferences);
                    this.checkResponseIntegrity((ResponseType)response);
                }
                catch (Throwable t) {
                    mLogger.error((Object)"failed at QueryDocuments", t);
                    if (response == null) {
                        response = new QueryDocumentsResponseType();
                        this.feedErrorResponse((ResponseType)response, t);
                    }
                    TransactionContext.stop(response);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                TransactionContext.stop(response);
                throw throwable;
            }
            TransactionContext.stop((ResponseType)response);
        }
        return response;
    }

    public QueryDocumentsResponseType QueryDocumentsGet(SessionContext sessionContext, GetDocumentQueryType getDocumentQueryType, DocumentQueryPreferencesType queryPreferences) throws Throwable {
        QueryDocumentsResponseType response;
        block9: {
            response = null;
            try {
                try {
                    TransactionContext.start((SessionContext)sessionContext);
                    if (getDocumentQueryType == null) {
                        throw new IllegalArgumentException("FindDocumentQueryType can not be null");
                    }
                    if (getDocumentQueryType.getDocumentIds().length == 0) {
                        throw new IllegalArgumentException("there must be at least one id");
                    }
                    if (mLogger.isDebugEnabled()) {
                        mLogger.debug((Object)("Starting XDSDocCollection QueryDocuments(" + getDocumentQueryType + ") and " + queryPreferences));
                    }
                    response = TransactionContext.instant().getXDSBridge().queryDocuments(getDocumentQueryType, queryPreferences);
                    this.checkResponseIntegrity((ResponseType)response);
                }
                catch (Throwable t) {
                    mLogger.error((Object)"failed at QueryDocuments", t);
                    if (response == null) {
                        response = new QueryDocumentsResponseType();
                        this.feedErrorResponse((ResponseType)response, t);
                    }
                    TransactionContext.stop(response);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                TransactionContext.stop(response);
                throw throwable;
            }
            TransactionContext.stop((ResponseType)response);
        }
        return response;
    }

    public RetrieveDocumentResponseType RetrieveDocumentByUrl(SessionContext sessionContext, String url, PatientIdType patientId, String documentUniqueId) throws Throwable {
        RetrieveDocumentResponseType response;
        block7: {
            response = null;
            try {
                try {
                    TransactionContext.start((SessionContext)sessionContext);
                    if (mLogger.isDebugEnabled()) {
                        mLogger.debug((Object)("Starting XDSDocType GetDocumentByUrl(" + url + ") "));
                    }
                    response = TransactionContext.instant().getXDSBridge().retrieveDocumentByUrl(url, patientId, documentUniqueId);
                    this.checkResponseIntegrity((ResponseType)response);
                }
                catch (Throwable t) {
                    mLogger.error((Object)"failed at GetDocumentByUrl", t);
                    if (response == null) {
                        response = new RetrieveDocumentResponseType();
                        this.feedErrorResponse((ResponseType)response, t);
                    }
                    TransactionContext.stop(response);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TransactionContext.stop(response);
                throw throwable;
            }
            TransactionContext.stop((ResponseType)response);
        }
        return response;
    }

    public RetrieveDocumentResponseType RetrieveDocumentSet(SessionContext sessionContext, RetrieveDocumentRequestType rdoc, PatientIdType patientId) throws Throwable {
        RetrieveDocumentResponseType response;
        block7: {
            response = null;
            try {
                try {
                    TransactionContext.start((SessionContext)sessionContext);
                    if (mLogger.isDebugEnabled()) {
                        mLogger.debug((Object)"Starting XDS.b RetrieveDocumentSet() ");
                    }
                    response = TransactionContext.instant().getXDSBridge().retrieveDocumentSet(rdoc);
                    this.checkResponseIntegrity((ResponseType)response);
                }
                catch (Throwable t) {
                    mLogger.error((Object)"failed at RetrieveDocumentSet", t);
                    if (response == null) {
                        response = new RetrieveDocumentResponseType();
                        this.feedErrorResponse((ResponseType)response, t);
                    }
                    TransactionContext.stop((ResponseType)response);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TransactionContext.stop(response);
                throw throwable;
            }
            TransactionContext.stop((ResponseType)response);
        }
        return response;
    }

    public SubmitDocumentResponseType WrapInCdaAndSubmitDocument(SessionContext sessionContext, XDSDocType doc) throws Throwable {
        SubmitDocumentResponseType response;
        block7: {
            response = null;
            try {
                try {
                    TransactionContext.start((SessionContext)sessionContext);
                    if (mLogger.isDebugEnabled()) {
                        mLogger.debug((Object)("Starting String SubmitDocument(" + doc + ") "));
                    }
                    response = TransactionContext.instant().getXDSBridge().embedInCdaAndSendDocument(doc);
                    this.checkResponseIntegrity((ResponseType)response);
                }
                catch (Throwable t) {
                    mLogger.error((Object)"failed at SubmitDocument", t);
                    if (response == null) {
                        response = new SubmitDocumentResponseType();
                        this.feedErrorResponse((ResponseType)response, t);
                    }
                    TransactionContext.stop((ResponseType)response);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TransactionContext.stop(response);
                throw throwable;
            }
            TransactionContext.stop((ResponseType)response);
        }
        return response;
    }

    public SubmitDocumentResponseType SubmitDocument(SessionContext sessionContext, String base64EncodedDocument, DocumentSubmissionMetadataType metadata) throws Throwable {
        SubmitDocumentResponseType response;
        block7: {
            response = null;
            try {
                try {
                    TransactionContext.start((SessionContext)sessionContext);
                    if (!metadata.getDocumentType().equals("CDA")) {
                        throw new IllegalArgumentException("Document type should be CDA and not " + metadata.getDocumentType());
                    }
                    BASE64Decoder decoder = new BASE64Decoder();
                    String cdaDocument = new String(decoder.decodeBuffer(base64EncodedDocument));
                    response = TransactionContext.instant().getXDSBridge().addCDADocument(cdaDocument, metadata);
                    this.checkResponseIntegrity((ResponseType)response);
                }
                catch (Throwable t) {
                    mLogger.error((Object)"failed at SubmitRawDocument", t);
                    if (response == null) {
                        response = new SubmitDocumentResponseType();
                        this.feedErrorResponse((ResponseType)response, t);
                    }
                    TransactionContext.stop(response);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TransactionContext.stop(response);
                throw throwable;
            }
            TransactionContext.stop((ResponseType)response);
        }
        return response;
    }

    public SearchPatientResponseType SearchPatient(SessionContext sessionContext, PatientInfoType patientInfo, PatientSearchPreferencesType queryPreferences) throws Throwable {
        SearchPatientResponseType response;
        block12: {
            response = null;
            try {
                try {
                    PatientSearchPreferencesType type;
                    TransactionContext.start((SessionContext)sessionContext);
                    if (mLogger.isDebugEnabled()) {
                        mLogger.debug((Object)("Starting PatientInfoType[] SearchPatient(" + patientInfo + ", " + queryPreferences + ")"));
                    }
                    if ((type = queryPreferences) == null) {
                        type = PatientSearchPreferencesType.DEFAULT_SEARCH_LIMITATIONS;
                    }
                    response = TransactionContext.instant().getPatientConsumerBridge().searchPatient(patientInfo, type);
                    this.checkResponseIntegrity((ResponseType)response);
                    if (mLogger.isDebugEnabled()) {
                        if (response.getPatients() != null) {
                            mLogger.debug((Object)("got " + response.getPatients().length + " in response:"));
                            int i = 0;
                            while (i < response.getPatients().length) {
                                mLogger.debug((Object)response.getPatients()[i]);
                                ++i;
                            }
                        } else {
                            mLogger.debug((Object)"Got no patients back");
                        }
                    }
                    this.checkResponseIntegrity((ResponseType)response);
                }
                catch (Throwable t) {
                    mLogger.error((Object)"failed at SearchPatient", t);
                    if (response == null) {
                        response = new SearchPatientResponseType();
                        this.feedErrorResponse((ResponseType)response, t);
                    }
                    TransactionContext.stop(response);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                TransactionContext.stop(response);
                throw throwable;
            }
            TransactionContext.stop((ResponseType)response);
        }
        return response;
    }

    public ResponseType AdmitInpatient(SessionContext sessionContext, PatientInfoType patientInfo) throws Throwable {
        ResponseType response;
        block7: {
            response = null;
            try {
                try {
                    TransactionContext.start((SessionContext)sessionContext);
                    if (mLogger.isDebugEnabled()) {
                        mLogger.debug((Object)("Admitting new inpatient " + patientInfo));
                    }
                    response = TransactionContext.instant().getPIXSourceBridge().admitInpatient(patientInfo);
                    this.checkResponseIntegrity(response);
                }
                catch (Throwable t) {
                    mLogger.error((Object)"failed at AdmitInpatient", t);
                    if (response == null) {
                        response = new ResponseType();
                        this.feedErrorResponse(response, t);
                    }
                    TransactionContext.stop((ResponseType)response);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TransactionContext.stop(response);
                throw throwable;
            }
            TransactionContext.stop((ResponseType)response);
        }
        return response;
    }

    public ResponseType RegisterOutpatient(SessionContext sessionContext, PatientInfoType patientInfo) throws Throwable {
        ResponseType response;
        block7: {
            response = null;
            try {
                try {
                    TransactionContext.start((SessionContext)sessionContext);
                    if (mLogger.isDebugEnabled()) {
                        mLogger.debug((Object)("Registering new patient " + patientInfo));
                    }
                    response = TransactionContext.instant().getPIXSourceBridge().registerOutpatient(patientInfo);
                    this.checkResponseIntegrity(response);
                }
                catch (Throwable t) {
                    mLogger.error((Object)"failed at RegisterOutpatient", t);
                    if (response == null) {
                        response = new ResponseType();
                        this.feedErrorResponse(response, t);
                    }
                    TransactionContext.stop((ResponseType)response);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TransactionContext.stop(response);
                throw throwable;
            }
            TransactionContext.stop((ResponseType)response);
        }
        return response;
    }

    public ResponseType PreAdmitInpatient(SessionContext sessionContext, PatientInfoType patientInfo) throws Throwable {
        ResponseType response;
        block7: {
            response = null;
            try {
                try {
                    TransactionContext.start((SessionContext)sessionContext);
                    if (mLogger.isDebugEnabled()) {
                        mLogger.debug((Object)("Preadmitting inpatient " + patientInfo));
                    }
                    response = TransactionContext.instant().getPIXSourceBridge().preAdmitInpatient(patientInfo);
                    this.checkResponseIntegrity(response);
                }
                catch (Throwable t) {
                    mLogger.error((Object)"failed at PreAdmitInpatient", t);
                    if (response == null) {
                        response = new ResponseType();
                        this.feedErrorResponse(response, t);
                    }
                    TransactionContext.stop((ResponseType)response);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TransactionContext.stop(response);
                throw throwable;
            }
            TransactionContext.stop((ResponseType)response);
        }
        return response;
    }

    public ResponseType UpdateOutPatient(SessionContext sessionContext, PatientInfoType patientInfo) throws Throwable {
        ResponseType response;
        block7: {
            response = null;
            try {
                try {
                    TransactionContext.start((SessionContext)sessionContext);
                    if (mLogger.isDebugEnabled()) {
                        mLogger.debug((Object)("Updating out patient " + patientInfo));
                    }
                    response = TransactionContext.instant().getPIXSourceBridge().updateOutPatient(patientInfo);
                    this.checkResponseIntegrity(response);
                }
                catch (Throwable t) {
                    mLogger.error((Object)"failed at UpdateOutPatient", t);
                    if (response == null) {
                        response = new ResponseType();
                        this.feedErrorResponse(response, t);
                    }
                    TransactionContext.stop((ResponseType)response);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TransactionContext.stop(response);
                throw throwable;
            }
            TransactionContext.stop((ResponseType)response);
        }
        return response;
    }

    public ResponseType UpdateInPatient(SessionContext sessionContext, PatientInfoType patientInfo) throws Throwable {
        ResponseType response;
        block7: {
            response = null;
            try {
                try {
                    TransactionContext.start((SessionContext)sessionContext);
                    if (mLogger.isDebugEnabled()) {
                        mLogger.debug((Object)("Updating in patient " + patientInfo));
                    }
                    response = TransactionContext.instant().getPIXSourceBridge().updateInPatient(patientInfo);
                    this.checkResponseIntegrity(response);
                }
                catch (Throwable t) {
                    mLogger.error((Object)"failed at UpdateInPatient", t);
                    if (response == null) {
                        response = new ResponseType();
                        this.feedErrorResponse(response, t);
                    }
                    TransactionContext.stop((ResponseType)response);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TransactionContext.stop(response);
                throw throwable;
            }
            TransactionContext.stop((ResponseType)response);
        }
        return response;
    }

    public ResponseType MergePatient(SessionContext sessionContext, PatientInfoType patientInfoTarget, String patientClassTarget, PatientInfoType patientInfoMerge) throws Throwable {
        ResponseType response;
        block7: {
            response = null;
            try {
                try {
                    TransactionContext.start((SessionContext)sessionContext);
                    if (mLogger.isDebugEnabled()) {
                        mLogger.debug((Object)("Merging patient with target " + patientInfoTarget));
                    }
                    response = TransactionContext.instant().getPIXSourceBridge().mergePatient(patientInfoTarget, patientClassTarget, patientInfoMerge);
                    this.checkResponseIntegrity(response);
                }
                catch (Throwable t) {
                    mLogger.error((Object)"failed at MergePatient", t);
                    if (response == null) {
                        response = new ResponseType();
                        this.feedErrorResponse(response, t);
                    }
                    TransactionContext.stop(response);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TransactionContext.stop(response);
                throw throwable;
            }
            TransactionContext.stop((ResponseType)response);
        }
        return response;
    }

    public ResponseType AuditPhiImport(SessionContext sessionContext, int eventOutcome, String dataSourceId, PatientIdType[] patientIds, String[] importedDataId) throws Throwable {
        ResponseType response;
        block7: {
            response = null;
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"PhiImport");
            }
            try {
                try {
                    TransactionContext.start((SessionContext)sessionContext);
                    this.verifyAuditEnabled();
                    this.auditor.auditPHIImportEvent(eventOutcome, dataSourceId, this.toPatienStrings(patientIds)[0], importedDataId, null);
                    response = new ResponseType();
                    response.setResponse(0);
                    this.checkResponseIntegrity(response);
                }
                catch (Throwable t) {
                    mLogger.error((Object)"failed at Audit", t);
                    if (response == null) {
                        response = new ResponseType();
                        this.feedErrorResponse(response, t);
                    }
                    TransactionContext.stop(response);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TransactionContext.stop(response);
                throw throwable;
            }
            TransactionContext.stop((ResponseType)response);
        }
        return response;
    }

    public ResponseType AuditPhiExport(SessionContext sessionContext, int eventOutcome, String dataRecipientId, String exportedDataId, PatientIdType patientId) throws Throwable {
        ResponseType response;
        block7: {
            response = null;
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"PhiExport");
            }
            try {
                try {
                    TransactionContext.start((SessionContext)sessionContext);
                    this.verifyAuditEnabled();
                    this.auditor.auditPHIExportEvent(eventOutcome, dataRecipientId, exportedDataId, patientId.toHL7Id(), null, null);
                    response = new ResponseType();
                    response.setResponse(0);
                    this.checkResponseIntegrity(response);
                }
                catch (Throwable t) {
                    mLogger.error((Object)"failed at Audit", t);
                    if (response == null) {
                        response = new ResponseType();
                        this.feedErrorResponse(response, t);
                    }
                    TransactionContext.stop(response);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TransactionContext.stop(response);
                throw throwable;
            }
            TransactionContext.stop((ResponseType)response);
        }
        return response;
    }

    public ResponseType AuditActorStartEvent(SessionContext sessionContext, int eventOutcome) throws Throwable {
        ResponseType response;
        block7: {
            response = null;
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"AuditActorStartEvent");
            }
            try {
                try {
                    TransactionContext.start((SessionContext)sessionContext);
                    this.verifyAuditEnabled();
                    this.auditor.auditActorStartEvent(eventOutcome, sessionContext.getUserApplicationName());
                    response = new ResponseType();
                    response.setResponse(0);
                    this.checkResponseIntegrity(response);
                }
                catch (Throwable t) {
                    mLogger.error((Object)"failed at Audit", t);
                    if (response == null) {
                        response = new ResponseType();
                        this.feedErrorResponse(response, t);
                    }
                    TransactionContext.stop(response);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TransactionContext.stop(response);
                throw throwable;
            }
            TransactionContext.stop((ResponseType)response);
        }
        return response;
    }

    public ResponseType AuditActorStopEvent(SessionContext sessionContext, int eventOutcome) throws Throwable {
        ResponseType response;
        block7: {
            response = null;
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"AuditActorStopEvent");
            }
            try {
                try {
                    TransactionContext.start((SessionContext)sessionContext);
                    this.verifyAuditEnabled();
                    this.auditor.auditActorStopEvent(eventOutcome, sessionContext.getUserApplicationName());
                    response = new ResponseType();
                    response.setResponse(0);
                    this.checkResponseIntegrity(response);
                }
                catch (Throwable t) {
                    mLogger.error((Object)"failed at Audit", t);
                    if (response == null) {
                        response = new ResponseType();
                        this.feedErrorResponse(response, t);
                    }
                    TransactionContext.stop(response);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TransactionContext.stop(response);
                throw throwable;
            }
            TransactionContext.stop((ResponseType)response);
        }
        return response;
    }

    public ResponseType AuditUserAuthenticationLoginEvent(SessionContext sessionContext, int eventOutcome, String initiatingUserName, String initiatingUserNodeIP, String authenticatingNodeIP) throws Throwable {
        ResponseType response;
        block7: {
            response = null;
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"AuditActorStopEvent");
            }
            try {
                try {
                    TransactionContext.start((SessionContext)sessionContext);
                    this.verifyAuditEnabled();
                    this.auditor.auditUserAuthenticationLoginEvent(eventOutcome, initiatingUserName, initiatingUserNodeIP, authenticatingNodeIP);
                    response = new ResponseType();
                    response.setResponse(0);
                    this.checkResponseIntegrity(response);
                }
                catch (Throwable t) {
                    mLogger.error((Object)"failed at Audit", t);
                    if (response == null) {
                        response = new ResponseType();
                        this.feedErrorResponse(response, t);
                    }
                    TransactionContext.stop(response);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TransactionContext.stop(response);
                throw throwable;
            }
            TransactionContext.stop((ResponseType)response);
        }
        return response;
    }

    public ResponseType AuditUserAuthenticationLogoutEvent(SessionContext sessionContext, int eventOutcome, String initiatingUserName, String initiatingUserNodeIP, String authenticatingNodeIP) throws Throwable {
        ResponseType response;
        block7: {
            response = null;
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"AuditActorStopEvent");
            }
            try {
                try {
                    TransactionContext.start((SessionContext)sessionContext);
                    this.verifyAuditEnabled();
                    this.auditor.auditUserAuthenticationLogoutEvent(eventOutcome, initiatingUserName, initiatingUserNodeIP, authenticatingNodeIP);
                    response = new ResponseType();
                    response.setResponse(0);
                    this.checkResponseIntegrity(response);
                }
                catch (Throwable t) {
                    mLogger.error((Object)"failed at Audit", t);
                    if (response == null) {
                        response = new ResponseType();
                        this.feedErrorResponse(response, t);
                    }
                    TransactionContext.stop(response);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TransactionContext.stop(response);
                throw throwable;
            }
            TransactionContext.stop((ResponseType)response);
        }
        return response;
    }

    public ResponseType AuditQueryEvent(SessionContext sessionContext, int eventOutcome, String registryID, String queryText) throws Throwable {
        ResponseType response;
        block7: {
            response = null;
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"AuditQueryEvent");
            }
            try {
                try {
                    TransactionContext.start((SessionContext)sessionContext);
                    this.verifyAuditEnabled();
                    this.auditor.auditQueryEvent(eventOutcome, registryID, queryText, null, null, null);
                    response = new ResponseType();
                    response.setResponse(0);
                    this.checkResponseIntegrity(response);
                }
                catch (Throwable t) {
                    mLogger.error((Object)"failed at Audit", t);
                    if (response == null) {
                        response = new ResponseType();
                        this.feedErrorResponse(response, t);
                    }
                    TransactionContext.stop(response);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TransactionContext.stop(response);
                throw throwable;
            }
            TransactionContext.stop((ResponseType)response);
        }
        return response;
    }

    public ResponseType AuditPatientRecordReadEvent(SessionContext sessionContext, int eventOutcome, PatientIdType patientId) throws Throwable {
        ResponseType response;
        block7: {
            response = null;
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"AuditPatientRecordReadEvent");
            }
            try {
                try {
                    TransactionContext.start((SessionContext)sessionContext);
                    this.verifyAuditEnabled();
                    this.auditor.auditPatientRecordReadEvent(eventOutcome, patientId.toHL7Id());
                    response = new ResponseType();
                    response.setResponse(0);
                    this.checkResponseIntegrity(response);
                }
                catch (Throwable t) {
                    mLogger.error((Object)"failed at Audit", t);
                    if (response == null) {
                        response = new ResponseType();
                        this.feedErrorResponse(response, t);
                    }
                    TransactionContext.stop(response);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TransactionContext.stop(response);
                throw throwable;
            }
            TransactionContext.stop((ResponseType)response);
        }
        return response;
    }

    public ResponseType AuditPatientRecordCreateEvent(SessionContext sessionContext, int eventOutcome, PatientIdType patientId) throws Throwable {
        ResponseType response;
        block7: {
            response = null;
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"AuditPatientRecordCreateEvent");
            }
            try {
                try {
                    TransactionContext.start((SessionContext)sessionContext);
                    this.verifyAuditEnabled();
                    this.auditor.auditPatientRecordCreateEvent(eventOutcome, patientId.toHL7Id());
                    response = new ResponseType();
                    response.setResponse(0);
                    this.checkResponseIntegrity(response);
                }
                catch (Throwable t) {
                    mLogger.error((Object)"failed at Audit", t);
                    if (response == null) {
                        response = new ResponseType();
                        this.feedErrorResponse(response, t);
                    }
                    TransactionContext.stop(response);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TransactionContext.stop(response);
                throw throwable;
            }
            TransactionContext.stop((ResponseType)response);
        }
        return response;
    }

    public ResponseType AuditPatientRecordUpdateEvent(SessionContext sessionContext, int eventOutcome, PatientIdType patientId) throws Throwable {
        ResponseType response;
        block7: {
            response = null;
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"AuditPatientRecordUpdateEvent");
            }
            try {
                try {
                    TransactionContext.start((SessionContext)sessionContext);
                    this.verifyAuditEnabled();
                    this.auditor.auditPatientRecordUpdateEvent(eventOutcome, patientId.toHL7Id());
                    response = new ResponseType();
                    response.setResponse(0);
                    this.checkResponseIntegrity(response);
                }
                catch (Throwable t) {
                    mLogger.error((Object)"failed at Audit", t);
                    if (response == null) {
                        response = new ResponseType();
                        this.feedErrorResponse(response, t);
                    }
                    TransactionContext.stop(response);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TransactionContext.stop(response);
                throw throwable;
            }
            TransactionContext.stop((ResponseType)response);
        }
        return response;
    }

    public ResponseType AuditPatientRecordDeleteEvent(SessionContext sessionContext, int eventOutcome, PatientIdType patientId) throws Throwable {
        ResponseType response;
        block7: {
            response = null;
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"AuditPatientRecordDeleteEvent");
            }
            try {
                try {
                    TransactionContext.start((SessionContext)sessionContext);
                    this.verifyAuditEnabled();
                    this.auditor.auditPatientRecordDeleteEvent(eventOutcome, patientId.toHL7Id());
                    response = new ResponseType();
                    response.setResponse(0);
                    this.checkResponseIntegrity(response);
                }
                catch (Throwable t) {
                    mLogger.error((Object)"failed at Audit", t);
                    if (response == null) {
                        response = new ResponseType();
                        this.feedErrorResponse(response, t);
                    }
                    TransactionContext.stop(response);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                TransactionContext.stop(response);
                throw throwable;
            }
            TransactionContext.stop((ResponseType)response);
        }
        return response;
    }

    private void verifyAuditEnabled() throws UnavailableResourcesException {
        AuditConfig config;
        RhioDedicatedResources resource = TransactionContext.instant().getAllAvailableResources()[0];
        if (resource != null && (config = resource.getRhioConfiguration().getAuditConfig()) != null) {
            String uri;
            IheUri iheUri = config.getAuditUri();
            if (iheUri != null && (uri = TransactionContext.instant().getAllAvailableResources()[0].getRhioConfiguration().getAuditConfig().getAuditUri().defaultUri()) != null) {
                return;
            }
            throw new UnavailableResourcesException("No Audit configured for RHIO " + TransactionContext.instant().getAllAvailableResources()[0].getRhioConfiguration().getName());
        }
        throw new UnavailableResourcesException("No Audit configured");
    }

    private String[] toPatienStrings(PatientIdType[] pPatientIds) {
        ArrayList<String> list = new ArrayList<String>();
        PatientIdType[] patientIdTypeArray = pPatientIds;
        int n = pPatientIds.length;
        int n2 = 0;
        while (n2 < n) {
            PatientIdType id = patientIdTypeArray[n2];
            list.add(id.toHL7Id());
            ++n2;
        }
        return list.toArray(Constants.EMPTY_STRING_ARRAY);
    }

    private void checkResponseIntegrity(ResponseType presponse) {
        if (presponse == null) {
            throw new IllegalStateException("Response is null, but it should not be!");
        }
        if (!presponse.isResponseSet()) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"Don't know if the transaction is a success, somebody forgot to set the success value of the transaction");
            }
            throw new IllegalStateException("Don't know if the transaction is a success");
        }
        if (!presponse.isSuccess() && mLogger.getEffectiveLevel().isGreaterOrEqual((Priority)Level.ERROR)) {
            mLogger.debug((Object)("got error:" + presponse));
        }
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("returning response: " + presponse));
        }
    }

    public RhioConfig[] GetRhios() throws Throwable {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)"getting RHIOs");
        }
        try {
            TransactionContext.start((SessionContext)SessionContext.DEFAULT);
            RhioConfig[] rhios = Configurations.getGlobalConfigurations().getRhios();
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("got " + rhios.length + " rhios"));
            }
            ArrayList<RhioConfig> list = new ArrayList<RhioConfig>();
            RhioConfig[] rhioConfigArray = rhios;
            int n = rhios.length;
            int n2 = 0;
            while (n2 < n) {
                RhioConfig rhio = rhioConfigArray[n2];
                if (!rhio.isHidden()) {
                    list.add(rhio);
                }
                ++n2;
            }
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("found " + list.size() + " not hidden rhios"));
            }
            return list.toArray(new RhioConfig[list.size()]);
        }
        catch (Throwable t) {
            mLogger.error((Object)"failed at GetRhios", t);
            throw t;
        }
    }

    public String Version() {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting String Version() = " + Configurations.getVersion() + " in " + TransactionContext.instant().getSessionContext()));
        }
        return Configurations.getVersion();
    }

    public String[] GetMyLog(SessionContext sessionContext, int startingAtLine) throws Throwable {
        BufferedReader reader = null;
        try {
            TransactionContext.start((SessionContext)sessionContext);
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("Starting GetMyLog(" + startingAtLine + ")"));
            }
            boolean inGetLogBlock = false;
            reader = BridgeTransactionAwareLog4jAppender.INSTANT.getMyLog();
            int i = 0;
            while (i < startingAtLine) {
                reader.readLine();
                ++i;
            }
            ArrayList list = new ArrayList();
            String line = reader.readLine();
            for (int count = 0; line != null && count < 5000; count += line.length()) {
                if (line.indexOf("Starting GetMyLog") > 0) {
                    inGetLogBlock = true;
                }
                Utils.addLineToLogList(list, (String)line);
                line = reader.readLine();
                if (line == null || line.indexOf("end transaction mark for Session Context") <= 0) continue;
                if (inGetLogBlock) {
                    inGetLogBlock = false;
                    continue;
                }
                Utils.addLineToLogList(list, (String)line);
                count += line.length();
                line = reader.readLine();
                Utils.addLineToLogList(list, (String)line);
                count += line.length();
                line = reader.readLine();
                Utils.addLineToLogList(list, (String)line);
                count += line.length();
                line = reader.readLine();
                Utils.addLineToLogList(list, (String)line);
                break;
            }
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("returned " + list.size() + " lines of log"));
            }
            String[] stringArray = list.toArray(new String[list.size()]);
            return stringArray;
        }
        catch (Throwable t) {
            mLogger.error((Object)"failed at GetMyLog", t);
            throw t;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            TransactionContext.stop(null);
        }
    }
}

