/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.utilities.tests;

import java.text.ParseException;
import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.ohf.utilities.xml.XMLDateUtil;

public class XMLDateUtilTest
extends TestCase {
    public final void testDate01() {
        Date test = this.parse("2006-07-04T10:53:52");
        XMLDateUtilTest.assertEquals((int)2006, (int)(test.getYear() + 1900));
        XMLDateUtilTest.assertEquals((int)7, (int)(test.getMonth() + 1));
        XMLDateUtilTest.assertEquals((int)4, (int)test.getDate());
        XMLDateUtilTest.assertEquals((int)10, (int)test.getHours());
        XMLDateUtilTest.assertEquals((int)53, (int)test.getMinutes());
        XMLDateUtilTest.assertEquals((int)52, (int)test.getSeconds());
    }

    public final void testDate02() {
        Date test = this.parse("2006-07-04T10:53:52-03:00");
        XMLDateUtilTest.assertEquals((int)2006, (int)(test.getYear() + 1900));
        XMLDateUtilTest.assertEquals((int)7, (int)(test.getMonth() + 1));
        XMLDateUtilTest.assertEquals((int)4, (int)test.getDate());
        XMLDateUtilTest.assertEquals((int)10, (int)test.getHours());
        XMLDateUtilTest.assertEquals((int)53, (int)test.getMinutes());
        XMLDateUtilTest.assertEquals((int)52, (int)test.getSeconds());
    }

    public final void testInvalidDate() {
        try {
            XMLDateUtil.parseXMLDate((String)"3323--333-22");
        }
        catch (ParseException parseException) {
            return;
        }
        XMLDateUtilTest.fail((String)"Expected parse exception");
    }

    private Date parse(String xmlDate) {
        Date result = null;
        try {
            result = XMLDateUtil.parseXMLDate((String)xmlDate);
        }
        catch (ParseException parseException) {
            XMLDateUtilTest.fail((String)"Parse failed");
        }
        return result;
    }
}

