/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.utilities.tests;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.ohf.utilities.OHFException;
import org.eclipse.ohf.utilities.tests.OHFTestCase;
import org.eclipse.ohf.utilities.xml.XMLWriter;
import org.xmlpull.v1.XmlPullParserException;

public class XMLWriterTests
extends OHFTestCase {
    public final void testPlain() throws OHFException, XmlPullParserException, IOException, InterruptedException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        XMLWriter xml = new XMLWriter((OutputStream)stream, "UTF-8");
        xml.setPretty(false);
        xml.start();
        xml.namespace("urn:testuri.org", "ns");
        xml.open("urn:testuri.org", "n1");
        xml.open("urn:testuri.org", "n2");
        xml.text("test");
        xml.close();
        xml.open("urn:testuri.org", "n2");
        xml.text("test\n");
        xml.close();
        xml.close();
        xml.close();
        String output = stream.toString();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ns:n1 xmlns:ns=\"urn:testuri.org\"><ns:n2>test</ns:n2><ns:n2>test\n</ns:n2></ns:n1>";
        XMLWriterTests.assertTrue((boolean)output.equals(expected));
    }

    public final void testPretty() throws OHFException, XmlPullParserException, IOException, InterruptedException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        XMLWriter xml = new XMLWriter((OutputStream)stream, "UTF-8");
        xml.setPretty(true);
        xml.start();
        xml.namespace("urn:testuri.org", "ns");
        xml.open("urn:testuri.org", "n1");
        xml.open("urn:testuri.org", "n2");
        xml.text("test");
        xml.close();
        xml.open("urn:testuri.org", "n2");
        xml.text("test\n");
        xml.close();
        xml.close();
        xml.close();
        String output = stream.toString();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ns:n1 xmlns:ns=\"urn:testuri.org\">\n  <ns:n2>test</ns:n2>\n  <ns:n2>test\n</ns:n2>\n</ns:n1>";
        System.out.println("\r\noutput");
        System.out.print("--" + output + "--");
        System.out.println("\r\nexpected");
        System.out.print("--" + expected + "--");
        XMLWriterTests.assertTrue((boolean)output.equals(expected));
    }
}

