/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.model;

import org.eclipse.ohf.hl7v2.core.conformance.model.CPElement;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class CPTableItem
extends CPElement {
    private int order;
    private String key;
    private String code;
    private String displayName;
    private int usage;

    public CPTableItem(CPElement owner) {
        super(owner);
    }

    public void clear() {
        super.clear();
        this.order = 0;
        this.key = null;
        this.usage = 0;
        this.displayName = null;
        this.code = null;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getUsage() {
        return this.usage;
    }

    public void setUsage(int usage) {
        this.usage = usage;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int[] getPropertyIds() {
        return this.mergeIds(super.getPropertyIds(), new int[]{6, 7, 8, 9, 10});
    }

    public String getProperty(int id) throws HL7V2Exception {
        switch (id) {
            case 6: {
                return this.getDisplayName();
            }
            case 7: {
                return this.getKey();
            }
            case 8: {
                return this.getDisplayName();
            }
            case 9: {
                return Integer.toString(this.getOrder());
            }
            case 10: {
                return Integer.toString(this.getUsage());
            }
        }
        return super.getProperty(id);
    }

    public void setProperty(int id, String value) throws HL7V2Exception {
        switch (id) {
            case 6: {
                this.setDisplayName(value);
                break;
            }
            case 7: {
                this.setKey(value);
                break;
            }
            case 8: {
                this.setDisplayName(value);
                break;
            }
            case 9: {
                this.setOrder(Integer.parseInt(value));
                break;
            }
            case 10: {
                this.setUsage(Integer.parseInt(value));
                break;
            }
            default: {
                super.setProperty(id, value);
            }
        }
    }

    public String getHumanType() {
        return "Table Item";
    }

    public void defaults() {
        super.defaults();
        this.order = 0;
        this.key = null;
        this.code = null;
        this.displayName = null;
        this.usage = 3;
    }

    public int elementType() {
        return 15;
    }

    public void assign(CPElement source) throws CloneNotSupportedException {
        super.assign(source);
        CPTableItem src = (CPTableItem)source;
        this.order = src.order;
        this.key = src.key;
        this.code = src.code;
        this.displayName = src.displayName;
        this.usage = src.usage;
    }

    public CPTableItem cloneTableItem() throws CloneNotSupportedException {
        return (CPTableItem)this.clone();
    }
}

