/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.model;

import org.eclipse.ohf.hl7v2.core.conformance.model.CPElement;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public abstract class CPTyped
extends CPElement {
    public static final int USAGE_UNKNOWN = 0;
    public static final int USAGE_REQUIRED = 1;
    public static final int USAGE_REQ_OR_EMPTY = 2;
    public static final int USAGE_OPTIONAL = 3;
    public static final int USAGE_CONDITIONAL = 4;
    public static final int USAGE_COND_OR_EMPTY = 5;
    public static final int USAGE_NOT_SUPPORTED = 6;
    private String implementationType;

    public CPTyped(CPElement owner) {
        super(owner);
    }

    public String getImplementationType() {
        return this.implementationType;
    }

    public void setImplementationType(String implementationType) {
        this.implementationType = implementationType;
    }

    public boolean hasImplementationType() {
        return this.implementationType != null && !this.implementationType.equals("");
    }

    public int[] getPropertyIds() {
        return this.mergeIds(super.getPropertyIds(), new int[]{27});
    }

    public String getProperty(int id) throws HL7V2Exception {
        switch (id) {
            case 27: {
                return this.getImplementationType();
            }
        }
        return super.getProperty(id);
    }

    public void setProperty(int id, String value) throws HL7V2Exception {
        switch (id) {
            case 27: {
                this.setImplementationType(value);
                break;
            }
            default: {
                super.setProperty(id, value);
            }
        }
    }

    public void defaults() {
        super.defaults();
        this.implementationType = null;
    }

    public void assign(CPElement source) throws CloneNotSupportedException {
        super.assign(source);
        CPTyped src = (CPTyped)source;
        this.implementationType = src.implementationType;
    }

    public CPTyped cloneTyped() throws CloneNotSupportedException {
        return (CPTyped)this.clone();
    }
}

