/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.operations;

import java.io.File;
import org.eclipse.ohf.hl7v2.core.conformance.CPDocument;
import org.eclipse.ohf.hl7v2.core.conformance.CPManager;
import org.eclipse.ohf.hl7v2.core.conformance.operations.CPPatternApplier;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class CPBuilder {
    private String rootFolder;
    private String namespace;
    private String name;
    private int type;
    private int version;
    private String derivation;
    private boolean applyPattern;

    public boolean isApplyPattern() {
        return this.applyPattern;
    }

    public void setApplyPattern(boolean applyPattern) {
        this.applyPattern = applyPattern;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    public void setRootFolder(String rootFolder) {
        this.rootFolder = rootFolder;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void build() throws HL7V2Exception {
        this.checkParameters();
        CPDocument document = new CPDocument();
        this.buildDocument(document);
        CPManager.save(String.valueOf(this.rootFolder) + File.pathSeparator + this.namespace + File.pathSeparator + this.name + ".hcd", document);
    }

    private void checkParameters() throws HL7V2Exception {
        this.checkStrParamNotBlank(this.rootFolder, "Root Folder");
        this.checkStrParamNotBlank(this.namespace, "Namespace");
        this.checkStrParamNotBlank(this.name, "Name");
        this.checkFolderExists(this.rootFolder, "Root Folder");
        this.checkFolderExists(String.valueOf(this.rootFolder) + File.pathSeparator + this.namespace, "Target Folder");
        this.checkFileDoesntExist(String.valueOf(this.rootFolder) + File.pathSeparator + this.namespace + File.pathSeparator + this.name + ".hcd", "Target Folder");
    }

    private void checkFileDoesntExist(String name, String desc) throws HL7V2Exception {
        File file = new File(name);
        if (file.exists()) {
            throw new HL7V2Exception(String.valueOf(name) + " already exists", 19);
        }
    }

    private void checkFolderExists(String name, String desc) throws HL7V2Exception {
        File folder = new File(name);
        if (!folder.exists() || !folder.isDirectory()) {
            throw new HL7V2Exception(String.valueOf(name) + " not found", 19);
        }
    }

    private void checkStrParamNotBlank(String str, String desc) throws HL7V2Exception {
        if (str == null || str.equals("")) {
            throw new HL7V2Exception(String.valueOf(desc) + " not provided", 19);
        }
    }

    private void buildDocument(CPDocument document) throws HL7V2Exception {
        document.setName(String.valueOf(this.namespace) + "." + this.name);
        document.setDocumentType(this.type);
        document.setHl7Version(this.version);
        document.setDerivation(this.derivation);
        if (this.applyPattern) {
            CPPatternApplier applier = new CPPatternApplier();
            applier.setDestinationType(this.type);
            applier.setDestination(document.getContent());
            applier.setVersion(this.version);
            applier.setSource(this.derivation);
            applier.apply();
        }
    }
}

