/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.definitions;

import java.util.HashMap;
import org.eclipse.ohf.hl7v2.core.definitions.formats.MSAccess;
import org.eclipse.ohf.hl7v2.core.definitions.formats.PrivateFormat;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefnList;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class DefinitionManager {
    public static final String DEFAULT_NAME = "std";
    private static HashMap definitions = new HashMap();

    private static void setName(VersionDefnList versions, String name) {
        versions.setName(name);
        definitions.put(name, versions);
    }

    public static VersionDefnList createDefinitionsFromAccess(String name, String path) throws HL7V2Exception {
        VersionDefnList result = new MSAccess(path).load();
        DefinitionManager.setName(result, name);
        return result;
    }

    public static VersionDefnList createDefinitionsFromPrivateFormat(String name, String path) throws HL7V2Exception {
        VersionDefnList result = new PrivateFormat(path).load();
        DefinitionManager.setName(result, name);
        return result;
    }

    public static VersionDefnList createDefinitionsFromAccess(String path) throws HL7V2Exception {
        return DefinitionManager.createDefinitionsFromAccess(DEFAULT_NAME, path);
    }

    public static VersionDefnList createDefinitionsFromPrivateFormat(String path) throws HL7V2Exception {
        return DefinitionManager.createDefinitionsFromPrivateFormat(DEFAULT_NAME, path);
    }

    public static Object getByPath(String name) throws HL7V2Exception {
        String[] parts = name.split("-");
        if (parts.length != 4) {
            throw new HL7V2Exception("bad path '" + name + "' - wrong number of parts", 19);
        }
        VersionDefnList definition = (VersionDefnList)definitions.get(parts[0]);
        if (definition == null) {
            throw new HL7V2Exception("bad path '" + name + "' - definition '" + parts[0] + "' not found", 19);
        }
        VersionDefn version = definition.itemByVersion(parts[1]);
        return version.getByPath(parts[2], parts[3]);
    }
}

