/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.definitions.formats;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang.StringUtils;
import org.eclipse.ohf.hl7v2.core.definitions.formats.Loader;
import org.eclipse.ohf.hl7v2.core.definitions.model.ComponentDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.DataElementDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.DataTypeDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.EventDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.EventMessageDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.FieldDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.MessageStructureDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.MessageTypeDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.SegmentDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.SegmentGroupDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.SegmentGroupDefnList;
import org.eclipse.ohf.hl7v2.core.definitions.model.StructureDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.TableDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.TableItemDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefnList;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class MSAccess
extends Loader {
    private Connection connection;
    private Statement stmt;
    private String filename;
    private String dbversion = "";
    public static final String FN_VERSION = "HL7_Version";
    public static final String FN_VERSION_ID = "version_id";
    public static final String FN_DESCRIPTION = "Description";
    public static final String FN_SEGCODE = "Seg_Code";
    public static final String FN_DATAITEM = "Data_Item";
    public static final String FN_REQOPT = "Req_Opt";
    public static final String FN_REPNAL = "Repetitional";
    public static final String FN_REPCOUNT = "Repetitions";
    public static final String FN_OPTNAL = "Optional";
    public static final String FN_FIELDNUM_2 = "Lfd_Nr";
    public static final String FN_FIELDNUM_3 = "seq_no";
    public static final String FN_COMPNUM_2 = "Comp_Nr";
    public static final String FN_COMPNUM_3 = "Comp_No";
    public static final String FN_TABLEID = "Table_ID";
    public static final String FN_DTCODE = "Data_Type_Code";
    public static final String FN_DATASTRUC = "Data_Structure";
    public static final String FN_LENGTH = "Length";
    public static final String FN_ELEMENTARY = "Elementary";
    public static final String FN_TABLEVALS = "Table_Value";
    public static final String FN_SORTNUM_2 = "Sort_Nr";
    public static final String FN_SORTNUM_3 = "Sort_No";
    public static final String FN_EVNTCODE = "Event_Code";
    public static final String FN_MESSAGETYPECODE = "message_type";
    public static final String FN_MSGTYPE = "message_type";
    public static final String FN_USAGE = "Usage";
    public static final String FN_TABLETYPE = "Table_Typ";
    public static final String FN_MSG_STRUCT = "Message_Structure";
    public static final String FN_XMPL_EVENT = "Example_Event";
    public static final String FN_XMPL_MTYPE = "Example_Msg_Type";
    public static final String FN_ACTION = "Action";
    public static final String FN_MSGTYP_SEND = "Message_Typ_Snd";
    public static final String FN_MSGTYP_RETN = "Message_Typ_Return";
    public static final String FN_MSGSTRUC_SEND = "Message_Structure_Snd";
    public static final String FN_MSGSTRUC_RETN = "Message_Structure_Return";
    public static final String FN_GROUPNAME = "GroupName";
    public static final String TN_VERSIONS = "Versions";
    public static final String TN_SEGDATELEM = "SegmentDataElements";
    public static final String TN_COMPLIST = "Components";
    public static final String TN_DATAELEM = "DataElements";
    public static final String TN_DATATYPES = "DataTypes";
    public static final String TN_SEGMENTS = "Segments";
    public static final String TN_DATASTRUCS = "DataStructures";
    public static final String TN_DSCOMPS = "DataStructureComponents";
    public static final String TN_TABLES = "Tables";
    public static final String TN_TABLEVALS = "TableValues";
    public static final String TN_EVENTS = "Events";
    public static final String TN_MESSAGETYPES = "MessageTypes";
    public static final String TN_MSGSTRUCTS = "MsgStructIDs";
    public static final String TN_EVENTMSGTYP = "EventMessageTypes";
    public static final String TN_STRUCTSEGS = "MsgStructIDSegments";
    public static final String TN_EVNTMSGSEGS = "EventMessageTypeSegments";

    public MSAccess() {
    }

    public MSAccess(String filename) throws HL7V2Exception {
        this.setFilename(filename);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) throws HL7V2Exception {
        this.filename = filename;
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            String connString = "jdbc:odbc:DRIVER=Microsoft Access Driver (*.mdb);DBQ=" + filename;
            this.connection = DriverManager.getConnection(connString, "", "");
            this.stmt = this.connection.createStatement();
        }
        catch (ClassNotFoundException e) {
            throw new HL7V2Exception(e, 15);
        }
        catch (SQLException e) {
            throw new HL7V2Exception(e, 15);
        }
    }

    public VersionDefnList load() throws HL7V2Exception {
        VersionDefnList versions = new VersionDefnList();
        try {
            int i = 3;
            while (i <= 9) {
                if (this.existsByVersion(i)) {
                    VersionDefn version = new VersionDefn(versions);
                    version.setVersion(i);
                    this.load(version);
                    versions.add(version);
                }
                ++i;
            }
        }
        catch (SQLException e) {
            throw new HL7V2Exception(e, 15);
        }
        return versions;
    }

    private void load(VersionDefn version) throws SQLException {
        this.loadTables(version);
        this.loadDataTypes(version);
        this.loadComponents(version);
        this.loadStructures(version);
        this.loadStructureComponents(version);
        this.loadDataElements(version);
        this.loadSegments(version);
        this.loadSegmentFields(version);
        this.loadMessageStructures(version);
        this.loadSegmentMaps(version);
        this.loadEvents(version);
        this.loadMessageTypes(version);
        this.loadEventMessages(version);
        version.crossLink();
    }

    private String getDBVersion() throws SQLException {
        if (this.dbversion.equals("")) {
            ResultSet rows = this.stmt.executeQuery("select Version from DBVersion");
            rows.next();
            this.dbversion = rows.getString("Version");
        }
        return this.dbversion;
    }

    private boolean isVersion3() throws SQLException {
        return this.getDBVersion().charAt(0) == '3';
    }

    private String getTableName(String name) throws SQLException {
        if (this.getDBVersion().equals("3.1")) {
            return "HL7" + name;
        }
        return name;
    }

    private String getVersionSelect(VersionDefn version) throws SQLException {
        return this.getVersionSelect(version.getVersion());
    }

    private String getVersionSelect(int version) throws SQLException {
        if (this.isVersion3()) {
            return "version_id = (Select version_id from  " + this.getTableName(TN_VERSIONS) + " where " + FN_VERSION + " = '" + VersionDefnList.display(version) + "')";
        }
        return "HL7_Version = '" + VersionDefnList.display(version) + "'";
    }

    private String getSortNumName() throws SQLException {
        if (this.isVersion3()) {
            return FN_SORTNUM_3;
        }
        return FN_SORTNUM_2;
    }

    private String getCompNumName() throws SQLException {
        if (this.isVersion3()) {
            return FN_COMPNUM_3;
        }
        return FN_COMPNUM_2;
    }

    private String getFieldNumName() throws SQLException {
        if (this.isVersion3()) {
            return FN_FIELDNUM_3;
        }
        return FN_FIELDNUM_2;
    }

    public boolean existsByVersion(VersionDefn version) throws SQLException {
        return this.existsByVersion(version.getVersion());
    }

    public boolean existsByVersion(int version) throws SQLException {
        String sql = "select Description from " + this.getTableName(TN_VERSIONS) + " where " + this.getVersionSelect(version);
        ResultSet rows = this.stmt.executeQuery(sql);
        return rows.next();
    }

    public String getDescription(boolean bShort) {
        if (bShort) {
            return "Access DB";
        }
        return "Access Database " + this.filename;
    }

    protected void loadTables(VersionDefn version) throws SQLException {
        String sql = "select Table_ID, Description from " + this.getTableName(TN_TABLES) + " where " + this.getVersionSelect(version);
        ResultSet rows = this.stmt.executeQuery(sql);
        while (rows.next()) {
            TableDefn table = new TableDefn(version);
            int id = rows.getInt(1);
            table.setId(id);
            table.setName(StringUtils.leftPad((String)Integer.toString(id), (int)4, (String)"0"));
            table.setDescription(rows.getString(2));
            version.getTables().add(table);
        }
        ResultSet rows2 = this.stmt.executeQuery("select Table_ID, Table_Value, Description, " + this.getSortNumName() + " from " + this.getTableName(TN_TABLEVALS) + " where " + this.getVersionSelect(version) + " order by " + this.getSortNumName());
        while (rows2.next()) {
            TableItemDefn tableItem = new TableItemDefn(version);
            tableItem.setId(rows2.getInt(4));
            tableItem.setName(rows2.getString(2));
            tableItem.setDescription(rows2.getString(3));
            version.getTables().itemById(rows2.getInt(1)).getItems().add(tableItem);
        }
    }

    protected void loadComponents(VersionDefn version) throws SQLException {
        ResultSet rows = this.stmt.executeQuery("select " + this.getCompNumName() + ", " + FN_DESCRIPTION + ", " + FN_TABLEID + ", " + FN_DTCODE + " from " + this.getTableName(TN_COMPLIST) + " where " + this.getVersionSelect(version));
        while (rows.next()) {
            ComponentDefn component = new ComponentDefn(version);
            component.setName(rows.getString(2));
            component.setTableId(rows.getInt(3));
            component.setDataTypeCode(rows.getString(4));
            component.setNumber(rows.getInt(1));
            version.getComponents().add(component);
        }
    }

    protected void loadDataElements(VersionDefn version) throws SQLException {
        ResultSet rows = this.stmt.executeQuery("select Data_Item, Description, Data_Structure, Length, Table_ID from " + this.getTableName(TN_DATAELEM) + " where " + this.getVersionSelect(version));
        while (rows.next()) {
            DataElementDefn de = new DataElementDefn(version);
            de.setDescription(rows.getString(2));
            de.setStructure(rows.getString(3));
            de.setLength(rows.getInt(4));
            de.setTableId(rows.getInt(5));
            de.setId(rows.getInt(1));
            version.getDataElements().add(de);
        }
    }

    protected void loadSegments(VersionDefn version) throws SQLException {
        ResultSet rows = this.stmt.executeQuery("select Description, Seg_Code from " + this.getTableName(TN_SEGMENTS) + " where " + this.getVersionSelect(version) + " order by " + FN_SEGCODE + " asc");
        while (rows.next()) {
            SegmentDefn segment = new SegmentDefn(version);
            segment.setName(rows.getString(2));
            segment.setDescription(rows.getString(1));
            version.getSegments().add(segment);
        }
    }

    protected void loadSegmentFields(VersionDefn version, SegmentDefn segment) throws SQLException {
        ResultSet rows = this.stmt.executeQuery("select Data_Item, Req_Opt, Repetitional, Repetitions, " + this.getFieldNumName() + " from " + this.getTableName(TN_SEGDATELEM) + " where " + FN_SEGCODE + " = '" + segment.getName() + "' " + "and " + this.getVersionSelect(version) + " order by " + this.getFieldNumName());
        while (rows.next()) {
            FieldDefn field = new FieldDefn(version);
            field.setDataElementId(rows.getInt(1));
            field.setRequired(rows.getString(2).equals("R"));
            field.setRepeatCount(rows.getInt(4));
            field.setRepeatable(field.getRepeatCount() > 0 | rows.getString(3).equals("Y"));
            field.setNumber(rows.getInt(5));
            segment.getFields().add(field);
        }
    }

    protected void loadSegmentFields(VersionDefn version) throws SQLException {
        ResultSet rows = this.stmt.executeQuery("select Data_Item, Req_Opt, Repetitional, Repetitions, " + this.getFieldNumName() + ", " + FN_SEGCODE + " from " + this.getTableName(TN_SEGDATELEM) + " where " + this.getVersionSelect(version) + " order by " + FN_SEGCODE + ", " + this.getFieldNumName());
        while (rows.next()) {
            SegmentDefn segment = version.getSegments().itemByName(rows.getString(6));
            FieldDefn field = new FieldDefn(version);
            field.setDataElementId(rows.getInt(1));
            String s = rows.getString(2);
            field.setRequired(s != null && s.equals("R"));
            field.setRepeatCount(rows.getInt(4));
            s = rows.getString(3);
            field.setRepeatable(field.getRepeatCount() > 0 | s != null && s.equals("Y"));
            field.setNumber(rows.getInt(5));
            segment.getFields().add(field);
        }
    }

    protected void loadDataTypes(VersionDefn version) throws SQLException {
        ResultSet rows = this.stmt.executeQuery("select Data_Type_Code, Description, Length from " + this.getTableName(TN_DATATYPES) + " where " + this.getVersionSelect(version));
        while (rows.next()) {
            DataTypeDefn dataType = new DataTypeDefn(version);
            dataType.setName(rows.getString(1));
            dataType.setDescription(rows.getString(2));
            dataType.setLength(rows.getInt(3));
            version.getDataTypes().add(dataType);
        }
    }

    protected void loadStructures(VersionDefn version) throws SQLException {
        ResultSet rows = this.stmt.executeQuery("select Data_Structure, Description, Data_Type_Code, Elementary from " + this.getTableName(TN_DATASTRUCS) + " where " + this.getVersionSelect(version));
        while (rows.next()) {
            StructureDefn structure = new StructureDefn(version);
            structure.setName(rows.getString(1));
            structure.setDescription(rows.getString(2));
            structure.setDataTypeCode(rows.getString(3));
            structure.setId(rows.getInt(4));
            version.getStructures().add(structure);
        }
    }

    protected void loadStructureComponents(VersionDefn version) throws SQLException {
        String sLast = "";
        StructureDefn structure = null;
        ComponentDefn component = null;
        ResultSet rows = this.stmt.executeQuery("select Data_Structure, " + this.getCompNumName() + " from " + this.getTableName(TN_DSCOMPS) + " where " + this.getVersionSelect(version) + " order by " + FN_DATASTRUC + ", " + this.getFieldNumName());
        while (rows.next()) {
            String sCurr = rows.getString(1);
            if (sCurr != sLast) {
                sLast = sCurr;
                structure = version.getStructures().itemByName(sLast);
            }
            component = version.getComponents().itemByNumber(rows.getInt(2));
            structure.getComponents().add(component);
        }
    }

    protected void loadMessageTypes(VersionDefn version) throws SQLException {
        ResultSet rows = this.stmt.executeQuery("select message_type, Description from " + this.getTableName(TN_MESSAGETYPES) + " where " + this.getVersionSelect(version));
        while (rows.next()) {
            MessageTypeDefn MessageType = new MessageTypeDefn(version);
            MessageType.setName(rows.getString(1));
            MessageType.setDescription(rows.getString(2));
            version.getMessageTypes().add(MessageType);
        }
    }

    protected void loadEvents(VersionDefn version) throws SQLException {
        ResultSet rows = this.stmt.executeQuery("select Event_Code, Description from " + this.getTableName(TN_EVENTS) + " where " + this.getVersionSelect(version));
        while (rows.next()) {
            EventDefn event = new EventDefn(version);
            event.setName(rows.getString(1));
            event.setDescription(rows.getString(2));
            version.getEvents().add(event);
        }
    }

    protected void loadEventMessages(VersionDefn version) throws SQLException {
        ResultSet rows = this.stmt.executeQuery("select Event_Code, Message_Typ_Snd, Message_Typ_Return, Message_Structure_Snd, Message_Structure_Return from " + this.getTableName(TN_EVENTMSGTYP) + " where " + this.getVersionSelect(version));
        while (rows.next()) {
            EventDefn event = version.getEvents().itemByName(rows.getString(1));
            EventMessageDefn message = new EventMessageDefn(version);
            message.setMessage(rows.getString(2));
            message.setStructureCode(rows.getString(4));
            message.setReply(rows.getString(3));
            message.setReplyStructureCode(rows.getString(5));
            event.getMessages().add(message);
        }
    }

    protected void loadMessageStructures(VersionDefn version) throws SQLException {
        ResultSet rows = this.stmt.executeQuery("select Message_Structure, Description, Example_Event, Example_Msg_Type, Action from " + this.getTableName(TN_MSGSTRUCTS) + " where " + this.getVersionSelect(version));
        while (rows.next()) {
            MessageStructureDefn messageStructure = new MessageStructureDefn(version);
            messageStructure.setName(rows.getString(1));
            messageStructure.setDescription(rows.getString(2));
            messageStructure.setExampleEvent(rows.getString(3));
            messageStructure.setExampleMessageType(rows.getString(4));
            messageStructure.setAction(rows.getString(5));
            version.getMessageStructures().add(messageStructure);
        }
    }

    protected void loadSegmentMaps(VersionDefn version) throws SQLException {
        this.loadSegmentMapsFromStructureSegs(version);
        this.loadSegmentMapsFromEventMessageSegs(version);
    }

    private void findSegment(VersionDefn version, MessageStructureDefn structure, SegmentGroupDefnList stack, ResultSet rows) throws SQLException {
        boolean hasGroup;
        SegmentGroupDefn focus = stack.item(0);
        SegmentGroupDefn group = null;
        String sName = rows.getString(FN_SEGCODE);
        String sGroup = rows.getString(FN_GROUPNAME);
        boolean bl = hasGroup = sGroup != null && !sGroup.equals("");
        if (sName.equals("{") | sName.equals("<") | sName.equals("[") | sName.equals("{[") | sName.equals("[{")) {
            if (sName.equals("{")) {
                if (!hasGroup && focus.getChildren().size() == 0) {
                    focus.setRepeating(true);
                } else {
                    group = new SegmentGroupDefn(version, sGroup, sGroup, false, true, 1);
                }
            } else if (sName.equals("<")) {
                group = new SegmentGroupDefn(version, sGroup, sGroup, false, true, 2);
            } else if (sName.equals("[")) {
                if (!hasGroup && focus.getChildren().size() == 0) {
                    focus.setOptional(true);
                } else {
                    group = new SegmentGroupDefn(version, sGroup, sGroup, true, false, 1);
                }
            } else {
                group = new SegmentGroupDefn(version, sGroup, sGroup, true, true, 1);
            }
            if (group != null) {
                focus.getChildren().add(group);
                stack.insert(0, group);
            } else {
                stack.insert(0, focus);
            }
        } else if (sName.equals("}]") | sName.equals("]}") | sName.equals("}") | sName.equals("]") | sName.equals(">")) {
            stack.delete(0);
        } else if (!sName.equals("|")) {
            group = new SegmentGroupDefn(version, sName, sName, rows.getInt(FN_OPTNAL) == 1, rows.getInt(FN_REPNAL) == 1, 0);
            focus.getChildren().add(group);
        }
    }

    private void loadSegmentMapsFromEventMessageSegs(VersionDefn version) throws SQLException {
        SegmentGroupDefnList stack = new SegmentGroupDefnList();
        String sLast = "";
        MessageStructureDefn structure = null;
        ResultSet rows = this.stmt.executeQuery("select Message_Structure, " + this.getFieldNumName() + ", " + FN_SEGCODE + ", " + FN_GROUPNAME + ", " + FN_REPNAL + ", " + FN_OPTNAL + " from " + this.getTableName(TN_STRUCTSEGS) + " where " + this.getVersionSelect(version) + " order by " + FN_MSG_STRUCT + ", " + this.getFieldNumName());
        while (rows.next()) {
            String s = rows.getString(1);
            if (!s.equals(sLast)) {
                sLast = s;
                structure = version.getMessageStructures().itemByName(sLast);
                structure.setMap(new SegmentGroupDefn(version));
                structure.getMap().setName(sLast);
                structure.getMap().setGroupType(1);
                stack.clear();
                stack.add(structure.getMap());
            }
            if (structure == null) continue;
            this.findSegment(version, structure, stack, rows);
        }
    }

    private void loadSegmentMapsFromStructureSegs(VersionDefn version) throws SQLException {
        SegmentGroupDefnList stack = new SegmentGroupDefnList();
        String sLast = "";
        MessageStructureDefn structure = null;
        ResultSet rows = this.stmt.executeQuery("select Event_Code, message_type, " + this.getFieldNumName() + ", " + FN_SEGCODE + ", " + FN_GROUPNAME + ", " + FN_REPNAL + ", " + FN_OPTNAL + " from " + this.getTableName(TN_EVNTMSGSEGS) + " where " + this.getVersionSelect(version) + " order by " + "message_type" + ", " + FN_EVNTCODE + ", " + this.getFieldNumName());
        while (rows.next()) {
            String sCurr = String.valueOf(rows.getString(2)) + "_" + rows.getString(1);
            if (!sCurr.equals(sLast)) {
                sLast = sCurr;
                structure = version.getMessageStructures().itemByName(sLast);
                if (structure == null) {
                    structure = new MessageStructureDefn(version);
                    structure.setName(sLast);
                    structure.setDescription("(Implicitly Created)");
                    version.getMessageStructures().add(structure);
                }
                structure.setMap(new SegmentGroupDefn(version));
                structure.getMap().setName(sLast);
                structure.getMap().setGroupType(1);
                stack.clear();
                stack.add(structure.getMap());
            }
            if (structure == null) continue;
            this.findSegment(version, structure, stack, rows);
        }
    }
}

