/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.definitions.model;

import org.eclipse.ohf.hl7v2.core.definitions.model.NamedDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.SegmentDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.SegmentGroupDefnList;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefn;

public class SegmentGroupDefn
extends NamedDefn {
    private static final long serialVersionUID = -1983689234600537352L;
    private boolean optional;
    private boolean repeating;
    private int groupType;
    private SegmentGroupDefnList children = new SegmentGroupDefnList();
    public static final int gtSingle = 0;
    public static final int gtGroup = 1;
    public static final int gtChoice = 2;

    public SegmentGroupDefn(VersionDefn version, String code, String description, boolean optional, boolean repeating, int groupType) {
        super(version);
        this.setName(code);
        this.setDescription(description);
        this.optional = optional;
        this.repeating = repeating;
        this.groupType = groupType;
    }

    public SegmentGroupDefn(VersionDefn version) {
        super(version);
    }

    public String typeName() {
        return "grp";
    }

    public int getGroupType() {
        return this.groupType;
    }

    public void setGroupType(int groupType) {
        this.groupType = groupType;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public boolean isRepeating() {
        return this.repeating;
    }

    public void setRepeating(boolean repeating) {
        this.repeating = repeating;
    }

    public SegmentGroupDefnList getChildren() {
        return this.children;
    }

    public boolean usesSegment(SegmentDefn segment) {
        if (this.groupType == 0) {
            return this.name.equals(segment.getName());
        }
        boolean result = false;
        int i = 0;
        while (i < this.children.size()) {
            result = result || this.children.item(i).usesSegment(segment);
            ++i;
        }
        return result;
    }
}

