/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message;

import org.eclipse.ohf.hl7v2.core.message.formats.Formats;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.hl7v2.core.utilities.Worker;

public class ParsingOptions
extends Worker {
    public static final int csUnknown = 0;
    public static final int csUTF8 = 1;
    public static final int csUTF16BE = 2;
    public static final int csUTF16LE = 3;
    private int charset;
    private int segmentLimit;
    private int versionOverride;
    private int format;
    private boolean suppressErrors;

    public ParsingOptions() {
        this.reset();
    }

    public void reset() {
        this.segmentLimit = 0;
        this.versionOverride = 0;
        this.format = 0;
        this.suppressErrors = false;
        this.charset = 0;
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int format) throws HL7V2Exception {
        if (!Formats.isValid(format)) {
            throw new HL7V2Exception("Format value is not valid", 19);
        }
        this.format = format;
    }

    public int getSegmentLimit() {
        return this.segmentLimit;
    }

    public void setSegmentLimit(int segmentLimit) {
        this.segmentLimit = segmentLimit;
    }

    public boolean isSuppressErrors() {
        return this.suppressErrors;
    }

    public void setSuppressErrors(boolean suppressErrors) {
        this.suppressErrors = suppressErrors;
    }

    public int getVersionOverride() {
        return this.versionOverride;
    }

    public void setVersionOverride(int versionOverride) {
        this.versionOverride = versionOverride;
    }

    public int getCharset() {
        return this.charset;
    }

    public void setCharset(int charset) throws HL7V2Exception {
        this.condition(this.isValidCharset(charset), "Invalid encoding charset " + Integer.toString(charset), 19);
        this.charset = charset;
    }

    public boolean isValidCharset(int charset2) {
        return this.charset >= 0 && this.charset <= 3;
    }

    public String getCharsetName() throws HL7V2Exception {
        return ParsingOptions.getCharsetName(this.charset);
    }

    public static String getCharsetName(int charset) throws HL7V2Exception {
        switch (charset) {
            case 1: {
                return "UTF-8";
            }
            case 2: {
                return "UTF-16BE";
            }
            case 3: {
                return "UTF-16LE";
            }
        }
        throw new HL7V2Exception("Illegal encoding method", 19);
    }

    public boolean hasCharset() {
        return this.charset != 0;
    }
}

