/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.model;

import org.eclipse.ohf.hl7v2.core.message.model.Content;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class ContentEscape
extends Content {
    private static final long serialVersionUID = -5278645339361225224L;
    private String rawText;

    public ContentEscape(String text) throws HL7V2Exception {
        this.setRawText(text);
    }

    public String getText() {
        return this.getRawText();
    }

    public int getContentType() {
        return 2;
    }

    public String getRawText() {
        return this.rawText;
    }

    public void setRawText(String rawText) throws HL7V2Exception {
        if (!this.valid(rawText)) {
            throw new HL7V2Exception("Invalid escape sequence " + rawText, 20);
        }
        this.rawText = rawText;
    }

    public boolean valid(String rawText) {
        return rawText.equals("H") || rawText.equals("N") || rawText.equals(".br");
    }
}

