/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.model;

import java.io.Serializable;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.hl7v2.core.utilities.Worker;

public class Delimiters
extends Worker
implements Serializable {
    private static final long serialVersionUID = -7793379760194016832L;
    public static final char DEFAULT_DELIMITER_FIELD = '|';
    public static final char DEFAULT_DELIMITER_COMPONENT = '^';
    public static final char DEFAULT_DELIMITER_SUBCOMPONENT = '&';
    public static final char DEFAULT_DELIMITER_REPETITION = '~';
    public static final char DEFAULT_CHARACTER_ESCAPE = '\\';
    private char escapeCharacter;
    private char repetitionDelimiter;
    private char fieldDelimiter;
    private char subComponentDelimiter;
    private char componentDelimiter;

    public Delimiters() {
        this.reset();
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = super.equals(obj) && obj instanceof Delimiters;
        if (result) {
            Delimiters other = (Delimiters)obj;
            result = this.escapeCharacter == other.escapeCharacter && this.repetitionDelimiter == other.repetitionDelimiter && this.fieldDelimiter == other.fieldDelimiter && this.subComponentDelimiter == other.subComponentDelimiter && this.componentDelimiter == other.componentDelimiter;
        }
        return result;
    }

    public char getComponentDelimiter() {
        return this.componentDelimiter;
    }

    public void setComponentDelimiter(char componentDelimiter) {
        this.componentDelimiter = componentDelimiter;
    }

    public char getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public void setEscapeCharacter(char escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    public char getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setFieldDelimiter(char fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
    }

    public char getRepetitionDelimiter() {
        return this.repetitionDelimiter;
    }

    public void setRepetitionDelimiter(char repetitionDelimiter) {
        this.repetitionDelimiter = repetitionDelimiter;
    }

    public char getSubComponentDelimiter() {
        return this.subComponentDelimiter;
    }

    public void setSubComponentDelimiter(char subComponentDelimiter) {
        this.subComponentDelimiter = subComponentDelimiter;
    }

    public void reset() {
        this.fieldDelimiter = (char)124;
        this.componentDelimiter = (char)94;
        this.subComponentDelimiter = (char)38;
        this.repetitionDelimiter = (char)126;
        this.escapeCharacter = (char)92;
    }

    public void check() throws HL7V2Exception {
        this.condition(this.componentDelimiter != this.fieldDelimiter, "Delimiter Error: \"" + this.componentDelimiter + "\" is used for both CPComponent and CPField", 21);
        this.condition(this.subComponentDelimiter != this.fieldDelimiter, "Delimiter Error: \"" + this.subComponentDelimiter + "\" is used for both CPSubComponent and CPField", 21);
        this.condition(this.subComponentDelimiter != this.componentDelimiter, "Delimiter Error: \"" + this.subComponentDelimiter + "\" is used for both CPSubComponent and CPComponent", 21);
        this.condition(this.repetitionDelimiter != this.fieldDelimiter, "Delimiter Error: \"" + this.repetitionDelimiter + "\" is used for both Repetition and CPField", 21);
        this.condition(this.repetitionDelimiter != this.componentDelimiter, "Delimiter Error: \"" + this.repetitionDelimiter + "\" is used for both Repetition and CPComponent", 21);
        this.condition(this.repetitionDelimiter != this.subComponentDelimiter, "Delimiter Error: \"" + this.repetitionDelimiter + "\" is used for both Repetition and CPSubComponent", 21);
        this.condition(this.escapeCharacter != this.fieldDelimiter, "Delimiter Error: \"" + this.escapeCharacter + "\" is used for both Escape and CPField", 21);
        this.condition(this.escapeCharacter != this.componentDelimiter, "Delimiter Error: \"" + this.escapeCharacter + "\" is used for both Escape and CPComponent", 21);
        this.condition(this.escapeCharacter != this.subComponentDelimiter, "Delimiter Error: \"" + this.escapeCharacter + "\" is used for both Escape and CPSubComponent", 21);
        this.condition(this.escapeCharacter != this.repetitionDelimiter, "Delimiter Error: \"" + this.escapeCharacter + "\" is used for both Escape and Repetition", 21);
    }

    public boolean isDelimiter(char ch) {
        return ch == this.escapeCharacter || ch == this.repetitionDelimiter || ch == this.fieldDelimiter || ch == this.subComponentDelimiter || ch == this.componentDelimiter;
    }

    public boolean isCellDelimiter(char ch) {
        return ch == this.repetitionDelimiter || ch == this.fieldDelimiter || ch == this.subComponentDelimiter || ch == this.componentDelimiter;
    }

    public String getEscape(char ch) {
        if (ch == this.escapeCharacter) {
            return String.valueOf(this.escapeCharacter) + "E" + this.escapeCharacter;
        }
        if (ch == this.fieldDelimiter) {
            return String.valueOf(this.escapeCharacter) + "F" + this.escapeCharacter;
        }
        if (ch == this.componentDelimiter) {
            return String.valueOf(this.escapeCharacter) + "S" + this.escapeCharacter;
        }
        if (ch == this.subComponentDelimiter) {
            return String.valueOf(this.escapeCharacter) + "T" + this.escapeCharacter;
        }
        if (ch == this.repetitionDelimiter) {
            return String.valueOf(this.escapeCharacter) + "R" + this.escapeCharacter;
        }
        return null;
    }

    public String forMSH2() {
        return "" + this.componentDelimiter + this.repetitionDelimiter + this.escapeCharacter + this.subComponentDelimiter;
    }

    public boolean isDelimiterEscape(char ch) {
        return ch == 'F' || ch == 'S' || ch == 'E' || ch == 'T' || ch == 'R';
    }

    public char getDelimiterEscapeChar(char ch) throws HL7V2Exception {
        if (ch == 'E') {
            return this.escapeCharacter;
        }
        if (ch == 'F') {
            return this.fieldDelimiter;
        }
        if (ch == 'S') {
            return this.componentDelimiter;
        }
        if (ch == 'T') {
            return this.subComponentDelimiter;
        }
        if (ch == 'R') {
            return this.repetitionDelimiter;
        }
        throw new HL7V2Exception("internal error in getDelimiterEscapeChar", 18);
    }
}

