/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.metadata.transform;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.AssociationType1;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.ClassificationType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.ExternalIdentifierType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.RegistryPackageType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.RimFactory;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.SlotType1;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.StatusType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.ValueListType;
import org.eclipse.ohf.ihe.common.hl7v2.CX;
import org.eclipse.ohf.ihe.common.hl7v2.XCN;
import org.eclipse.ohf.ihe.common.hl7v2.XON;
import org.eclipse.ohf.ihe.common.hl7v2.format.HL7V2MessageFormat;
import org.eclipse.ohf.ihe.xds.metadata.AuthorType;
import org.eclipse.ohf.ihe.xds.metadata.AvailabilityStatusType;
import org.eclipse.ohf.ihe.xds.metadata.InternationalStringType;
import org.eclipse.ohf.ihe.xds.metadata.LocalizedStringType;
import org.eclipse.ohf.ihe.xds.metadata.SubmissionSetType;
import org.eclipse.ohf.ihe.xds.metadata.transform.MetadataTransformationException;
import org.eclipse.ohf.ihe.xds.metadata.transform.SubmissionSetTransformer;

public class EbXML_2_1SubmissionSetTransformer
implements SubmissionSetTransformer {
    public static final String DESCRIPTOR = "EBXML_SS_XFRMR";
    private static final Logger logger = Logger.getLogger(EbXML_2_1SubmissionSetTransformer.class);
    private RegistryPackageType setData = null;
    private AssociationType1[] documentsInSubmissionSet = null;
    private AssociationType1[] foldersInSubmissionSet = null;

    public RegistryPackageType getRegistryPackage() {
        return this.setData;
    }

    public AssociationType1[] getAssociatedDocuments() {
        return this.documentsInSubmissionSet;
    }

    public AssociationType1[] getAssociatedFolders() {
        return this.foldersInSubmissionSet;
    }

    public void transform(SubmissionSetType subSet) throws MetadataTransformationException {
        if (subSet == null) {
            logger.error((Object)"SubmissionSet is null, cannot execute transformation.");
            throw new MetadataTransformationException("SubmissionSet is null, cannot execute transformation.");
        }
        this.setData = RimFactory.eINSTANCE.createRegistryPackageType();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Setting attributes on the Registry Package.");
        }
        this.setRegistryPackageAttributes(subSet);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Setting Description on the Registry Package.");
        }
        this.setData.setDescription(EbXML_2_1SubmissionSetTransformer.copy(subSet.getComments()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Setting Name on the Registry Package.");
        }
        this.setData.setName(EbXML_2_1SubmissionSetTransformer.copy(subSet.getTitle()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Setting Slots on the Registry Package.");
        }
        this.setRegistryPackageSlots(subSet);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Setting Classifications on the Registry Package.");
        }
        this.setRegistryPackageClassifications(subSet);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Setting External Identifiers on the Registry Package.");
        }
        this.setRegistryPackageExternalIdentifiers(subSet);
        this.setAssociatedDocuments(subSet);
        this.setAssociatedFolders(subSet);
    }

    private void setRegistryPackageAttributes(SubmissionSetType subSet) {
        this.setData.setId(subSet.getEntryUUID());
        this.setData.setObjectType("urn:uuid:a54d6aa5-d40d-43f9-88c5-b4633d873bdd");
        if (subSet.isSetAvailabilityStatus()) {
            if (subSet.getAvailabilityStatus().equals(AvailabilityStatusType.APPROVED_LITERAL)) {
                this.setData.setStatus(StatusType.APPROVED_LITERAL);
            } else if (subSet.getAvailabilityStatus().equals(AvailabilityStatusType.DEPRECATED_LITERAL)) {
                this.setData.setStatus(StatusType.DEPRECATED_LITERAL);
            } else if (subSet.getAvailabilityStatus().equals(AvailabilityStatusType.SUBMITTED_LITERAL)) {
                this.setData.setStatus(StatusType.SUBMITTED_LITERAL);
            } else if (subSet.getAvailabilityStatus().equals(AvailabilityStatusType.WITHDRAWN_LITERAL)) {
                this.setData.setStatus(StatusType.WITHDRAWN_LITERAL);
            }
        }
    }

    private void setRegistryPackageSlots(SubmissionSetType subSet) {
        EList slots = this.setData.getSlot();
        SlotType1 slot = RimFactory.eINSTANCE.createSlotType1();
        ValueListType list = RimFactory.eINSTANCE.createValueListType();
        if (subSet.getSubmissionTime() != null) {
            slot = RimFactory.eINSTANCE.createSlotType1();
            list = RimFactory.eINSTANCE.createValueListType();
            slot.setValueList(list);
            slot.setName("submissionTime");
            slot.getValueList().getValue().add((Object)subSet.getSubmissionTime());
            slots.add((Object)slot);
        }
    }

    private void setRegistryPackageClassifications(SubmissionSetType subSet) {
        if (subSet.getContentTypeCode() != null) {
            ClassificationType c = RimFactory.eINSTANCE.createClassificationType();
            c.setClassificationScheme("urn:uuid:aa543740-bdda-424e-8c96-df4873be8500");
            c.setClassifiedObject(subSet.getEntryUUID());
            c.setNodeRepresentation(subSet.getContentTypeCode().getCode());
            c.setName(EbXML_2_1SubmissionSetTransformer.copy(subSet.getContentTypeCode().getDisplayName()));
            if (subSet.getContentTypeCode().getSchemeName() != null) {
                EList slots = c.getSlot();
                SlotType1 slot = RimFactory.eINSTANCE.createSlotType1();
                ValueListType list = RimFactory.eINSTANCE.createValueListType();
                slot.setValueList(list);
                slot.setName("codingScheme");
                slot.getValueList().getValue().add((Object)subSet.getContentTypeCode().getSchemeName());
                slots.add((Object)slot);
            }
            this.setData.getClassification().add((Object)c);
        }
        for (AuthorType author : subSet.getAuthor()) {
            Iterator j;
            ClassificationType c = RimFactory.eINSTANCE.createClassificationType();
            c.setClassificationScheme("urn:uuid:a7058bb9-b4e4-4307-ba5b-e3f0ab85e12d");
            c.setClassifiedObject(subSet.getEntryUUID());
            EList slots = c.getSlot();
            SlotType1 slot = RimFactory.eINSTANCE.createSlotType1();
            ValueListType list = RimFactory.eINSTANCE.createValueListType();
            if (author.getAuthorInstitution() != null && author.getAuthorInstitution().size() > 0) {
                slot.setValueList(list);
                slot.setName("authorInstitution");
                j = author.getAuthorInstitution().iterator();
                while (j.hasNext()) {
                    slot.getValueList().getValue().add((Object)HL7V2MessageFormat.toMessageString((XON)((XON)j.next()), (char)'^', (char)'&'));
                }
                slots.add((Object)slot);
            }
            if (author.getAuthorPerson() != null) {
                slot = RimFactory.eINSTANCE.createSlotType1();
                list = RimFactory.eINSTANCE.createValueListType();
                slot.setValueList(list);
                slot.setName("authorPerson");
                slot.getValueList().getValue().add((Object)HL7V2MessageFormat.toMessageString((XCN)author.getAuthorPerson(), (char)'^', (char)'&'));
                slots.add((Object)slot);
            }
            if (author.getAuthorRole() != null && author.getAuthorRole().size() > 0) {
                slot = RimFactory.eINSTANCE.createSlotType1();
                list = RimFactory.eINSTANCE.createValueListType();
                slot.setValueList(list);
                slot.setName("authorRole");
                j = author.getAuthorRole().iterator();
                while (j.hasNext()) {
                    slot.getValueList().getValue().add((Object)((String)j.next()));
                }
                slots.add((Object)slot);
            }
            if (author.getAuthorSpeciality() != null && author.getAuthorSpeciality().size() > 0) {
                slot = RimFactory.eINSTANCE.createSlotType1();
                list = RimFactory.eINSTANCE.createValueListType();
                slot.setValueList(list);
                slot.setName("authorSpecialty");
                j = author.getAuthorSpeciality().iterator();
                while (j.hasNext()) {
                    slot.getValueList().getValue().add((Object)((String)j.next()));
                }
                slots.add((Object)slot);
            }
            this.setData.getClassification().add((Object)c);
        }
    }

    private void setRegistryPackageExternalIdentifiers(SubmissionSetType subSet) {
        EList externalIdentifiers = this.setData.getExternalIdentifier();
        org.eclipse.ohf.ihe.common.ebxml._2._1.rim.LocalizedStringType idName = RimFactory.eINSTANCE.createLocalizedStringType();
        org.eclipse.ohf.ihe.common.ebxml._2._1.rim.InternationalStringType exIDName = RimFactory.eINSTANCE.createInternationalStringType();
        ExternalIdentifierType exID = RimFactory.eINSTANCE.createExternalIdentifierType();
        if (subSet.getPatientId() != null) {
            exID.setValue(HL7V2MessageFormat.toMessageString((CX)subSet.getPatientId(), (char)'^', (char)'&'));
            idName.setValue("XDSSubmissionSet.patientId");
            exIDName.getLocalizedString().add((Object)idName);
            exID.setName(exIDName);
            exID.setIdentificationScheme("urn:uuid:6b5aea1a-874d-4603-a4bc-96a0a7b38446");
            externalIdentifiers.add((Object)exID);
        }
        exID = RimFactory.eINSTANCE.createExternalIdentifierType();
        if (subSet.getSourceId() != null) {
            exID.setValue(subSet.getSourceId());
            idName = RimFactory.eINSTANCE.createLocalizedStringType();
            idName.setValue("XDSSubmissionSet.sourceId");
            exIDName = RimFactory.eINSTANCE.createInternationalStringType();
            exIDName.getLocalizedString().add((Object)idName);
            exID.setName(exIDName);
            exID.setIdentificationScheme("urn:uuid:554ac39e-e3fe-47fe-b233-965d2a147832");
            externalIdentifiers.add((Object)exID);
        }
        exID = RimFactory.eINSTANCE.createExternalIdentifierType();
        if (subSet.getUniqueId() != null) {
            exID.setValue(subSet.getUniqueId());
            idName = RimFactory.eINSTANCE.createLocalizedStringType();
            idName.setValue("XDSSubmissionSet.uniqueId");
            exIDName = RimFactory.eINSTANCE.createInternationalStringType();
            exIDName.getLocalizedString().add((Object)idName);
            exID.setName(exIDName);
            exID.setIdentificationScheme("urn:uuid:96fdda7c-d067-4183-912e-bf5ee74998a8");
            externalIdentifiers.add((Object)exID);
        }
    }

    private void setAssociatedDocuments(SubmissionSetType subSet) {
        if (subSet.getAssociatedDocuments() != null && !subSet.getAssociatedDocuments().isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Setting Associated Documents.");
            }
            this.documentsInSubmissionSet = new AssociationType1[subSet.getAssociatedDocuments().size()];
            Iterator i = subSet.getAssociatedDocuments().iterator();
            int count = 0;
            while (i.hasNext()) {
                this.documentsInSubmissionSet[count] = RimFactory.eINSTANCE.createAssociationType1();
                this.documentsInSubmissionSet[count].setTargetObject((String)i.next());
                this.documentsInSubmissionSet[count].setAssociationType("urn:uuid:2d03bffb-f426-4830-8413-bab8537a995b");
                this.documentsInSubmissionSet[count].setSourceObject(subSet.getEntryUUID());
                ++count;
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"No Submission Set Associated Documents.");
        }
    }

    private void setAssociatedFolders(SubmissionSetType subSet) {
        if (subSet.getAssociatedFolders() != null && !subSet.getAssociatedFolders().isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Setting Associated Folders.");
            }
            this.foldersInSubmissionSet = new AssociationType1[subSet.getAssociatedFolders().size()];
            Iterator i = subSet.getAssociatedFolders().iterator();
            int count = 0;
            while (i.hasNext()) {
                this.foldersInSubmissionSet[count] = RimFactory.eINSTANCE.createAssociationType1();
                this.foldersInSubmissionSet[count].setTargetObject((String)i.next());
                this.foldersInSubmissionSet[count].setAssociationType("urn:uuid:2d03bffb-f426-4830-8413-bab8537a995b");
                this.foldersInSubmissionSet[count].setSourceObject(subSet.getEntryUUID());
                ++count;
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"No Submission Set Associated Folders.");
        }
    }

    private static org.eclipse.ohf.ihe.common.ebxml._2._1.rim.InternationalStringType copy(InternationalStringType ist) {
        org.eclipse.ohf.ihe.common.ebxml._2._1.rim.InternationalStringType result = RimFactory.eINSTANCE.createInternationalStringType();
        if (ist != null) {
            Iterator i = ist.getLocalizedString().iterator();
            while (i.hasNext()) {
                org.eclipse.ohf.ihe.common.ebxml._2._1.rim.LocalizedStringType lst = RimFactory.eINSTANCE.createLocalizedStringType();
                LocalizedStringType original = (LocalizedStringType)i.next();
                lst.setCharset(original.getCharset());
                lst.setLang(original.getLang());
                lst.setValue(original.getValue());
                result.getLocalizedString().add((Object)lst);
            }
        }
        return result;
    }
}

